StartupEvents.registry('item', event => {
    // Liste des rom de Pokémon et leurs couleurs correspondantes
    const rom = [
		{ rom: 'bug_rom', name: 'Insecte', color: '§c', texture: 'bug_rom' },
        { rom: 'dark_rom', name: 'Ténébres', color: '§c', texture: 'dark_rom' },
        { rom: 'dragon_rom', name: 'Dragon', color: '§d', texture: 'dragon_rom' },
        { rom: 'electric_rom', name: 'Electric', color: '§c', texture: 'electric_rom' },
        { rom: 'fairy_rom', name: 'Fée', color: '§c', texture: 'fairy_rom' },
        { rom: 'fighting_rom', name: 'Combat', color: '§2', texture: 'fighting_rom' },
        { rom: 'fire_rom', name: 'Feu', color: '§a', texture: 'fire_rom' },
        { rom: 'flying_rom', name: 'Vol', color: '§6', texture: 'flying_rom' },
        { rom: 'ghost_rom', name: 'Spectre', color: '§6', texture: 'ghost_rom' },
        { rom: 'grass_rom', name: 'Plante', color: '§1', texture: 'grass_rom' },
        { rom: 'ground_rom', name: 'Sol', color: '§2', texture: 'ground_rom' },
        { rom: 'ice_rom', name: 'Glace', color: '§7', texture: 'ice_rom' },
        { rom: 'poison_rom', name: 'Poison', color: '§7', texture: 'poison_rom' },
        { rom: 'psychic_rom', name: 'Psy', color: '§5', texture: 'psychic_rom' },
        { rom: 'steel_rom', name: 'Acier', color: '§1', texture: 'steel_rom' },
        { rom: 'water_rom', name: 'Eau', color: '§1', texture: 'water_rom' },
		{ rom: 'rock_rom', name: 'Roche', color: '§1', texture: 'rock_rom' }
    ];

    // Création d'un encens pour chaque type
    rom.forEach(romData => {
        event.create(`kubejs:${romData.rom}`)
            .displayName(`${romData.color}ROM ${romData.name}`)
            .tooltip(`Un CD imprégné de la puissance du type ${romData.name}. Lorsqu'elle est utilisée sur un certain Pokémon, celui-ci obtient les pouvoirs du type ${romData.name}.`)
            .rarity('uncommon')
            .texture(`kubejs:item/roms/${romData.texture}`);
    });
});