StartupEvents.registry('item', event => {
    // Liste des plate de Pokémon et leurs couleurs correspondantes
    const plate = [
        { plate: 'blank', name: 'Vierge', color: '§c', texture: 'blank_plate' },
        { plate: 'bug', name: 'Insecte', color: '§d', texture: 'bug_plate' },
        { plate: 'dark', name: 'Tenèbres', color: '§c', texture: 'dark_plate' },
        { plate: 'dragon', name: 'Dragon', color: '§c', texture: 'dragon_plate' },
        { plate: 'electric', name: 'Electrique', color: '§b', texture: 'electric_plate' },
        { plate: 'fairy', name: 'Fée', color: '§9', texture: 'fairy_plate' },
        { plate: 'fighting', name: 'Combat', color: '§2', texture: 'fighting_plate' },
        { plate: 'fire', name: 'Feu', color: '§a', texture: 'fire_plate' },
        { plate: 'flying', name: 'Vol', color: '§6', texture: 'flying_plate' },
        { plate: 'ghost', name: 'Spectre', color: '§6', texture: 'ghost_plate' },
        { plate: 'grass', name: 'Plante', color: '§1', texture: 'grass_plate' },
        { plate: 'ground', name: 'Sol', color: '§2', texture: 'ground_plate' },
        { plate: 'ice', name: 'Glace', color: '§7', texture: 'ice_plate' },
        { plate: 'poison', name: 'Poison', color: '§7', texture: 'poison_plate' },
        { plate: 'psychic', name: 'Psy', color: '§5', texture: 'psychic_plate' },
        { plate: 'steel', name: 'Acier', color: '§1', texture: 'steel_plate' },
		{ plate: 'rock', name: 'Roche', color: '§1', texture: 'rock_plate' },
        { plate: 'water', name: 'Eau', color: '§1', texture: 'water_plate' }
    ];

    // Création d'un encens pour chaque type
    plate.forEach(plateData => {
        event.create(`kubejs:${plateData.plate}_plate`)
            .displayName(`${plateData.color}Plaque ${plateData.name}`)
            .tooltip(`Une tablette en pierre imprégnée de la puissance du type ${plateData.name}. Lorsqu'elle est utilisée sur un certain Pokémon, celui-ci obtient les pouvoirs du type ${plateData.name}.`)
            .rarity('uncommon')
            .texture(`kubejs:item/plates/${plateData.texture}`);
    });
});