﻿// Création des encens pour tous les capsule de Pokémon et rendre les encens fonctionnels
StartupEvents.registry('item', event => {
    // Liste des capsule de Pokémon et leurs couleurs correspondantes
    const capsule = [
        { capsule: 'basic', name: 'Basique', color: '§c', texture: 'basic_capsule' },
        { capsule: 'cherish', name: 'Cherishball', color: '§d', texture: 'cherish_capsule' },
        { capsule: 'copper', name: 'Cuivre', color: '§c', texture: 'copper_capsule' },
        { capsule: 'copper_alt', name: 'Cuivre Alternative', color: '§c', texture: 'copper_alt_capsule' },
        { capsule: 'diamond', name: 'Diamant', color: '§b', texture: 'diamond_capsule' },
        { capsule: 'diamond_alt', name: 'Diamant Alternative', color: '§9', texture: 'diamond_alt_capsule' },
        { capsule: 'emerald', name: 'Emeraude', color: '§2', texture: 'emerald_capsule' },
        { capsule: 'emerald_alt', name: 'Emeraude Alternative', color: '§a', texture: 'emerald_alt_capsule' },
        { capsule: 'gold', name: 'Or', color: '§6', texture: 'gold_capsule' },
        { capsule: 'gold_alt', name: 'Or Alternative', color: '§6', texture: 'gold_alt_capsule' },
        { capsule: 'great', name: 'Greatball', color: '§1', texture: 'great_capsule' },
        { capsule: 'green', name: 'Verte', color: '§2', texture: 'green_capsule' },
        { capsule: 'iron', name: 'Fer', color: '§7', texture: 'iron_capsule' },
        { capsule: 'iron_alt', name: 'Fer Alternative', color: '§7', texture: 'iron_alt_capsule' },
        { capsule: 'master', name: 'Masterball', color: '§5', texture: 'master_capsule' },
        { capsule: 'netherite', name: 'Netherite', color: '§1', texture: 'netherite_capsule' },
        { capsule: 'netherite_alt', name: 'Netherite Alternative', color: '§1', texture: 'netherite_alt_capsule' },
        { capsule: 'poke', name: 'Pokeball', color: '§4', texture: 'poke_capsule' },
        { capsule: 'ultra', name: 'Ultraball', color: '§1', texture: 'ultra_capsule' },
        { capsule: 'yellow', name: 'Jaune', color: '§e', texture: 'yellow_capsule' },
        { capsule: 'red', name: 'Rouge', color: '§4', texture: 'red_capsule' }
    ];

    // Création d'un encens pour chaque type
    capsule.forEach(capsuleData => {
        event.create(`kubejs:${capsuleData.capsule}_capsule`)
            .displayName(`${capsuleData.color}Capsule ${capsuleData.name}`)
            .tooltip(`Capsule ${capsuleData.name}, ouvre-la.`)
            .maxStackSize(1)
            .rarity('uncommon')
            .texture(`kubejs:item/capsules/${capsuleData.texture}`);
    });
});


