StartupEvents.registry('item', event => {
    // Liste des badge de Pokémon et leurs couleurs correspondantes
    const badge = [
        { badge: 'badgeacier', name: 'Acier', color: '§c', texture: 'badgeacier' },
        { badge: 'badgecombat', name: 'Combat', color: '§d', texture: 'badgecombat' },
        { badge: 'badgedragon', name: 'Dragon', color: '§c', texture: 'badgedragon' },
        { badge: 'badgeeau', name: 'Eau', color: '§c', texture: 'badgeeau' },
        { badge: 'badgeelectrik', name: 'Electrique', color: '§b', texture: 'badgeelectrik' },
        { badge: 'badgefee', name: 'Fée', color: '§9', texture: 'badgefee' },
        { badge: 'badgefeu', name: 'Feu', color: '§2', texture: 'badgefeu' },
        { badge: 'badgeglace', name: 'Glace', color: '§a', texture: 'badgeglace' },
        { badge: 'badgeinsecte', name: 'Insecte', color: '§6', texture: 'badgeinsecte' },
        { badge: 'badgenormal', name: 'Normal', color: '§6', texture: 'badgenormal' },
        { badge: 'badgeplante', name: 'Plante', color: '§1', texture: 'badgeplante' },
        { badge: 'badgepoison', name: 'Poison', color: '§2', texture: 'badgepoison' },
        { badge: 'badgepsy', name: 'Psy', color: '§7', texture: 'badgepsy' },
        { badge: 'badgeroche', name: 'Roche', color: '§7', texture: 'badgeroche' },
        { badge: 'badgesol', name: 'Sol', color: '§5', texture: 'badgesol' },
        { badge: 'badgespectre', name: 'Spectre', color: '§1', texture: 'badgespectre' },
        { badge: 'badgetenebres', name: 'Tenebres', color: '§1', texture: 'badgetenebres' },
		{ badge: 'badgevol', name: 'Vol', color: '§1', texture: 'badgevol' },
        { badge: 'badgevague', name: 'Vague', color: '§1', texture: 'badgevague' }
    ];

    // Création d'un encens pour chaque type
    badge.forEach(badgeData => {
        event.create(`kubejs:${badgeData.badge}`)
            .displayName(`${badgeData.color}Badge de type ${badgeData.name}`)
            .tooltip(`Badge obtenue en battant le leader de l\arène ${badgeData.name}.`)
            .rarity('uncommon')
            .texture(`kubejs:item/badges/${badgeData.texture}`);
    });
});