// Effets Shiny

const shinyIncenses = {
    "shiny": { boost: 4, effect: "shinyboost", conflicts: ["ubershinyboost", "strongshinyboost"] },
    "strongshiny": { boost: 8, effect: "strongshinyboost", conflicts: ["ubershinyboost", "shinyboost"] },
    "ubershiny": { boost: 12, effect: "ubershinyboost", conflicts: ["shinyboost", "strongshinyboost"] }
};

Object.entries(shinyIncenses).forEach(([name, data]) => {
    ItemEvents.rightClicked(`kubejs:${name}incense`, event => {
        let player = event.player;

        // Supprime les effets conflictuels et reset le boost shiny si nécessaire
        let removeBoost = false;
        data.conflicts.forEach(conflict => {
            if (player.hasEffect(`kubejs:${conflict}`)) {
                player.removeEffect(`kubejs:${conflict}`);
                removeBoost = true;
            }
        });

        if (removeBoost) {
            event.server.runCommand(`execute as ${player.username} run yacb remove ${player.username} shiny`);
        }

        // Ajoute ou prolonge l'effet du nouvel encens shiny
        let duration = 12000 + (player.hasEffect(`kubejs:${data.effect}`) ? player.potionEffects.getDuration(`kubejs:${data.effect}`) : 0);
        player.potionEffects.add(`kubejs:${data.effect}`, duration, 0, true, true);

        event.server.runCommand(`execute as ${player.username} run yacb boost ${player.username} ${data.boost} 16000 shiny`);
        event.item.count--;
    });
});

//Effets Gen

const NBR_MINUTES = 10;
const PUISSANCE_BOOST = 12;
const BASE_DURATION = 12000;

const incenseTypes = [
    "normal", "fire", "water", "electric", "grass", "ice",
    "fighting", "poison", "ground", "flying", "psychic",
    "bug", "rock", "ghost", "dragon", "dark", "steel", "fairy", "starter", "baby", 
	"gen1", "gen2", "gen3", "gen4", "gen5", "gen6", "gen7", "gen8", "gen9"
];

incenseTypes.forEach(type => {
    ItemEvents.rightClicked(`kubejs:${type}incense`, event => {
        let player = event.player;
        let effectId = `kubejs:${type}incense`;
        let duration = BASE_DURATION + (player.hasEffect(effectId) ? player.potionEffects.getDuration(effectId) : 0);

        player.potionEffects.add(effectId, duration, 0, true, true);
        event.server.runCommand(`execute as ${player.username} run yacb boost ${player.username} ${PUISSANCE_BOOST} ${NBR_MINUTES * 1200} ${type}`);
        event.item.count--;
    });
});