﻿
function randomPick(arr) {
    return arr[Math.floor(Math.random() * arr.length)];
}

// Claw Machine

BlockEvents.rightClicked('kubejs:claw_machine', event => {
    let { player, hand } = event;
    let item = player.getHeldItem(hand);

    
    if (!item || item.id !== 'kubejs:casino_coin') {
        
        return;
    }

    
    if (!player.isCreative()) {
        if (item.count > 0) {
            item.count--; 
        } else {
            player.tell(" Problème lors du retrait de la pièce !");
            return;
        }
    }

    // Définition des récompenses
    let rewards = [
        { item: null, chance: 50 },  // Perte
        { item: `pokeblocks:pokedoll_${randomPick(["bulbasaur", "snorunt", "spheal", "treecko", "luvdisc", "charmander", "squirtle", "smoliv", "rellor", "happiny", "swinub", "drifloon", "rookidee", "wailmer", "rowlet"])}`, amount: 1, chance: 30 },  // Common
        { item: `pokeblocks:pokedoll_${randomPick(["lickitung", "delibird", "piloswine", "mareep", "cetoddle", "cubchoo", "dolliv", "arboliva", "wooper", "gastly", "shellder", "sandygast", "pumpkaboo", "bellossom"])}`, amount: 1, chance: 10 },  // Uncommon
        { item: `pokeblocks:pokedoll_${randomPick(["posing_bulbasaur", "glalie", "eiscue", "eiscue_noice", "frigibax", "flaaffy", "snorlax", "sentret", "furret", "munchlax", "rabsca", "wartortle", "quagsire", "corvisquire", "eevee", "cloyster", "wailord", "phantump"])}`, amount: 1, chance: 5 },  // Rare
        { item: `pokeblocks:pokedoll_${randomPick(["calyrex", "ampharos", "cubchoo_animated", "sableye", "beartic", "absol", "ivysaur", "stonjourner", "tropius", "palossand", "mimikyu", "froslass", "riolu"])}`, amount: 1, chance: 2.7 },  // Epic
        { item: `pokeblocks:pokedoll_${randomPick(["calyrex_animated", "skibidi_mewlet", "snorunt_family", "venusaur", "blastoise", "gengar", "corviknight", "gholdengo", "netherite_gholdengo", "kyogre", "trevenant", "marshadow", "marshadow_zenith_forme", "washing_machine"])}`, amount: 1, chance: 1 },  // Legendary
        { item: `pokeblocks:pokedoll_shiny_${randomPick(["bulbasaur", "snorunt", "treecko", "spheal", "piloswine", "delibird", "glalie", "cubchoo", "cubchoo_animated", "beartic", "eiscue", "eiscue_noice", "frigibax", "cetoddle", "luvdisc", "snorunt_family", "froslass", "riolu", "posing_bulbasaur", "ampharos", "mimikyu", "sableye", "absol", "ivysaur", "calyrex_animated", "stonjourner", "tropius", "palossand", "gengar", "calyrex", "gholdengo", "netherite_gholdengo", "kyogre", "trevenant", "marshadow", "marshadow_zenith_forme", "venusaur", "blastoise", "corviknight", "charmander", "squirtle", "smoliv", "rellor", "happiny", "swinub", "drifloon", "rookidee", "wailmer", "rowlet","lickitung", "mareep", "dolliv", "arboliva", "wooper", "gastly", "shellder", "sandygast", "pumpkaboo", "bellossom", "flaaffy", "snorlax", "sentret", "furret", "munchlax", "rabsca", "wartortle", "quagsire", "corvisquire", "eevee", "cloyster", "wailord", "phantump"])}`, amount: 1, chance: 0.3 },  // Shiny
        { item: `pokeblocks:${randomPick(["eiscue_head_pile", "luvdisc_cushion", "applin_basket", "__morph_figurine", "magikarp_fishbowl", "exhs_figurine", "cheezygrate_figurine"])}`, amount: 1, chance: 0.7  },
        { item: `pokeblocks:shiny_${randomPick(["eiscue_head_pile","magikarp_fishbowl", "applin_basket"])}`, amount: 1, chance: 0.3  }  
        //"bulbasaur", "posing_bulbasaur", "luvdisc_cushion","eiscue_head_pile", "magikarp_fishbowl", "applin_basket", "ampharos", "mimikyu", "sableye", "absol", "ivysaur", "calyrex_animated", "stonjourner", "tropius", "palossand", "gengar", "calyrex", "gholdengo", "netherite_gholdengo", "kyogre", "trevenant", "marshadow", "marshadow_zenith_forme", "venusaur", "blastoise", "corviknight", "charmander", "squirtle", "smoliv", "rellor", "happiny", "swinub", "drifloon", "rookidee", "wailmer", "rowlet","lickitung", "mareep", "dolliv", "arboliva", "wooper", "gastly", "shellder", "sandygast", "pumpkaboo", "bellossom", "flaaffy", "snorlax", "sentret", "furret", "munchlax", "rabsca", "wartortle", "quagsire", "corvisquire", "eevee", "cloyster", "wailord", "phantump"
    ];

    let roll = Math.random() * 100;

    let cumulativeChance = 0;

    for (let reward of rewards) {
        cumulativeChance += reward.chance;

        if (roll <= cumulativeChance) {
            if (reward.item) {
                let prize = Item.of(reward.item, reward.amount);
                player.give(prize);
                const prizeName = prize.item.toString().split("pokedoll_").pop();               
				player.tell(`§eVous avez gagné une peluche ${prizeName} !`);
            }
            else {
                // Si rien n'a été gagné
                player.tell("Pas de chance, rien gagné.");
                }
                return;
        }
	}
});

BlockEvents.rightClicked('kubejs:gacha_machine', event => {
    let { player, hand, level } = event;
    let item = player.getHeldItem(hand);

   
    if (!item || item.id !== 'kubejs:casino_coin') {
        return;
    }

    let now = level.time; 
    let cooldownTime = 72000; // 1 heure = 72000 ticks (A modifier pour changer le cooldown)
    let lastUse = player.persistentData.gachaCooldown || 0;

    
    if (now - lastUse < cooldownTime) {
        let remaining = Math.ceil((cooldownTime - (now - lastUse)) / 1200); // Convertit en minutes
        player.tell(`§c Vous devez attendre encore ${remaining} minute(s) avant de rejouer !`);
        return;
    }

    
    player.persistentData.gachaCooldown = now;

    
    if (!player.isCreative()) {
        if (item.count > 0) {
            item.count--; 
        } else {
            player.tell("Problème lors du retrait de la pièce !");
            return;
        }
    }

    // Liste des capsules avec leurs poids(chance) Changer le poids pour augmenter ou réduire le taux Plus le weight est grand plus il y a de chances de l'obtenir
    const capsules = [
        { id: 'basic', name: 'Basique', weight: 50 },
        { id: 'green', name: 'Verte', weight: 50 },
        { id: 'yellow', name: 'Jaune', weight: 50 },
        { id: 'red', name: 'Rouge', weight: 50 },
        { id: 'poke', name: 'Pokeball', weight: 50 },
        { id: 'great', name: 'Greatball', weight: 30 },
        { id: 'iron', name: 'Fer', weight: 30 },
        { id: 'copper', name: 'Cuivre', weight: 30 },
        { id: 'gold', name: 'Or', weight: 30 },
        { id: 'emerald', name: 'Emeraude', weight: 30 },
        { id: 'ultra', name: 'Ultraball', weight: 15 },
        { id: 'diamond', name: 'Diamant', weight: 15 },
        { id: 'netherite', name: 'Netherite', weight: 15 },
        { id: 'cherish', name: 'Cherishball', weight: 5 },
        { id: 'copper_alt', name: 'Cuivre Alternative', weight: 5 },
        { id: 'gold_alt', name: 'Or Alternative', weight: 5 },
        { id: 'emerald_alt', name: 'Emeraude Alternative', weight: 5 },
        { id: 'netherite_alt', name: 'Netherite Alternative', weight: 5 },
        { id: 'diamond_alt', name: 'Diamant Alternative', weight: 5 },
        { id: 'iron_alt', name: 'Fer Alternative', weight: 5 },
        { id: 'master', name: 'Masterball', weight: 5 },
        { id: 'ultra_master', name: 'Ultra Masterball', weight: 0.001, isItem: true }
    ];

    
    function weightedRandom(items) {
        let totalWeight = items.reduce((sum, item) => sum + item.weight, 0);
        let random = Math.random() * totalWeight;
        for (let item of items) {
            random -= item.weight;
            if (random < 0) return item;
        }
    }

    let chosenCapsule = weightedRandom(capsules);

    if (chosenCapsule.isItem) {
        player.give(`cobblemon:masterball`);
        player.tell(`§eVous avez gagné une ${chosenCapsule.name} !`);
    } else {
        player.give(`kubejs:${chosenCapsule.id}_capsule`);
        player.tell(`§e Vous avez gagné une capsule ${chosenCapsule.name} !`);
    }
});