/*
 * Decompiled with CFR 0.152.
 */
package com.turtlehoarder.cobblemonchallenge.event;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.CobblemonNetwork;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.net.NetworkPacket;
import com.cobblemon.mod.common.api.storage.PokemonStore;
import com.cobblemon.mod.common.api.storage.StoreCoordinates;
import com.cobblemon.mod.common.api.storage.StorePosition;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.net.messages.client.storage.party.SetPartyReferencePacket;
import com.turtlehoarder.cobblemonchallenge.CobblemonChallenge;
import com.turtlehoarder.cobblemonchallenge.battle.ChallengeBattleBuilder;
import com.turtlehoarder.cobblemonchallenge.command.ChallengeCommand;
import com.turtlehoarder.cobblemonchallenge.config.ChallengeConfig;
import com.turtlehoarder.cobblemonchallenge.gui.LeadPokemonSelectionSession;
import com.turtlehoarder.cobblemonchallenge.util.ChallengeUtil;
import com.turtlehoarder.cobblemonchallenge.util.FakeStore;
import com.turtlehoarder.cobblemonchallenge.util.FakeStorePosition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import kotlin.Unit;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ChallengeEventHandler {
    public static void registerEvents() {
        ChallengeEventHandler.registerPostVictoryEvent();
        ChallengeEventHandler.registerChallengeLootPrevention();
        ChallengeEventHandler.registerCobblemonSavePrevention();
        ServerEntityEvents.ENTITY_LOAD.register((entity, server) -> ChallengeEventHandler.checkSpawn(entity));
        ServerPlayConnectionEvents.DISCONNECT.register((event, server) -> ChallengeEventHandler.onPlayerLoggedOut(event.method_32311()));
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> ChallengeEventHandler.onServerShutdown());
        ServerTickEvents.END_SERVER_TICK.register(ChallengeEventHandler::onServerTick);
    }

    public static boolean registerPostVictoryEvent() {
        CobblemonEvents.BATTLE_VICTORY.subscribe(Priority.NORMAL, battleVictoryEvent -> {
            CobblemonChallenge.LOGGER.debug("Battle victory!");
            UUID battleId = battleVictoryEvent.getBattle().getBattleId();
            Iterator<PokemonEntity> clonedPokemonIterator = ChallengeBattleBuilder.clonedPokemonList.iterator();
            while (clonedPokemonIterator.hasNext()) {
                PokemonEntity clonedPokemon = clonedPokemonIterator.next();
                if (!clonedPokemon.isBattling() || clonedPokemon.getBattleId() == null || !clonedPokemon.getBattleId().equals(battleId)) continue;
                clonedPokemon.method_5650(class_1297.class_5529.field_26999);
                clonedPokemonIterator.remove();
                CobblemonChallenge.LOGGER.debug(String.format("Removing cloned pokemon from battle: %s", clonedPokemon.method_5476().getString()));
            }
            if (ChallengeUtil.isBattleChallenge(battleId)) {
                PokemonBattle battle = battleVictoryEvent.getBattle();
                ArrayList participants = new ArrayList(battle.getPlayers());
                ListIterator participantIterator = participants.listIterator();
                while (participantIterator.hasNext()) {
                    class_3222 player = (class_3222)participantIterator.next();
                    UUID partyuuid = Cobblemon.INSTANCE.getStorage().getParty(player).getUuid();
                    CobblemonNetwork.INSTANCE.sendPacketToPlayer(player, (NetworkPacket)new SetPartyReferencePacket(partyuuid));
                    for (BattleActor actor : battleVictoryEvent.getWinners()) {
                        actor.getPlayerUUIDs().forEach(winnerUUID -> {
                            if (player.method_5667().equals(winnerUUID)) {
                                player.method_7353((class_2561)class_2561.method_43470((String)(class_124.field_1060 + "You have won the challenge!")), false);
                                participantIterator.remove();
                            }
                        });
                    }
                }
                participants.forEach(loser -> loser.method_7353((class_2561)class_2561.method_43470((String)(class_124.field_1061 + "You have lost the challenge")), false));
            }
            Iterator<PokemonBattle> challengeBattleIterator = ChallengeBattleBuilder.challengeBattles.iterator();
            while (challengeBattleIterator.hasNext()) {
                PokemonBattle battle = challengeBattleIterator.next();
                if (!battle.getBattleId().equals(battleVictoryEvent.getBattle().getBattleId())) continue;
                challengeBattleIterator.remove();
                CobblemonChallenge.LOGGER.debug(String.format("Removing tracked Challenge battle id: %s", battleVictoryEvent.getBattle().getBattleId()));
            }
            return Unit.INSTANCE;
        });
        return true;
    }

    private static void registerCobblemonSavePrevention() {
        CobblemonEvents.POKEMON_ENTITY_SAVE_TO_WORLD.subscribe(Priority.HIGHEST, saveEvent -> {
            PokemonEntity pokemonEntity = saveEvent.getPokemonEntity();
            if (ChallengeUtil.isPokemonPartOfChallenge(pokemonEntity)) {
                CobblemonChallenge.LOGGER.debug(String.format(String.format("Cancelling save event for challenge-mon: %s", pokemonEntity.method_5476().getString()), new Object[0]));
                saveEvent.cancel();
            }
            return Unit.INSTANCE;
        });
    }

    private static void registerChallengeLootPrevention() {
        CobblemonEvents.LOOT_DROPPED.subscribe(Priority.HIGHEST, lootDroppedEvent -> {
            PokemonEntity pokemonEntity;
            class_1309 patt7074$temp = lootDroppedEvent.getEntity();
            if (patt7074$temp instanceof PokemonEntity && ChallengeUtil.isPokemonPartOfChallenge(pokemonEntity = (PokemonEntity)patt7074$temp)) {
                CobblemonChallenge.LOGGER.debug(String.format(String.format("Prevented drop from cloned pokemon: %s", pokemonEntity.method_5476().getString()), ChallengeBattleBuilder.clonedPokemonList.size()));
                lootDroppedEvent.cancel();
            }
            return Unit.INSTANCE;
        });
    }

    public static void onPlayerLoggedOut(class_3222 serverPlayer) {
        Iterator<PokemonBattle> battleIterator = ChallengeBattleBuilder.challengeBattles.iterator();
        while (battleIterator.hasNext()) {
            PokemonBattle battle = battleIterator.next();
            if (!battle.getPlayers().contains(serverPlayer)) continue;
            CobblemonChallenge.LOGGER.debug(String.format("Found hanging battle! (%s)", battle.getBattleId()));
            Iterator<PokemonEntity> clonedPokemonIterator = ChallengeBattleBuilder.clonedPokemonList.iterator();
            while (clonedPokemonIterator.hasNext()) {
                PokemonEntity clonedPokemon = clonedPokemonIterator.next();
                if (clonedPokemon.getBattleId() != null && clonedPokemon.getBattleId().equals(battle.getBattleId())) {
                    CobblemonChallenge.LOGGER.debug(String.format("Removing cloned pokemon from battle: %s | Battle id %s", clonedPokemon.method_5476().getString(), clonedPokemon.getBattleId()));
                    clonedPokemon.method_5650(class_1297.class_5529.field_26999);
                    clonedPokemonIterator.remove();
                    continue;
                }
                CobblemonChallenge.LOGGER.debug(String.format("Removing cloned pokemon from world that no longer has battle id: %s", clonedPokemon.method_5476().getString()));
                clonedPokemon.method_5650(class_1297.class_5529.field_26999);
                clonedPokemonIterator.remove();
            }
            battleIterator.remove();
        }
    }

    public static void checkSpawn(class_1297 entity) {
        PokemonEntity pokemonEntity;
        if (entity instanceof PokemonEntity && ChallengeUtil.isPokemonPartOfChallenge(pokemonEntity = (PokemonEntity)entity)) {
            CobblemonChallenge.LOGGER.debug(String.format("Entity Joined already in battle: %s | Battle id %s", entity.method_5476().getString(), pokemonEntity.getBattleId()));
            ChallengeBattleBuilder.clonedPokemonList.add(pokemonEntity);
            UUID foundplayerUUID = null;
            PokemonBattle pb = ChallengeUtil.getAssociatedBattle(pokemonEntity);
            if (pb != null) {
                foundplayerUUID = ChallengeUtil.getOwnerUuidOfClonedPokemon(pb, pokemonEntity);
            }
            if (pb != null) {
                FakeStore fakeStore;
                UUID playerUUID = foundplayerUUID != null ? foundplayerUUID : new UUID(0L, 0L);
                FakeStore fakePartyStore = fakeStore = new FakeStore(playerUUID);
                pokemonEntity.getPokemon().getStoreCoordinates().set((Object)new StoreCoordinates((PokemonStore)fakePartyStore, (StorePosition)new FakeStorePosition()));
                pokemonEntity.getBusyLocks().add("Cloned_Pokemon");
            }
        }
    }

    public static void onServerShutdown() {
        CobblemonChallenge.LOGGER.debug("Performing Server Shutdown tasks for Cobblemon Challenge");
        if (!ChallengeBattleBuilder.clonedPokemonList.isEmpty()) {
            CobblemonChallenge.LOGGER.debug(String.format("Cloned pokemon (%d) from challenges detected. Removing all before server shuts down", ChallengeBattleBuilder.clonedPokemonList.size()));
            ArrayList<PokemonEntity> clonedPokemonCopyList = new ArrayList<PokemonEntity>(ChallengeBattleBuilder.clonedPokemonList);
            clonedPokemonCopyList.forEach(pokemonEntity -> pokemonEntity.method_5650(class_1297.class_5529.field_26999));
            clonedPokemonCopyList.clear();
        }
        CobblemonChallenge.LOGGER.debug("Finished performing Server Shutdown tasks for Cobblemon Challenge");
    }

    public static void onServerTick(MinecraftServer server) {
        int tickCount = server.method_3780();
        if (tickCount % 20 == 0) {
            long nowTime = System.currentTimeMillis();
            Iterator<Map.Entry<String, ChallengeCommand.ChallengeRequest>> requestIterator = ChallengeCommand.CHALLENGE_REQUESTS.entrySet().iterator();
            while (requestIterator.hasNext()) {
                Map.Entry<String, ChallengeCommand.ChallengeRequest> requestMap = requestIterator.next();
                ChallengeCommand.ChallengeRequest request = requestMap.getValue();
                if (request.createdTime() + (long)ChallengeConfig.REQUEST_EXPIRATION_MILLIS >= nowTime) continue;
                if (ChallengeUtil.isPlayerOnline(request.challengedPlayer())) {
                    request.challengedPlayer().method_7353((class_2561)class_2561.method_43470((String)(class_124.field_1061 + String.format("Challenge from %s has expired", request.challengerPlayer().method_5476().getString()))), false);
                }
                if (ChallengeUtil.isPlayerOnline(request.challengerPlayer())) {
                    request.challengerPlayer().method_7353((class_2561)class_2561.method_43470((String)(class_124.field_1061 + String.format("Challenge to %s has expired", request.challengedPlayer().method_5476().getString()))), false);
                }
                requestIterator.remove();
            }
            Iterator<Map.Entry<UUID, ChallengeCommand.LeadPokemonSelection>> selectionIterator = ChallengeCommand.ACTIVE_SELECTIONS.entrySet().iterator();
            while (selectionIterator.hasNext()) {
                LeadPokemonSelectionSession selectionSession = selectionIterator.next().getValue().selectionWrapper();
                selectionSession.doTick();
                if (selectionSession.creationTime + (long)LeadPokemonSelectionSession.LEAD_TIMEOUT_MILLIS >= nowTime) continue;
                selectionSession.timeoutRequest();
                selectionIterator.remove();
            }
            Iterator<LeadPokemonSelectionSession> cancelSessions = LeadPokemonSelectionSession.SESSIONS_TO_CANCEL.iterator();
            while (cancelSessions.hasNext()) {
                LeadPokemonSelectionSession session = cancelSessions.next();
                ChallengeCommand.ACTIVE_SELECTIONS.remove(session.getUuid());
                CobblemonChallenge.LOGGER.info(String.format("Removing hanging session. Size remaining: %d | %d", ChallengeCommand.ACTIVE_SELECTIONS.size(), LeadPokemonSelectionSession.SESSIONS_TO_CANCEL.size()));
                cancelSessions.remove();
            }
        }
        if (tickCount % 600 == 0) {
            Iterator<PokemonEntity> clonedPokemonIterator = ChallengeBattleBuilder.clonedPokemonList.iterator();
            while (clonedPokemonIterator.hasNext()) {
                PokemonEntity pokemonEntity = clonedPokemonIterator.next();
                if (pokemonEntity.getBattleId() != null) continue;
                pokemonEntity.method_5650(class_1297.class_5529.field_26999);
                clonedPokemonIterator.remove();
                CobblemonChallenge.LOGGER.debug(String.format("Removed hanging duplicate pokemon %s", pokemonEntity.method_5476().getString()));
            }
        }
    }
}

