/*
 * Decompiled with CFR 0.152.
 */
package com.turtlehoarder.cobblemonchallenge.battle;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.storage.party.PartyStore;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.BattleFormat;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.BattleSide;
import com.cobblemon.mod.common.battles.actor.PlayerBattleActor;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.turtlehoarder.cobblemonchallenge.CobblemonChallenge;
import com.turtlehoarder.cobblemonchallenge.battle.ChallengeBuilderException;
import com.turtlehoarder.cobblemonchallenge.battle.ChallengeFormat;
import com.turtlehoarder.cobblemonchallenge.util.ChallengeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import kotlin.Unit;
import net.minecraft.class_3222;

public class ChallengeBattleBuilder {
    public static Vector<PokemonEntity> clonedPokemonList = new Vector();
    public static Vector<PokemonBattle> challengeBattles = new Vector();
    private ChallengeFormat format = ChallengeFormat.STANDARD_6V6;

    public void lvlxpvp(class_3222 player1, class_3222 player2, BattleFormat battleFormat, int minLevel, int maxLevel, int handicapP1, int handicapP2, List<Integer> player1Selection, List<Integer> player2Selection) throws ChallengeBuilderException {
        PlayerPartyStore p1Party = Cobblemon.INSTANCE.getStorage().getParty(player1);
        PlayerPartyStore p2Party = Cobblemon.INSTANCE.getStorage().getParty(player2);
        List<BattlePokemon> player1Team = this.createBattleTeamFromParty((PartyStore)p1Party, player1Selection, minLevel, maxLevel, handicapP1);
        List<BattlePokemon> player2Team = this.createBattleTeamFromParty((PartyStore)p2Party, player2Selection, minLevel, maxLevel, handicapP2);
        PlayerBattleActor player1Actor = new PlayerBattleActor(player1.method_5667(), player1Team);
        PlayerBattleActor player2Actor = new PlayerBattleActor(player2.method_5667(), player2Team);
        BattleRegistry br = Cobblemon.INSTANCE.getBattleRegistry();
        br.startBattle(battleFormat, new BattleSide(new BattleActor[]{player1Actor}), new BattleSide(new BattleActor[]{player2Actor}), false).ifSuccessful(battle -> {
            challengeBattles.add((PokemonBattle)battle);
            return Unit.INSTANCE;
        });
    }

    private List<BattlePokemon> createBattleTeamFromParty(PartyStore party, List<Integer> selectedSlots, int minLevel, int maxLevel, int handicap) throws ChallengeBuilderException {
        ArrayList<BattlePokemon> battlePokemonList = new ArrayList<BattlePokemon>();
        if (this.format == ChallengeFormat.STANDARD_6V6) {
            int leadSlot = selectedSlots.get(0);
            Pokemon leadPokemon = party.get(leadSlot);
            if (leadPokemon == null) {
                CobblemonChallenge.LOGGER.error("Mysterious null lead pokemon selected.");
                throw new ChallengeBuilderException();
            }
            BattlePokemon leadBattlePokemon = BattlePokemon.Companion.safeCopyOf(leadPokemon);
            int adjustedLevel = ChallengeUtil.getBattlePokemonAdjustedLevel(leadPokemon.getLevel(), minLevel, maxLevel, handicap);
            battlePokemonList.add(ChallengeUtil.applyFormatTransformations(this.format, leadBattlePokemon, adjustedLevel));
            for (int slot = 0; slot < party.size(); ++slot) {
                Pokemon pokemon;
                if (slot == leadSlot || (pokemon = party.get(slot)) == null) continue;
                adjustedLevel = ChallengeUtil.getBattlePokemonAdjustedLevel(pokemon.getLevel(), minLevel, maxLevel, handicap);
                BattlePokemon battlePokemon = ChallengeUtil.applyFormatTransformations(this.format, BattlePokemon.Companion.safeCopyOf(pokemon), adjustedLevel);
                battlePokemonList.add(battlePokemon);
            }
        }
        return battlePokemonList;
    }
}

