/*
 * Decompiled with CFR 0.152.
 */
package com.alreadycatch.mixin;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.rafacasari.mod.cobbledex.CobbledexConstants;
import com.rafacasari.mod.cobbledex.api.classes.DiscoveryRegister;
import java.lang.reflect.Field;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Pokemon.class})
public abstract class PokemonMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"alreadycatch");

    @Inject(method={"getDisplayName"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyPokemonName(CallbackInfoReturnable<class_2561> cir) {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        Pokemon pokemon = (Pokemon)this;
        if (!this.isPokemonWild(pokemon)) {
            return;
        }
        String status = this.getPokemonStatus(pokemon);
        class_2561 originalName = (class_2561)cir.getReturnValue();
        class_5250 modifiedName = class_2561.method_43470((String)originalName.getString());
        if ("CAUGHT".equalsIgnoreCase(status)) {
            class_5250 pokeballIcon = class_2561.method_43470((String)"\ue100");
            modifiedName.method_27693(" ").method_10852((class_2561)pokeballIcon);
        } else if ("SEEN".equalsIgnoreCase(status)) {
            class_2561.method_43470((String)originalName.getString());
        } else {
            modifiedName = class_2561.method_43470((String)"???");
        }
        cir.setReturnValue((Object)modifiedName);
    }

    private String getPokemonStatus(Pokemon pokemon) {
        if (class_310.method_1551().field_1724 == null) {
            return "UNKNOWN";
        }
        Map discoveredList = CobbledexConstants.Client.INSTANCE.getDiscoveredList();
        String speciesId = pokemon.getSpecies().showdownId();
        String formId = pokemon.getForm().formOnlyShowdownId();
        Map speciesForms = (Map)discoveredList.get(speciesId);
        if (speciesForms == null) {
            return "UNKNOWN";
        }
        DiscoveryRegister register = (DiscoveryRegister)speciesForms.get(formId);
        if (register == null) {
            return "UNKNOWN";
        }
        if (this.hasField(register, "status")) {
            Object statusObj = this.getFieldValue(register, "status");
            return statusObj != null ? statusObj.toString() : "UNKNOWN";
        }
        return "UNKNOWN";
    }

    private boolean isPokemonWild(Pokemon pokemon) {
        String trainer = pokemon.getOriginalTrainer();
        return trainer == null || "NONE".equalsIgnoreCase(trainer.toString());
    }

    private boolean hasField(Object obj, String fieldName) {
        try {
            obj.getClass().getDeclaredField(fieldName);
            return true;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    private Object getFieldValue(Object obj, String fieldName) {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(obj);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return null;
        }
    }
}

