/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import java.util.Objects;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.impl.transfer.DebugMessages;
import net.minecraft.class_1268;
import net.minecraft.class_128;
import net.minecraft.class_1297;
import net.minecraft.class_148;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;

public class FluidHelper {
    public static final long BUCKET_VOLUME_IN_MILLIBUCKETS = 81L;

    public static int toBuckets(long amount) {
        return (int)(amount / 81L);
    }

    public static boolean isFluidStorage(class_1799 stack) {
        return ContainerItemContext.withConstant((class_1799)stack).find(FluidStorage.ITEM) != null;
    }

    public static boolean placeFluid(@Nullable class_1657 player, @NotNull class_1937 level, @NotNull class_2338 pos, Storage<FluidVariant> source, FluidVariant resource, long maxAmount) {
        if (!level.method_8477(pos)) {
            return false;
        }
        class_3611 fluid = resource.getFluid();
        if (fluid == class_3612.field_15906) {
            return false;
        }
        class_2680 state = level.method_8320(pos);
        boolean waterlog = state.method_28498((class_2769)class_2741.field_12508);
        if (!waterlog && !state.method_45474()) {
            return false;
        }
        if (waterlog && fluid != class_3612.field_15910) {
            return false;
        }
        class_3610 fluidState = state.method_26227();
        if (!fluidState.method_15769() && fluidState.method_15772() != fluid) {
            return false;
        }
        try (Transaction extraction = Transaction.openOuter();){
            long result = source.extract((Object)resource, maxAmount, (TransactionContext)extraction);
            if (result == 0L) {
                boolean bl = false;
                return bl;
            }
            extraction.commit();
        }
        if (level.method_8597().comp_644() && fluid.method_15785().method_15767(class_3486.field_15517)) {
            level.method_8396(player, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.8f);
            for (int i = 0; i < 8; ++i) {
                level.method_8406((class_2394)class_2398.field_11237, (double)pos.method_10263() + Math.random(), (double)pos.method_10264() + Math.random(), (double)pos.method_10260() + Math.random(), 0.0, 0.0, 0.0);
            }
            return true;
        }
        if (waterlog) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true)), 3);
            level.method_39281(pos, (class_3611)class_3612.field_15910, 1);
            return true;
        }
        if (!level.field_9236 && state.method_26188(fluid) && !state.method_51176()) {
            level.method_22352(pos, true);
        }
        if (level.method_8652(pos, fluid.method_15785().method_15759(), 3) || fluidState.method_15771()) {
            FluidHelper.playFluidSound(player, (class_1936)level, pos, resource, false);
            return true;
        }
        return false;
    }

    public static void playFluidSound(@Nullable class_1657 player, class_1936 level, class_2338 pos, FluidVariant resource, boolean fill) {
        class_3414 sound = fill ? FluidVariantAttributes.getFillSound((FluidVariant)resource) : FluidVariantAttributes.getEmptySound((FluidVariant)resource);
        level.method_8396(player, pos, sound, class_3419.field_15245, 1.0f, 1.0f);
        level.method_33596((class_1297)player, class_5712.field_28166, pos);
    }

    public static boolean interactWithFluidStorage(Storage<FluidVariant> storage, class_1657 player, class_1268 hand, boolean fill) {
        Storage handStorage = (Storage)ContainerItemContext.ofPlayerHand((class_1657)player, (class_1268)hand).find(FluidStorage.ITEM);
        if (handStorage == null) {
            return false;
        }
        class_1792 handItem = player.method_5998(hand).method_7909();
        try {
            if (fill) {
                return FluidHelper.moveWithSound(storage, (Storage<FluidVariant>)handStorage, player, true, handItem);
            }
            return FluidHelper.moveWithSound((Storage<FluidVariant>)handStorage, storage, player, false, handItem);
        }
        catch (Exception e) {
            class_128 report = class_128.method_560((Throwable)e, (String)"Interacting with fluid storage");
            report.method_562("Interaction details").method_577("Player", () -> DebugMessages.forPlayer((class_1657)player)).method_578("Hand", (Object)hand).method_577("Hand item", () -> ((class_1792)handItem).toString()).method_577("Fluid storage", () -> Objects.toString(storage, null));
            throw new class_148(report);
        }
    }

    private static boolean moveWithSound(Storage<FluidVariant> from, Storage<FluidVariant> to, class_1657 player, boolean fill, class_1792 handItem) {
        for (StorageView view : from) {
            long maxExtracted;
            if (view.isResourceBlank()) continue;
            FluidVariant resource = (FluidVariant)view.getResource();
            try (Transaction extractionTestTransaction = Transaction.openOuter();){
                maxExtracted = view.extract((Object)resource, Long.MAX_VALUE, (TransactionContext)extractionTestTransaction);
            }
            Transaction transferTransaction = Transaction.openOuter();
            try {
                class_3414 sound;
                long accepted = to.insert((Object)resource, maxExtracted, (TransactionContext)transferTransaction);
                if (accepted <= 0L || view.extract((Object)resource, accepted, (TransactionContext)transferTransaction) != accepted) continue;
                transferTransaction.commit();
                class_3414 class_34142 = sound = fill ? FluidVariantAttributes.getFillSound((FluidVariant)resource) : FluidVariantAttributes.getEmptySound((FluidVariant)resource);
                if (resource.isOf((Object)class_3612.field_15910)) {
                    if (fill && handItem == class_1802.field_8469) {
                        sound = class_3417.field_14779;
                    }
                    if (!fill && handItem == class_1802.field_8574) {
                        sound = class_3417.field_14826;
                    }
                }
                player.method_17356(sound, class_3419.field_15245, 1.0f, 1.0f);
                boolean bl = true;
                return bl;
            }
            finally {
                if (transferTransaction == null) continue;
                transferTransaction.close();
            }
        }
        return false;
    }
}

