/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_6862;
import net.p3pp3rf1y.sophisticatedcore.client.gui.StorageScreenBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.Button;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonDefinition;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ButtonDefinitions;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.CompositeWidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedcore.client.gui.controls.WidgetBase;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Dimension;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.GuiHelper;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.Position;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.mixin.client.accessor.AbstractContainerScreenAccessor;
import net.p3pp3rf1y.sophisticatedcore.mixin.client.accessor.ScreenAccessor;
import net.p3pp3rf1y.sophisticatedcore.mixin.common.accessor.SlotAccessor;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogicBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.FilterLogicContainerBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.PrimaryMatch;

public abstract class FilterLogicControlBase<F extends FilterLogicBase, S extends class_1735, C extends FilterLogicContainerBase<F, S>>
extends CompositeWidgetBase<WidgetBase> {
    public static final int TAG_FONT_COLOR = 0xF9FFFE;
    public static final int MORE_TAGS_FONT_COLOR = 0xD3D3D3;
    private static final int MAX_TAG_NAME_WIDTH = 68;
    protected final MatchButton[] showMatchButtons;
    protected final int slotsTopYOffset;
    protected final int slotsPerRow;
    protected final int slotsInExtraRow;
    protected final int fullSlotRows;
    private final int totalSlotRows;
    private final StorageScreenBase<?> screen;
    protected final C container;
    private final List<class_2561> addTagTooltip = new ArrayList<class_2561>();
    private final List<class_2561> removeTagTooltip = new ArrayList<class_2561>();
    private final List<class_2561> tagListTooltip = new ArrayList<class_2561>();
    @Nullable
    private ToggleButton<Boolean> nbtButton = null;
    @Nullable
    private ToggleButton<Boolean> durabilityButton = null;
    private int tagButtonsYOffset;

    protected FilterLogicControlBase(StorageScreenBase<?> screen, C container, Position position, boolean buttonsVisible, int slotsPerRow, MatchButton ... showMatchButtons) {
        super(position, new Dimension(0, 0));
        this.screen = screen;
        this.container = container;
        this.slotsTopYOffset = buttonsVisible ? 21 : 0;
        this.slotsPerRow = slotsPerRow;
        this.showMatchButtons = showMatchButtons;
        this.fullSlotRows = ((FilterLogicContainerBase)container).getFilterSlots().size() / slotsPerRow;
        this.slotsInExtraRow = ((FilterLogicContainerBase)container).getFilterSlots().size() % slotsPerRow;
        this.totalSlotRows = this.fullSlotRows + (this.slotsInExtraRow > 0 ? 1 : 0);
        if (this.shouldShow(MatchButton.ALLOW_LIST)) {
            this.addChild(new ToggleButton<Boolean>(new Position(this.x, this.y), ButtonDefinitions.ALLOW_LIST, button -> container.setAllowList(!container.isAllowList()), () -> container.isAllowList()));
        }
        if (this.shouldShow(MatchButton.PRIMARY_MATCH)) {
            this.addChild(new ToggleButton<PrimaryMatch>(new Position(this.x + 18, this.y), ButtonDefinitions.PRIMARY_MATCH, button -> {
                PrimaryMatch next = container.getPrimaryMatch().next();
                if (next == PrimaryMatch.TAGS) {
                    container.getFilterSlots().forEach(slot -> ((SlotAccessor)slot).setX(-2000));
                    this.onTagsMatchSelected();
                }
                container.setPrimaryMatch(next);
                this.setDurabilityAndNbtButtonsVisibility();
                this.moveSlotsToView();
            }, () -> container.getPrimaryMatch()));
            this.addTagButtons();
        }
        if (this.shouldShow(MatchButton.DURABILITY)) {
            this.durabilityButton = new ToggleButton<Boolean>(new Position(this.x + 36, this.y), ButtonDefinitions.MATCH_DURABILITY, button -> container.setMatchDurability(!container.shouldMatchDurability()), () -> container.shouldMatchDurability());
            this.addChild(this.durabilityButton);
        }
        if (this.shouldShow(MatchButton.NBT)) {
            this.nbtButton = new ToggleButton<Boolean>(new Position(this.x + 54, this.y), ButtonDefinitions.MATCH_NBT, button -> container.setMatchNbt(!container.shouldMatchNbt()), () -> container.shouldMatchNbt());
            this.addChild(this.nbtButton);
        }
        this.updateDimensions(Math.max(slotsPerRow * 18, this.getMaxButtonWidth()), (this.fullSlotRows + (this.slotsInExtraRow > 0 ? 1 : 0)) * 18 + this.slotsTopYOffset);
        this.setDurabilityAndNbtButtonsVisibility();
    }

    private void setDurabilityAndNbtButtonsVisibility() {
        boolean visible;
        boolean bl = visible = ((FilterLogicContainerBase)this.container).getPrimaryMatch() != PrimaryMatch.TAGS;
        if (this.nbtButton != null) {
            this.nbtButton.setVisible(visible);
        }
        if (this.durabilityButton != null) {
            this.durabilityButton.setVisible(visible);
        }
    }

    protected void onTagsMatchSelected() {
    }

    private void addTagButtons() {
        this.tagButtonsYOffset = this.slotsTopYOffset + this.getTagListHeight();
        this.addChild(new TagButton(new Position(this.x + 36, this.y + this.tagButtonsYOffset), ButtonDefinitions.REMOVE_TAG, button -> {
            ((FilterLogicContainerBase)this.container).removeSelectedTag();
            this.updateTagListAndRemoveTooltips();
            this.updateAddTooltip();
        }, delta -> {
            if (delta < 0.0) {
                ((FilterLogicContainerBase)this.container).selectNextTagToRemove();
            } else {
                ((FilterLogicContainerBase)this.container).selectPreviousTagToRemove();
            }
            this.updateTagListAndRemoveTooltips();
        }){

            @Override
            protected List<class_2561> getTooltip() {
                return FilterLogicControlBase.this.removeTagTooltip;
            }
        });
        this.updateTagListAndRemoveTooltips();
        this.addChild(new TagButton(new Position(this.x + 18, this.y + this.tagButtonsYOffset), ButtonDefinitions.ADD_TAG, button -> {
            ((FilterLogicContainerBase)this.container).addSelectedTag();
            this.updateAddTooltip();
            this.updateTagListAndRemoveTooltips();
        }, delta -> {
            if (delta < 0.0) {
                ((FilterLogicContainerBase)this.container).selectNextTagToAdd();
            } else {
                ((FilterLogicContainerBase)this.container).selectPreviousTagToAdd();
            }
            this.updateAddTooltip();
        }){

            @Override
            protected List<class_2561> getTooltip() {
                return FilterLogicControlBase.this.addTagTooltip;
            }
        });
        this.updateAddTooltip();
        ((FilterLogicContainerBase)this.container).getTagSelectionSlot().setOnUpdate(this::updateAddTooltip);
        this.addChild(new ToggleButton<Boolean>(new Position(this.x + 54, this.y + this.tagButtonsYOffset), ButtonDefinitions.MATCH_ANY_TAG, button -> ((FilterLogicContainerBase)this.container).setMatchAnyTag(!((FilterLogicContainerBase)this.container).shouldMatchAnyTag()), () -> this.container.shouldMatchAnyTag()){

            @Override
            protected void renderBg(class_332 guiGraphics, class_310 minecraft, int mouseX, int mouseY) {
                if (((FilterLogicContainerBase)FilterLogicControlBase.this.container).getPrimaryMatch() == PrimaryMatch.TAGS) {
                    super.renderBg(guiGraphics, minecraft, mouseX, mouseY);
                }
            }

            @Override
            protected void renderWidget(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
                if (((FilterLogicContainerBase)FilterLogicControlBase.this.container).getPrimaryMatch() == PrimaryMatch.TAGS) {
                    super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
                }
            }

            @Override
            public boolean method_25405(double mouseX, double mouseY) {
                return ((FilterLogicContainerBase)FilterLogicControlBase.this.container).getPrimaryMatch() == PrimaryMatch.TAGS && super.method_25405(mouseX, mouseY);
            }
        });
    }

    private void updateTagListAndRemoveTooltips() {
        this.updateTagListTooltip();
        this.updateRemoveTooltip();
    }

    private void updateTagListTooltip() {
        this.tagListTooltip.clear();
        this.tagListTooltip.add((class_2561)class_2561.method_43471((String)TranslationHelper.INSTANCE.translUpgradeKey("tag_list.title")).method_27695(new class_124[0]));
        Set<class_6862<class_1792>> tagNames = ((FilterLogicContainerBase)this.container).getTagNames();
        if (tagNames.isEmpty()) {
            this.tagListTooltip.add((class_2561)class_2561.method_43471((String)TranslationHelper.INSTANCE.translUpgradeKey("tag_list.empty")).method_27692(class_124.field_1063));
            return;
        }
        for (class_6862<class_1792> tagName : tagNames) {
            this.tagListTooltip.add((class_2561)class_2561.method_43470((String)("> " + tagName.comp_327())).method_27692(class_124.field_1080));
        }
    }

    private void updateRemoveTooltip() {
        this.removeTagTooltip.clear();
        this.removeTagTooltip.add((class_2561)class_2561.method_43471((String)TranslationHelper.INSTANCE.translUpgradeButton("remove_tag")));
        Set<class_6862<class_1792>> tagNames = ((FilterLogicContainerBase)this.container).getTagNames();
        if (tagNames.isEmpty()) {
            this.removeTagTooltip.add((class_2561)class_2561.method_43471((String)TranslationHelper.INSTANCE.translUpgradeButton("remove_tag.empty")).method_27692(class_124.field_1061));
            return;
        }
        int curIndex = 0;
        for (class_6862<class_1792> tagName : tagNames) {
            if (curIndex == ((FilterLogicContainerBase)this.container).getSelectedTagToRemove()) {
                this.removeTagTooltip.add((class_2561)class_2561.method_43470((String)("-> " + tagName.comp_327())).method_27692(class_124.field_1061));
            } else {
                this.removeTagTooltip.add((class_2561)class_2561.method_43470((String)("> " + tagName.comp_327())).method_27692(class_124.field_1080));
            }
            ++curIndex;
        }
        this.removeTagTooltip.add((class_2561)class_2561.method_43471((String)TranslationHelper.INSTANCE.translUpgradeButton("remove_tag.controls")).method_27695(new class_124[]{class_124.field_1056, class_124.field_1063}));
    }

    private void updateAddTooltip() {
        this.addTagTooltip.clear();
        this.addTagTooltip.add((class_2561)class_2561.method_43471((String)TranslationHelper.INSTANCE.translUpgradeButton("add_tag")));
        if (((FilterLogicContainerBase)this.container).getTagSelectionSlot().method_7677().method_7960()) {
            this.addTagTooltip.add((class_2561)class_2561.method_43471((String)TranslationHelper.INSTANCE.translUpgradeButton("add_tag.no_item")).method_27695(new class_124[]{class_124.field_1056, class_124.field_1063}));
            return;
        }
        Set<class_6862<class_1792>> tagsToAdd = ((FilterLogicContainerBase)this.container).getTagsToAdd();
        int curIndex = 0;
        for (class_6862<class_1792> tagName : tagsToAdd) {
            if (curIndex == ((FilterLogicContainerBase)this.container).getSelectedTagToAdd()) {
                this.addTagTooltip.add((class_2561)class_2561.method_43470((String)("-> " + tagName.comp_327())).method_27692(class_124.field_1060));
            } else {
                this.addTagTooltip.add((class_2561)class_2561.method_43470((String)("> " + tagName.comp_327())).method_27692(class_124.field_1080));
            }
            ++curIndex;
        }
        if (tagsToAdd.isEmpty()) {
            this.addTagTooltip.add((class_2561)class_2561.method_43471((String)TranslationHelper.INSTANCE.translUpgradeButton("add_tag.no_additional_tags")).method_27695(new class_124[]{class_124.field_1056, class_124.field_1054}));
        } else {
            this.addTagTooltip.add((class_2561)class_2561.method_43471((String)TranslationHelper.INSTANCE.translUpgradeButton("add_tag.controls")).method_27695(new class_124[]{class_124.field_1056, class_124.field_1063}));
        }
    }

    protected int getMaxButtonWidth() {
        int maxWidth = 0;
        for (WidgetBase w : this.children) {
            int buttonWidth = w.getX() + w.getWidth() - this.x;
            if (buttonWidth <= maxWidth) continue;
            maxWidth = buttonWidth;
        }
        return maxWidth;
    }

    protected boolean shouldShow(MatchButton matchButton) {
        for (MatchButton showMatchButton : this.showMatchButtons) {
            if (showMatchButton != matchButton) continue;
            return true;
        }
        return false;
    }

    public void moveSlotsToView() {
        if (((FilterLogicContainerBase)this.container).getPrimaryMatch() == PrimaryMatch.TAGS) {
            FilterLogicContainerBase.TagSelectionSlot slot = ((FilterLogicContainerBase)this.container).getTagSelectionSlot();
            ((SlotAccessor)((Object)slot)).setX(this.x - ((AbstractContainerScreenAccessor)((Object)this.screen)).getGuiLeft() + 1);
            ((SlotAccessor)((Object)slot)).setY(this.y - ((AbstractContainerScreenAccessor)((Object)this.screen)).getGuiTop() + this.tagButtonsYOffset + 1);
            ((FilterLogicContainerBase)this.container).getFilterSlots().forEach(s -> ((SlotAccessor)s).setY(-2000));
        } else {
            int upgradeSlotNumber = 0;
            for (class_1735 slot : ((FilterLogicContainerBase)this.container).getFilterSlots()) {
                ((SlotAccessor)slot).setX(this.x - ((AbstractContainerScreenAccessor)((Object)this.screen)).getGuiLeft() + 1 + upgradeSlotNumber % this.slotsPerRow * 18);
                ((SlotAccessor)slot).setY(this.y - ((AbstractContainerScreenAccessor)((Object)this.screen)).getGuiTop() + this.slotsTopYOffset + 1 + upgradeSlotNumber / this.slotsPerRow * 18);
                ++upgradeSlotNumber;
            }
            ((SlotAccessor)((Object)((FilterLogicContainerBase)this.container).getTagSelectionSlot())).setX(-2000);
        }
    }

    @Override
    protected void renderWidget(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        if (((FilterLogicContainerBase)this.container).getPrimaryMatch() == PrimaryMatch.TAGS) {
            this.renderTagNames(guiGraphics);
        }
    }

    private void renderTagNames(class_332 guiGraphics) {
        int count = 0;
        int prefixWidth = this.font.method_1727("...");
        Set<class_6862<class_1792>> tagNames = ((FilterLogicContainerBase)this.container).getTagNames();
        int maxTagNameLines = this.getTagListHeight() / 10;
        for (class_6862<class_1792> tagName : tagNames) {
            if (tagNames.size() > maxTagNameLines && count == maxTagNameLines - 1) {
                guiGraphics.method_51439(this.minecraft.field_1772, (class_2561)class_2561.method_43469((String)TranslationHelper.INSTANCE.translUpgradeKey("tag_list.tag_overflow"), (Object[])new Object[]{String.valueOf(tagNames.size() - (maxTagNameLines - 1))}), this.x + 2, this.y + 23 + count * 10, 0xD3D3D3, false);
                break;
            }
            String name = tagName.comp_327().toString();
            Object shortened = name;
            if (this.font.method_1727(name) > 68 && !((String)(shortened = this.font.method_27524(name, 68 - prefixWidth, true))).equals(name)) {
                shortened = "..." + (String)shortened;
            }
            guiGraphics.method_51433(this.minecraft.field_1772, (String)shortened, this.x + 2, this.y + 23 + count * 10, 0xF9FFFE, false);
            ++count;
        }
    }

    @Override
    public void renderTooltip(class_437 screen, class_332 guiGraphics, int mouseX, int mouseY) {
        super.renderTooltip(screen, guiGraphics, mouseX, mouseY);
        if (((FilterLogicContainerBase)this.container).getPrimaryMatch() == PrimaryMatch.TAGS && this.isMouseOverTagList(mouseX, mouseY)) {
            guiGraphics.method_51437(((ScreenAccessor)screen).getFont(), this.tagListTooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    private int getTagListHeight() {
        return (this.totalSlotRows - 1) * 18;
    }

    private boolean isMouseOverTagList(double mouseX, double mouseY) {
        return mouseX >= (double)this.x && mouseX < (double)(this.x + this.getTagListWidth()) && mouseY >= (double)(this.y + this.slotsTopYOffset) && mouseY < (double)(this.y + this.slotsTopYOffset + this.getTagListHeight());
    }

    @Override
    protected void renderBg(class_332 guiGraphics, class_310 minecraft, int mouseX, int mouseY) {
        if (((FilterLogicContainerBase)this.container).getPrimaryMatch() != PrimaryMatch.TAGS) {
            GuiHelper.renderSlotsBackground(guiGraphics, this.x, this.y + this.slotsTopYOffset, this.slotsPerRow, this.fullSlotRows, this.slotsInExtraRow);
        } else {
            GuiHelper.renderSlotsBackground(guiGraphics, this.x, this.y + this.tagButtonsYOffset, 1, 1, 0);
            GuiHelper.renderControlBackground(guiGraphics, this.x, this.y + this.slotsTopYOffset, this.getTagListWidth(), this.getTagListHeight());
        }
    }

    private int getTagListWidth() {
        return this.slotsPerRow * 18;
    }

    public static enum MatchButton {
        ALLOW_LIST,
        PRIMARY_MATCH,
        DURABILITY,
        NBT;

    }

    private class TagButton
    extends Button {
        private final DoubleConsumer onScroll;

        public TagButton(Position position, ButtonDefinition buttonDefinition, IntConsumer onClick, DoubleConsumer onScroll) {
            super(position, buttonDefinition, onClick);
            this.onScroll = onScroll;
        }

        @Override
        protected void renderBg(class_332 guiGraphics, class_310 minecraft, int mouseX, int mouseY) {
            if (((FilterLogicContainerBase)FilterLogicControlBase.this.container).getPrimaryMatch() == PrimaryMatch.TAGS) {
                super.renderBg(guiGraphics, minecraft, mouseX, mouseY);
            }
        }

        @Override
        protected void renderWidget(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (((FilterLogicContainerBase)FilterLogicControlBase.this.container).getPrimaryMatch() == PrimaryMatch.TAGS) {
                super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
            }
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            return ((FilterLogicContainerBase)FilterLogicControlBase.this.container).getPrimaryMatch() == PrimaryMatch.TAGS && super.method_25405(mouseX, mouseY);
        }

        public boolean method_25401(double pMouseX, double pMouseY, double pDelta) {
            if (((FilterLogicContainerBase)FilterLogicControlBase.this.container).getPrimaryMatch() != PrimaryMatch.TAGS) {
                return false;
            }
            this.onScroll.accept(pDelta);
            return true;
        }
    }
}

