/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.inventory;

import java.util.Collections;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;

public interface ISlotTracker {
    public void setShouldInsertIntoEmpty(BooleanSupplier var1);

    public Set<ItemStackKey> getFullStacks();

    public Set<ItemStackKey> getPartialStacks();

    public Set<class_1792> getItems();

    public void removeAndSetSlotIndexes(InventoryHandler var1, int var2, class_1799 var3);

    public void clear();

    public void refreshSlotIndexesFrom(InventoryHandler var1);

    public long insertItemIntoHandler(InventoryHandler var1, IItemHandlerInserter var2, UnaryOperator<class_1799> var3, ItemVariant var4, long var5, TransactionContext var7);

    public long insertItemIntoHandler(InventoryHandler var1, IItemHandlerInserter var2, UnaryOperator<class_1799> var3, int var4, ItemVariant var5, long var6, TransactionContext var8);

    public void registerListeners(Consumer<ItemStackKey> var1, Consumer<ItemStackKey> var2, Runnable var3, Runnable var4);

    public void unregisterStackKeyListeners();

    public boolean hasEmptySlots();

    public static class Noop
    implements ISlotTracker {
        @Override
        public void setShouldInsertIntoEmpty(BooleanSupplier shouldInsertIntoEmpty) {
        }

        @Override
        public Set<ItemStackKey> getFullStacks() {
            return Collections.emptySet();
        }

        @Override
        public Set<ItemStackKey> getPartialStacks() {
            return Collections.emptySet();
        }

        @Override
        public Set<class_1792> getItems() {
            return Collections.emptySet();
        }

        @Override
        public void removeAndSetSlotIndexes(InventoryHandler inventoryHandler, int slot, class_1799 stack) {
        }

        @Override
        public void clear() {
        }

        @Override
        public void refreshSlotIndexesFrom(InventoryHandler itemHandler) {
        }

        @Override
        public long insertItemIntoHandler(InventoryHandler itemHandler, IItemHandlerInserter inserter, UnaryOperator<class_1799> overflowHandler, ItemVariant resource, long maxAmount, @Nullable TransactionContext ctx) {
            return maxAmount;
        }

        @Override
        public long insertItemIntoHandler(InventoryHandler itemHandler, IItemHandlerInserter inserter, UnaryOperator<class_1799> overflowHandler, int slot, ItemVariant resource, long maxAmount, @Nullable TransactionContext ctx) {
            return inserter.insertItem(slot, resource, maxAmount, ctx);
        }

        @Override
        public void registerListeners(Consumer<ItemStackKey> onAddStackKey, Consumer<ItemStackKey> onRemoveStackKey, Runnable onAddFirstEmptySlot, Runnable onRemoveLastEmptySlot) {
        }

        @Override
        public void unregisterStackKeyListeners() {
        }

        @Override
        public boolean hasEmptySlots() {
            return false;
        }
    }

    public static interface IItemHandlerInserter {
        public long insertItem(int var1, ItemVariant var2, long var3, TransactionContext var5);
    }
}

