/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.porting_lib.base.util;

import io.github.fabricators_of_create.porting_lib.common.util.NonNullConsumer;
import io.github.fabricators_of_create.porting_lib.common.util.NonNullFunction;
import io.github.fabricators_of_create.porting_lib.common.util.NonNullSupplier;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class LazyOptional<T> {
    @Nonnull
    public static final LazyOptional<Void> EMPTY = new LazyOptional(null);
    public NonNullSupplier<T> supplier;
    private final Object lock = new Object();
    private Mutable<T> resolved;
    private final Set<NonNullConsumer<LazyOptional<T>>> listeners = new HashSet<NonNullConsumer<LazyOptional<T>>>();
    private boolean isValid = true;

    private LazyOptional(@Nullable NonNullSupplier<T> instanceSupplier) {
        this.supplier = instanceSupplier;
    }

    public static <T> LazyOptional<T> of(@Nullable NonNullSupplier<T> instanceSupplier) {
        return instanceSupplier == null ? LazyOptional.empty() : new LazyOptional<T>(instanceSupplier);
    }

    public static <T> LazyOptional<T> fromOptional(@Nullable Optional<T> regularOptional) {
        return LazyOptional.ofObject(regularOptional.orElse(null));
    }

    public static <T> LazyOptional<T> ofObject(@Nullable T o) {
        return o == null ? LazyOptional.empty() : LazyOptional.of(() -> o);
    }

    public static <T> LazyOptional<T> empty() {
        return EMPTY.cast();
    }

    public <X> LazyOptional<X> cast() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private T getValue() {
        if (!this.isValid || this.supplier == null) {
            return null;
        }
        if (this.resolved == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.resolved == null) {
                    Object temp = this.supplier.get();
                    if (temp == null) {
                        SophisticatedCore.LOGGER.warn("Supplier should not return null value", (Throwable)new NullPointerException());
                    }
                    this.resolved = new MutableObject(temp);
                }
            }
        }
        return (T)this.resolved.getValue();
    }

    private T getValueUnsafe() {
        T ret = this.getValue();
        if (ret == null) {
            throw new IllegalStateException("LazyOptional is empty or otherwise returned null from getValue() unexpectedly");
        }
        return ret;
    }

    public T getValueUnsafer() {
        return this.orElse(null);
    }

    public boolean isPresent() {
        return this.supplier != null && this.isValid;
    }

    public void ifPresent(NonNullConsumer<? super T> consumer) {
        Objects.requireNonNull(consumer);
        T val = this.getValue();
        if (this.isValid && val != null) {
            consumer.accept(val);
        }
    }

    public <U> LazyOptional<U> lazyMap(NonNullFunction<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return this.isPresent() ? LazyOptional.of(() -> mapper.apply(this.getValueUnsafe())) : LazyOptional.empty();
    }

    public <U> Optional<U> flatMap(NonNullFunction<? super T, ? extends Optional<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        return this.isPresent() ? Objects.requireNonNull((Optional)mapper.apply(this.getValueUnsafe())) : Optional.empty();
    }

    public <U> Optional<U> map(NonNullFunction<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return this.isPresent() ? Optional.of(mapper.apply(this.getValueUnsafe())) : Optional.empty();
    }

    public Optional<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        T value = this.getValue();
        return value != null && predicate.test(value) ? Optional.of(value) : Optional.empty();
    }

    public Optional<T> resolve() {
        return this.isPresent() ? Optional.of(this.getValueUnsafe()) : Optional.empty();
    }

    public T orElse(T other) {
        T val = this.getValue();
        return val != null ? val : other;
    }

    public T orElseGet(NonNullSupplier<? extends T> other) {
        T val = this.getValue();
        return (T)(val != null ? val : other.get());
    }

    public <X extends Throwable> T orElseThrow(NonNullSupplier<? extends X> exceptionSupplier) throws X {
        T val = this.getValue();
        if (val != null) {
            return val;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public void addListener(NonNullConsumer<LazyOptional<T>> listener) {
        if (this.isPresent()) {
            this.listeners.add(listener);
        } else {
            listener.accept((Object)this);
        }
    }

    public void invalidate() {
        if (this.isValid) {
            this.isValid = false;
            this.listeners.forEach(e -> e.accept((Object)this));
        }
    }
}

