/*
 * Decompiled with CFR 0.152.
 */
package git.dragomordor.cobblemizer.fabric.item.custom;

import com.cobblemon.mod.common.api.pokemon.stats.Stat;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.EVs;
import com.cobblemon.mod.common.pokemon.Pokemon;
import git.dragomordor.cobblemizer.fabric.config.CobblemizerConfig;
import git.dragomordor.cobblemizer.fabric.item.custom.PokemonUseItem;
import git.dragomordor.cobblemizer.fabric.misc.TierRarityClass;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class EVAddItem
extends PokemonUseItem {
    private final String tier;
    private final Stat statToBoost;

    public EVAddItem(String tier, Stat statToBoost) {
        super(new FabricItemSettings().maxCount(1));
        this.tier = tier;
        this.statToBoost = statToBoost;
    }

    @Override
    public class_1269 processInteraction(class_1799 itemStack, class_1657 player, PokemonEntity target, Pokemon pokemon) {
        int maxEV = 252;
        EVs evs = pokemon.getEvs();
        int increaseAmount = this.getIncreaseAmountForTier(this.tier);
        int EVcurrentAmount = evs.get(this.statToBoost);
        int newEVAmount = Math.min(EVcurrentAmount + increaseAmount, maxEV);
        int actualIncrease = newEVAmount - EVcurrentAmount;
        if (actualIncrease <= 0) {
            player.method_7353(class_2561.method_30163((String)(this.statToBoost.getDisplayName().getString() + " EV is already at maximum")), true);
            return class_1269.field_5814;
        }
        evs.add(this.statToBoost, actualIncrease);
        player.method_7353(class_2561.method_30163((String)("Increased Pok\u00e9mon's " + this.statToBoost.getDisplayName().getString() + " EV by " + actualIncrease)), true);
        if (newEVAmount == maxEV) {
            player.method_7353(class_2561.method_30163((String)("Pok\u00e9mon's " + this.statToBoost.getDisplayName().getString() + " EV is now at maximum")), true);
        }
        itemStack.method_7934(1);
        return class_1269.field_5812;
    }

    private int getIncreaseAmountForTier(String tierName) {
        for (TierRarityClass tier : CobblemizerConfig.getEVTiers()) {
            if (!tier.getName().equalsIgnoreCase(tierName)) continue;
            return tier.getIncreaseAmount();
        }
        return 0;
    }
}

