/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.impl.framework;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.configured.api.IConfigEntry;
import com.mrcrayfish.configured.api.IConfigValue;
import com.mrcrayfish.configured.api.ValueEntry;
import com.mrcrayfish.configured.impl.framework.FrameworkEnumValue;
import com.mrcrayfish.configured.impl.framework.FrameworkListValue;
import com.mrcrayfish.configured.impl.framework.FrameworkModConfig;
import com.mrcrayfish.configured.impl.framework.FrameworkValue;
import com.mrcrayfish.framework.api.config.EnumProperty;
import com.mrcrayfish.framework.api.config.ListProperty;
import java.util.List;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class FrameworkFolderEntry
implements IConfigEntry {
    private final FrameworkModConfig.PropertyMap map;
    private List<IConfigEntry> entries;

    public FrameworkFolderEntry(FrameworkModConfig.PropertyMap map) {
        this.map = map;
    }

    @Override
    public List<IConfigEntry> getChildren() {
        if (this.entries == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.map.getConfigMaps().forEach(pair -> builder.add((Object)new FrameworkFolderEntry((FrameworkModConfig.PropertyMap)pair.right())));
            this.map.getConfigProperties().forEach(property -> {
                if (property instanceof ListProperty) {
                    ListProperty listProperty = (ListProperty)property;
                    builder.add((Object)new ValueEntry(new FrameworkListValue(listProperty)));
                } else if (property instanceof EnumProperty) {
                    EnumProperty enumProperty = (EnumProperty)property;
                    builder.add((Object)new ValueEntry(new FrameworkEnumValue(enumProperty)));
                } else {
                    builder.add((Object)new ValueEntry(new FrameworkValue(property)));
                }
            });
            this.entries = builder.build();
        }
        return this.entries;
    }

    @Override
    public boolean isRoot() {
        return this.map.getPath().isEmpty();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    @Nullable
    public IConfigValue<?> getValue() {
        return null;
    }

    @Override
    public String getEntryName() {
        return FrameworkFolderEntry.lastValue(this.map.getPath(), "Root");
    }

    @Override
    @Nullable
    public class_2561 getTooltip() {
        String comment = this.map.getComment();
        if (comment != null) {
            return class_2561.method_43470((String)comment);
        }
        return null;
    }

    @Override
    @Nullable
    public String getTranslationKey() {
        return this.map.getTranslationKey();
    }

    public static <V> V lastValue(List<V> list, V defaultValue) {
        if (!list.isEmpty()) {
            return list.get(list.size() - 1);
        }
        return defaultValue;
    }
}

