/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.configured.client.screen.IBackgroundTexture;
import com.mrcrayfish.configured.client.screen.ILabelProvider;
import com.mrcrayfish.configured.client.screen.TooltipScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_757;

public abstract class ListMenuScreen
extends TooltipScreen
implements IBackgroundTexture {
    public static final class_2960 CONFIGURED_LOGO = new class_2960("configured", "textures/gui/logo.png");
    protected final class_437 parent;
    protected final class_2960 background;
    protected final int itemHeight;
    protected EntryList list;
    protected List<Item> entries;
    protected FocusedEditBox activeTextField;
    protected FocusedEditBox searchTextField;

    protected ListMenuScreen(class_437 parent, class_2561 title, class_2960 background, int itemHeight) {
        super(title);
        this.parent = parent;
        this.background = background;
        this.itemHeight = itemHeight;
    }

    protected abstract void constructEntries(List<Item> var1);

    @Override
    public class_2960 getBackgroundTexture() {
        return this.background;
    }

    protected void method_25426() {
        ArrayList<Item> entries = new ArrayList<Item>();
        this.constructEntries(entries);
        this.entries = ImmutableList.copyOf(entries);
        this.list = new EntryList(this.entries);
        this.list.method_31322(!ConfigHelper.isPlayingGame());
        this.method_25429((class_364)this.list);
        this.searchTextField = new FocusedEditBox(this.field_22793, this.field_22789 / 2 - 110, 22, 220, 20, (class_2561)class_2561.method_43471((String)"configured.gui.search"));
        this.searchTextField.setClearable(true);
        this.searchTextField.method_1863(s -> this.updateSearchResults());
        this.method_25429((class_364)this.searchTextField);
        ScreenUtil.updateSearchTextFieldSuggestion(this.searchTextField, "", this.entries);
    }

    protected void updateSearchResults() {
        String query = this.searchTextField.method_1882();
        ScreenUtil.updateSearchTextFieldSuggestion(this.searchTextField, query, this.entries);
        this.list.method_25314(query.isEmpty() ? this.entries : this.getSearchResults(query));
        if (!query.isEmpty()) {
            this.list.method_25307(0.0);
        }
    }

    protected Collection<Item> getSearchResults(String s) {
        return this.entries.stream().filter(item -> !(item instanceof IIgnoreSearch) && item.getLabel().toLowerCase(Locale.ENGLISH).contains(s.toLowerCase(Locale.ENGLISH))).collect(Collectors.toList());
    }

    protected void updateTooltip(int mouseX, int mouseY) {
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, mouseX, mouseY)) {
            this.setActiveTooltip((class_2561)class_2561.method_43471((String)"configured.gui.info"));
        }
    }

    public void method_25393() {
        this.searchTextField.method_1865();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.resetTooltip();
        this.method_25420(graphics);
        this.list.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.searchTextField.method_25394(graphics, mouseX, mouseY, partialTicks);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 7, 0xFFFFFF);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        this.renderForeground(graphics, mouseX, mouseY, partialTicks);
        graphics.method_25291(CONFIGURED_LOGO, 10, 13, 0, 0.0f, 0.0f, 23, 23, 32, 32);
        graphics.method_25293(IconButton.ICONS, this.field_22789 / 2 - 128, 26, 14, 14, 22.0f, 11.0f, 10, 10, 64, 64);
        this.updateTooltip(mouseX, mouseY);
        if (this.tooltipText != null) {
            this.drawTooltip(graphics, mouseX, mouseY);
        } else {
            class_364 widget;
            Iterator iterator = this.method_25396().iterator();
            while (!(!iterator.hasNext() || (widget = (class_364)iterator.next()) instanceof class_4185 && ((class_4185)widget).method_25367())) {
            }
        }
    }

    protected void renderForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, (int)mouseX, (int)mouseY)) {
            class_2583 style = class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://www.curseforge.com/minecraft/mc-mods/configured"));
            this.method_25430(style);
            return true;
        }
        if (this.activeTextField != null && !this.activeTextField.method_25405(mouseX, mouseY)) {
            this.activeTextField.method_25365(false);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    protected class EntryList
    extends class_4265<Item>
    implements IBackgroundTexture {
        public EntryList(List<Item> entries) {
            super(ListMenuScreen.this.field_22787, ListMenuScreen.this.field_22789, ListMenuScreen.this.field_22790, 50, ListMenuScreen.this.field_22790 - 36, ListMenuScreen.this.itemHeight);
            entries.forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
        }

        protected int method_25329() {
            return this.field_22742 / 2 + 144;
        }

        public int method_25322() {
            return 260;
        }

        @Override
        public class_2960 getBackgroundTexture() {
            return ListMenuScreen.this.background;
        }

        public void method_25314(Collection<Item> entries) {
            super.method_25314(entries);
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            super.method_25394(graphics, mouseX, mouseY, partialTicks);
            this.renderToolTips(graphics, mouseX, mouseY);
        }

        private void renderToolTips(class_332 graphics, int mouseX, int mouseY) {
            this.method_25396().forEach(item -> item.method_25396().forEach(o -> {
                if (o instanceof class_4185) {
                    // empty if block
                }
            }));
        }
    }

    protected class FocusedEditBox
    extends class_342 {
        private boolean clearable;

        public FocusedEditBox(class_327 font, int x, int y, int width, int height, class_2561 label) {
            super(font, x, y, width, height, label);
            this.clearable = false;
        }

        public FocusedEditBox setClearable(boolean clearable) {
            this.clearable = clearable;
            return this;
        }

        public void method_25365(boolean focused) {
            super.method_25365(focused);
            if (focused) {
                if (ListMenuScreen.this.activeTextField != null && ListMenuScreen.this.activeTextField != this) {
                    ListMenuScreen.this.activeTextField.method_25365(false);
                }
                ListMenuScreen.this.activeTextField = this;
            }
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
            super.method_25394(graphics, mouseX, mouseY, partialTick);
            if (this.clearable && !this.method_1882().isEmpty()) {
                RenderSystem.setShader(class_757::method_34543);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_22765);
                boolean hovered = ScreenUtil.isMouseWithin(this.method_46426() + this.field_22758 - 15, this.method_46427() + 5, 9, 9, mouseX, mouseY);
                graphics.method_25293(IconButton.ICONS, this.method_46426() + this.field_22758 - 15, this.method_46427() + 5, 9, 9, hovered ? 9.0f : 0.0f, 55.0f, 9, 9, 64, 64);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.clearable && !this.method_1882().isEmpty() && button == 0 && ScreenUtil.isMouseWithin(this.method_46426() + this.field_22758 - 15, this.method_46427() + 5, 9, 9, (int)mouseX, (int)mouseY)) {
                this.method_25354(ListMenuScreen.this.field_22787.method_1483());
                this.method_1852("");
                return true;
            }
            return super.method_25402(mouseX, mouseY, button);
        }
    }

    protected static interface IIgnoreSearch {
    }

    protected abstract class Item
    extends class_4265.class_4266<Item>
    implements ILabelProvider,
    Comparable<Item> {
        protected final class_2561 label;
        @Nullable
        protected List<class_5481> tooltip;

        public Item(class_2561 label) {
            this.label = label;
        }

        public Item(String label) {
            this.label = class_2561.method_43470((String)label);
        }

        @Override
        public String getLabel() {
            return this.label.getString();
        }

        public void method_25343(class_332 graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            if (this.method_25405(mouseX, mouseY)) {
                ListMenuScreen.this.setActiveTooltip(this.tooltip);
            }
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 output) {
                    output.method_37034(class_6381.field_33788, Item.this.label);
                }
            });
        }

        @Override
        public int compareTo(Item o) {
            return this.label.getString().compareTo(o.label.getString());
        }
    }

    public class MultiTextItem
    extends Item
    implements IIgnoreSearch {
        private final class_2561 bottomText;

        public MultiTextItem(class_2561 topText, class_2561 bottomText) {
            super(topText);
            this.bottomText = bottomText;
        }

        @Override
        public void method_25343(class_332 graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            class_2583 style;
            class_2568 event;
            graphics.method_27534(((ListMenuScreen)ListMenuScreen.this).field_22787.field_1772, this.label, left + width / 2, top, -1);
            graphics.method_27534(((ListMenuScreen)ListMenuScreen.this).field_22787.field_1772, this.bottomText, left + width / 2, top + 12, -1);
            if (this.method_25405(mouseX, mouseY) && (event = (style = this.bottomText.method_10866()).method_10969()) != null && event.method_10892() == class_2568.class_5247.field_24342) {
                ListMenuScreen.this.setActiveTooltip((class_2561)event.method_10891(class_2568.class_5247.field_24342), -219136);
            }
        }
    }

    public class TitleItem
    extends Item
    implements IIgnoreSearch {
        public TitleItem(class_2561 title) {
            super(title);
        }

        public TitleItem(String title) {
            super((class_2561)class_2561.method_43470((String)title).method_27692(class_124.field_1067).method_27692(class_124.field_1054));
        }

        @Override
        public void method_25343(class_332 graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            graphics.method_27534(((ListMenuScreen)ListMenuScreen.this).field_22787.field_1772, this.label, left + width / 2, top + 5, 0xFFFFFF);
        }
    }
}

