/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.internal.expression;

import com.sk89q.worldedit.internal.expression.ExpressionTimeoutException;
import com.sk89q.worldedit.internal.expression.Functions;
import com.sk89q.worldedit.internal.expression.SlotTable;
import java.time.Instant;
import java.util.Objects;

public class ExecutionData {
    public static final ExecutionData CONSTANT_EVALUATOR = new ExecutionData(null, null, Instant.MAX);
    private final SlotTable slots;
    private final Functions functions;
    private final Instant deadline;

    public ExecutionData(SlotTable slots, Functions functions, Instant deadline) {
        this.slots = slots;
        this.functions = functions;
        this.deadline = deadline;
    }

    public SlotTable getSlots() {
        return Objects.requireNonNull(this.slots, "Cannot use variables in a constant");
    }

    public Functions getFunctions() {
        return Objects.requireNonNull(this.functions, "Cannot use functions in a constant");
    }

    public Instant getDeadline() {
        return this.deadline;
    }

    public void checkDeadline() {
        if (Instant.now().isAfter(this.deadline)) {
            throw new ExpressionTimeoutException("Calculations exceeded time limit.");
        }
    }
}

