/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.ui;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.ContextMenu;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.CursorType;
import dev.ftb.mods.ftblibrary.ui.IFocusableWidget;
import dev.ftb.mods.ftblibrary.ui.ModalPanel;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.ThemeManager;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.KeyModifiers;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.LoadingScreen;
import dev.ftb.mods.ftblibrary.util.BooleanConsumer;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1041;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_408;
import net.minecraft.class_410;
import net.minecraft.class_437;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public abstract class BaseScreen
extends Panel {
    private final class_437 prevScreen;
    private int mouseX;
    private int mouseY;
    private float partialTicks;
    private boolean refreshWidgets;
    private class_1041 screen;
    private long lastClickTime = 0L;
    private final Deque<ModalPanel> modalPanels;
    private Widget focusedWidget = null;

    public BaseScreen() {
        super(null);
        this.setSize(176, 166);
        this.setOnlyRenderWidgetsInside(false);
        this.setOnlyInteractWithWidgetsInside(false);
        this.prevScreen = class_310.method_1551().field_1755;
        this.modalPanels = new ArrayDeque<ModalPanel>();
    }

    @Override
    public final BaseScreen getGui() {
        return this;
    }

    @Override
    public void alignWidgets() {
    }

    public final void initGui() {
        this.screen = this.parent instanceof BaseScreen ? this.parent.getScreen() : class_310.method_1551().method_22683();
        if (this.onInit()) {
            super.refreshWidgets();
            this.alignWidgets();
            this.onPostInit();
        }
    }

    public Theme getTheme() {
        return ThemeManager.INSTANCE.getActiveTheme();
    }

    @Override
    public int getX() {
        return (this.getScreen().method_4486() - this.width) / 2;
    }

    @Override
    public int getY() {
        return (this.getScreen().method_4502() - this.height) / 2;
    }

    @Override
    public void setScrollX(double scroll) {
    }

    @Override
    public void setScrollY(double scroll) {
    }

    @Override
    public double getScrollX() {
        return 0.0;
    }

    @Override
    public double getScrollY() {
        return 0.0;
    }

    public boolean onInit() {
        return true;
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }

    protected boolean setFullscreen() {
        return this.setSizeProportional(1.0f, 1.0f);
    }

    protected boolean setSizeProportional(float w, float h) {
        Validate.isTrue((w > 0.0f && w <= 1.0f && h > 0.0f && h <= 1.0f ? 1 : 0) != 0, (String)"width and height must be > 0 and <= 1", (Object[])new Object[0]);
        if (this.screen == null) {
            return false;
        }
        this.setWidth((int)((float)this.screen.method_4486() * w));
        this.setHeight((int)((float)this.screen.method_4502() * h));
        return true;
    }

    public void onPostInit() {
    }

    public void pushModalPanel(ModalPanel modalPanel) {
        this.modalPanels.addFirst(modalPanel);
        modalPanel.refreshWidgets();
        modalPanel.setX(Math.min(modalPanel.getX(), this.getWidth() - modalPanel.getWidth() - 10));
        modalPanel.setY(Math.min(modalPanel.getY(), this.getHeight() - modalPanel.getHeight() - 10));
    }

    public ModalPanel popModalPanel() {
        if (this.modalPanels.isEmpty()) {
            return null;
        }
        ModalPanel panel = this.modalPanels.removeFirst();
        panel.onClosed();
        this.focusedWidget = null;
        return panel;
    }

    public void closeModalPanel(ModalPanel panel) {
        block1: {
            if (!this.modalPanels.contains(panel)) break block1;
            while (!this.modalPanels.isEmpty() && this.popModalPanel() != panel) {
            }
        }
    }

    public boolean anyModalPanelOpen() {
        return !this.modalPanels.isEmpty();
    }

    @Nullable
    public class_437 getPrevScreen() {
        ScreenWrapper sw;
        class_437 class_4372 = this.prevScreen;
        if (class_4372 instanceof ScreenWrapper && (sw = (ScreenWrapper)class_4372).getGui() instanceof LoadingScreen) {
            return sw.getGui().getPrevScreen();
        }
        if (this.prevScreen instanceof class_408) {
            return null;
        }
        return this.prevScreen;
    }

    @Override
    public final void closeGui(boolean openPrevScreen) {
        double mx = class_310.method_1551().field_1729.method_1603();
        double my = class_310.method_1551().field_1729.method_1604();
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null) {
            mc.field_1724.method_7346();
            if (mc.field_1755 == null) {
                mc.method_15995(true);
            }
        }
        if (openPrevScreen && this.getPrevScreen() != null) {
            mc.method_1507(this.getPrevScreen());
            GLFW.glfwSetCursorPos((long)this.getScreen().method_4490(), (double)mx, (double)my);
        }
        this.modalPanels.clear();
        this.onClosed();
    }

    public boolean onClosedByKey(Key key) {
        return key.escOrInventory();
    }

    public void onBack() {
        this.closeGui(true);
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    @Override
    public final void refreshWidgets() {
        this.refreshWidgets = true;
    }

    public final void updateGui(int mx, int my, float pt) {
        this.mouseX = mx;
        this.mouseY = my;
        this.partialTicks = pt;
        if (this.refreshWidgets) {
            super.refreshWidgets();
            this.modalPanels.forEach(Panel::refreshWidgets);
            this.refreshWidgets = false;
        }
        this.posX = this.getX();
        this.posY = this.getY();
        this.updateMouseOver(this.mouseX, this.mouseY);
    }

    @Override
    public void updateMouseOver(int mouseX, int mouseY) {
        this.isMouseOver = this.checkMouseOver(mouseX, mouseY);
        this.setOffset(true);
        this.modalPanels.forEach(p -> p.updateMouseOver(mouseX, mouseY));
        this.widgets.forEach(w -> w.updateMouseOver(mouseX, mouseY));
        this.setOffset(false);
    }

    @Override
    public final void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        super.draw(graphics, theme, x, y, w, h);
        if (!this.modalPanels.isEmpty()) {
            boolean r = this.getOnlyRenderWidgetsInside();
            boolean i = this.getOnlyInteractWithWidgetsInside();
            this.setOnlyRenderWidgetsInside(false);
            this.setOnlyInteractWithWidgetsInside(false);
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(0.0f, 0.0f, 10.0f);
            Iterator<ModalPanel> iter = this.modalPanels.descendingIterator();
            while (iter.hasNext()) {
                ModalPanel p = iter.next();
                if (!iter.hasNext()) {
                    graphics.method_51448().method_22904(0.0, 0.0, -0.05);
                    Color4I.rgba(-1608507360).draw(graphics, 0, 0, this.getScreen().method_4486(), this.getScreen().method_4502());
                    graphics.method_51448().method_22904(0.0, 0.0, 0.05);
                }
                graphics.method_51448().method_46416(0.0f, 0.0f, (float)p.getExtraZlevel());
                p.draw(graphics, theme, p.getX(), p.getY(), p.getWidth(), p.getHeight());
                graphics.method_51448().method_46416(0.0f, 0.0f, 1.0f);
            }
            graphics.method_51448().method_22909();
            this.setOnlyRenderWidgetsInside(r);
            this.setOnlyRenderWidgetsInside(i);
        }
    }

    public Optional<ModalPanel> getContextMenu() {
        return this.modalPanels.stream().filter(p -> p instanceof ContextMenu).findFirst();
    }

    public void openContextMenu(@Nullable ContextMenu newContextMenu) {
        if (newContextMenu == null) {
            this.modalPanels.removeIf(p -> p instanceof ContextMenu);
            return;
        }
        this.pushModalPanel(newContextMenu);
        int x = this.getX();
        int y = this.getY();
        int px = Math.min(this.getMouseX() - x, this.screen.method_4486() - newContextMenu.width - x) - 3;
        int py = Math.min(this.getMouseY() - y, this.screen.method_4502() - newContextMenu.height - y) - 3;
        newContextMenu.setPos(px, py);
    }

    public ContextMenu openContextMenu(@NotNull List<ContextMenuItem> menuItems) {
        ContextMenu contextMenu = new ContextMenu(this, menuItems);
        this.openContextMenu(contextMenu);
        return contextMenu;
    }

    @Override
    public void closeContextMenu() {
        this.openContextMenu((ContextMenu)null);
    }

    @Override
    public void onClosed() {
        super.onClosed();
        this.closeContextMenu();
        CursorType.set(null);
    }

    @Override
    public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        theme.drawGui(graphics, x, y, w, h, WidgetType.NORMAL);
    }

    public boolean drawDefaultBackground(class_332 graphics) {
        return true;
    }

    public void drawForeground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
    }

    private Panel getDoubleClickTarget() {
        return this.modalPanels.isEmpty() ? this : (Panel)this.modalPanels.peekFirst();
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (button == MouseButton.BACK) {
            this.closeGui(true);
            return true;
        }
        long now = System.currentTimeMillis();
        if (this.lastClickTime != 0L && now - this.lastClickTime <= 300L && this.getDoubleClickTarget().mouseDoubleClicked(button)) {
            this.lastClickTime = 0L;
            return true;
        }
        this.lastClickTime = now;
        if (this.modalPanels.isEmpty()) {
            return super.mousePressed(button);
        }
        if (this.modalPanels.peekFirst().isMouseOver()) {
            return this.modalPanels.peekFirst().mousePressed(button);
        }
        this.popModalPanel();
        return false;
    }

    @Override
    public boolean keyPressed(Key key) {
        if (this.focusedWidget != null && this.focusedWidget.keyPressed(key)) {
            return true;
        }
        if (!this.modalPanels.isEmpty()) {
            if (key.esc()) {
                this.popModalPanel();
                return true;
            }
            return this.modalPanels.peekFirst().keyPressed(key);
        }
        if (super.keyPressed(key)) {
            return true;
        }
        if (class_3675.method_15987((long)this.getGui().screen.method_4490(), (int)292) && key.is(66)) {
            Theme.renderDebugBoxes = !Theme.renderDebugBoxes;
            return true;
        }
        return false;
    }

    @Override
    public void keyReleased(Key key) {
        if (this.modalPanels.isEmpty()) {
            super.keyReleased(key);
        } else {
            this.modalPanels.peekFirst().keyReleased(key);
        }
    }

    @Override
    public boolean mouseDoubleClicked(MouseButton button) {
        return this.modalPanels.isEmpty() ? super.mouseDoubleClicked(button) : this.modalPanels.peekFirst().mouseDoubleClicked(button);
    }

    @Override
    public void mouseReleased(MouseButton button) {
        if (this.modalPanels.isEmpty()) {
            super.mouseReleased(button);
        } else {
            this.modalPanels.peekFirst().mouseReleased(button);
        }
    }

    @Override
    public boolean mouseScrolled(double scroll) {
        if (this.focusedWidget != null && this.focusedWidget.mouseScrolled(scroll)) {
            return true;
        }
        return this.modalPanels.isEmpty() ? super.mouseScrolled(scroll) : this.modalPanels.peekFirst().mouseScrolled(scroll);
    }

    @Override
    public boolean mouseDragged(int button, double dragX, double dragY) {
        return this.modalPanels.isEmpty() ? super.mouseDragged(button, dragX, dragY) : this.modalPanels.peekFirst().mouseDragged(button, dragX, dragY);
    }

    @Override
    public boolean charTyped(char c, KeyModifiers modifiers) {
        if (this.focusedWidget != null && this.focusedWidget.charTyped(c, modifiers)) {
            return true;
        }
        return this.modalPanels.isEmpty() ? super.charTyped(c, modifiers) : this.modalPanels.peekFirst().charTyped(c, modifiers);
    }

    @Override
    public boolean shouldAddMouseOverText() {
        return this.getContextMenu().isEmpty();
    }

    @Override
    public void addMouseOverText(TooltipList list) {
        if (!this.modalPanels.isEmpty()) {
            this.modalPanels.peekFirst().addMouseOverText(list);
        } else {
            super.addMouseOverText(list);
        }
    }

    @Override
    public final void openGui() {
        this.openContextMenu((ContextMenu)null);
        class_310.method_1551().method_1507((class_437)new ScreenWrapper(this));
    }

    @Override
    public final class_1041 getScreen() {
        if (this.screen == null) {
            return this.parent.getScreen();
        }
        return this.screen;
    }

    @Override
    public final int getMouseX() {
        return this.mouseX;
    }

    @Override
    public final int getMouseY() {
        return this.mouseY;
    }

    @Override
    public final float getPartialTicks() {
        return this.partialTicks;
    }

    public boolean isMouseOver(int x, int y, int w, int h) {
        return this.getMouseX() >= x && this.getMouseY() >= y && this.getMouseX() < x + w && this.getMouseY() < y + h;
    }

    public boolean isMouseOver(Widget widget) {
        if (widget == this) {
            return this.isMouseOver(this.getX(), this.getY(), this.width, this.height);
        }
        if (this.isMouseOver(widget.getX(), widget.getY(), widget.width, widget.height)) {
            boolean offset = widget.parent.isOffset();
            widget.parent.setOffset(false);
            boolean b = this.isMouseOver(widget.parent);
            widget.parent.setOffset(offset);
            return b;
        }
        return false;
    }

    @Override
    public boolean handleClick(String scheme, String path) {
        return ClientUtils.handleClick(scheme, path);
    }

    public void openYesNoFull(class_2561 title, class_2561 desc, BooleanConsumer callback) {
        class_310.method_1551().method_1507((class_437)new class_410(result -> {
            this.openGui();
            callback.accept(result);
            this.refreshWidgets();
        }, title, desc));
    }

    public final void openYesNo(class_2561 title, class_2561 desc, Runnable callback) {
        this.openYesNoFull(title, desc, result -> {
            if (result) {
                callback.run();
            }
        });
    }

    public void setFocusedWidget(Widget widget) {
        Validate.isTrue((boolean)(widget instanceof IFocusableWidget));
        Widget widget2 = this.focusedWidget;
        if (widget2 instanceof IFocusableWidget) {
            IFocusableWidget f = (IFocusableWidget)((Object)widget2);
            if (this.focusedWidget != widget) {
                f.setFocused(false);
            }
        }
        this.focusedWidget = widget;
    }

    public static class PositionedTextData {
        public final int posX;
        public final int posY;
        public final int width;
        public final int height;
        public final class_2558 clickEvent;
        public final class_2568 hoverEvent;
        public final String insertion;

        public PositionedTextData(int x, int y, int w, int h, class_2583 s) {
            this.posX = x;
            this.posY = y;
            this.width = w;
            this.height = h;
            this.clickEvent = s.method_10970();
            this.hoverEvent = s.method_10969();
            this.insertion = s.method_10955();
        }
    }
}

