/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.registry;

import java.lang.reflect.InvocationTargetException;
import java.util.function.Function;
import java.util.function.Predicate;
import net.blay09.mods.craftingtweaks.api.ButtonAlignment;
import net.blay09.mods.craftingtweaks.api.ButtonStyle;
import net.blay09.mods.craftingtweaks.api.CraftingGrid;
import net.blay09.mods.craftingtweaks.api.CraftingGridBuilder;
import net.blay09.mods.craftingtweaks.api.CraftingGridDecorator;
import net.blay09.mods.craftingtweaks.api.CraftingGridProvider;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksButtonStyles;
import net.blay09.mods.craftingtweaks.api.TweakType;
import net.blay09.mods.craftingtweaks.api.impl.DefaultCraftingGrid;
import net.blay09.mods.craftingtweaks.registry.CraftingTweaksRegistrationData;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataDrivenGridFactory {
    private static final Logger logger = LoggerFactory.getLogger(DataDrivenGridFactory.class);

    public static CraftingGridProvider createGridProvider(final CraftingTweaksRegistrationData data) {
        String validContainerPredicate;
        Predicate<class_1703> matchesContainerClass;
        final String senderModId = data.getModId();
        String containerClassName = data.getContainerClass();
        Predicate<class_1703> containerPredicate = matchesContainerClass = it -> it.getClass().getName().equals(containerClassName);
        String validContainerPredicateLegacy = data.getContainerCallbackClass();
        if (!validContainerPredicateLegacy.isEmpty()) {
            try {
                Class<?> functionClass = Class.forName(validContainerPredicateLegacy);
                if (!Function.class.isAssignableFrom(functionClass)) {
                    logger.error("{} sent a container callback that's not even a function", (Object)senderModId);
                    return null;
                }
                Function function = (Function)functionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                containerPredicate = t -> matchesContainerClass.test((class_1703)t) && (Boolean)function.apply(t) != false;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                logger.error("{} sent an invalid container callback.", (Object)senderModId);
            }
        }
        if (!(validContainerPredicate = data.getValidContainerPredicateClass()).isEmpty()) {
            try {
                Class<?> predicateClass = Class.forName(validContainerPredicate);
                if (!Predicate.class.isAssignableFrom(predicateClass)) {
                    logger.error("{} sent an invalid ValidContainerPredicate - it must implement Predicate<Container>", (Object)senderModId);
                    return null;
                }
                Predicate providedPredicate = (Predicate)predicateClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                containerPredicate = it -> matchesContainerClass.test((class_1703)it) && providedPredicate.test(it);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                logger.error("{} sent an invalid ValidContainerPredicate: {}", (Object)senderModId, (Object)e.getMessage());
            }
        }
        String getGridStartFunction = data.getGetGridStartFunctionClass();
        Function gridStartFunction = null;
        if (!getGridStartFunction.isEmpty()) {
            try {
                Class<?> functionClass = Class.forName(getGridStartFunction);
                if (!Function.class.isAssignableFrom(functionClass)) {
                    logger.error("{} sent an invalid GetGridStartFunction - it must implement Function<Container, Integer>", (Object)senderModId);
                    return null;
                }
                gridStartFunction = (Function)functionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                logger.error("{} sent an invalid GetGridStartFunction: {}", (Object)senderModId, (Object)e.getMessage());
            }
        }
        final Predicate<class_1703> effectiveContainerPredicate = containerPredicate;
        final Function effectiveGridStartFunction = gridStartFunction;
        return new CraftingGridProvider(){

            @Override
            public String getModId() {
                return senderModId;
            }

            @Override
            public boolean handles(class_1703 menu) {
                return effectiveContainerPredicate.test(menu);
            }

            @Override
            public void buildCraftingGrids(CraftingGridBuilder builder, class_1703 menu) {
                CraftingTweaksRegistrationData.TweakData clearTweak;
                CraftingTweaksRegistrationData.TweakData balanceTweak;
                CraftingTweaksRegistrationData.TweakData rotateTweak;
                CraftingGridDecorator grid;
                int gridSlotNumber = data.getGridSlotNumber();
                int gridSize = data.getGridSize();
                if (effectiveGridStartFunction != null) {
                    grid = new DefaultCraftingGrid(new class_2960(senderModId, "default"), gridSlotNumber, gridSize){

                        @Override
                        public int getGridStartSlot(class_1657 player, class_1703 menu) {
                            return (Integer)effectiveGridStartFunction.apply(menu);
                        }
                    };
                    builder.addCustomGrid((CraftingGrid)((Object)grid));
                } else {
                    grid = builder.addGrid(gridSlotNumber, gridSize);
                }
                int buttonOffsetX = DataDrivenGridFactory.unwrapOr(data.getButtonOffsetX(), 0);
                int buttonOffsetY = DataDrivenGridFactory.unwrapOr(data.getButtonOffsetY(), 0);
                grid.setButtonAlignmentOffset(buttonOffsetX, buttonOffsetY);
                ButtonAlignment alignToGrid = ButtonAlignment.LEFT;
                String alignToGridName = data.getAlignToGrid();
                switch (alignToGridName.toLowerCase()) {
                    case "north": 
                    case "up": 
                    case "top": {
                        alignToGrid = ButtonAlignment.TOP;
                        break;
                    }
                    case "south": 
                    case "down": 
                    case "bottom": {
                        alignToGrid = ButtonAlignment.BOTTOM;
                        break;
                    }
                    case "east": 
                    case "right": {
                        alignToGrid = ButtonAlignment.RIGHT;
                        break;
                    }
                    case "west": 
                    case "left": {
                        alignToGrid = ButtonAlignment.LEFT;
                    }
                }
                grid.setButtonAlignment(alignToGrid);
                ButtonStyle buttonStyle = CraftingTweaksButtonStyles.DEFAULT;
                String buttonStyleName = data.getButtonStyle();
                switch (buttonStyleName.toLowerCase()) {
                    case "default": {
                        buttonStyle = CraftingTweaksButtonStyles.DEFAULT;
                        break;
                    }
                    case "small_width": {
                        buttonStyle = CraftingTweaksButtonStyles.SMALL_WIDTH;
                        break;
                    }
                    case "small_height": {
                        buttonStyle = CraftingTweaksButtonStyles.SMALL_HEIGHT;
                        break;
                    }
                    case "small": {
                        buttonStyle = CraftingTweaksButtonStyles.SMALL;
                    }
                }
                grid.setButtonStyle(buttonStyle);
                if (data.isHideButtons()) {
                    grid.hideAllTweakButtons();
                }
                if (data.isPhantomItems()) {
                    grid.usePhantomItems();
                }
                if (!(rotateTweak = data.getTweakRotate()).isEnabled()) {
                    grid.disableTweak(TweakType.Rotate);
                }
                if (!rotateTweak.isShowButton()) {
                    grid.hideTweakButton(TweakType.Rotate);
                }
                if (rotateTweak.getButtonX() != null || rotateTweak.getButtonY() != null) {
                    grid.setButtonPosition(TweakType.Rotate, DataDrivenGridFactory.unwrapOr(data.getButtonOffsetX(), -16) + DataDrivenGridFactory.unwrapOr(rotateTweak.getButtonX(), 0), DataDrivenGridFactory.unwrapOr(data.getButtonOffsetY(), 16) + DataDrivenGridFactory.unwrapOr(rotateTweak.getButtonY(), 0));
                }
                if (!(balanceTweak = data.getTweakBalance()).isEnabled()) {
                    grid.disableTweak(TweakType.Balance);
                }
                if (!balanceTweak.isShowButton()) {
                    grid.hideTweakButton(TweakType.Balance);
                }
                if (balanceTweak.getButtonX() != null || balanceTweak.getButtonY() != null) {
                    grid.setButtonPosition(TweakType.Balance, DataDrivenGridFactory.unwrapOr(data.getButtonOffsetX(), -16) + DataDrivenGridFactory.unwrapOr(balanceTweak.getButtonX(), 0), DataDrivenGridFactory.unwrapOr(data.getButtonOffsetY(), 16) + DataDrivenGridFactory.unwrapOr(balanceTweak.getButtonY(), 0));
                }
                if (!(clearTweak = data.getTweakClear()).isEnabled()) {
                    grid.disableTweak(TweakType.Clear);
                }
                if (!clearTweak.isShowButton()) {
                    grid.hideTweakButton(TweakType.Clear);
                }
                if (clearTweak.getButtonX() != null || clearTweak.getButtonY() != null) {
                    grid.setButtonPosition(TweakType.Clear, DataDrivenGridFactory.unwrapOr(data.getButtonOffsetX(), -16) + DataDrivenGridFactory.unwrapOr(clearTweak.getButtonX(), 0), DataDrivenGridFactory.unwrapOr(data.getButtonOffsetY(), 16) + DataDrivenGridFactory.unwrapOr(clearTweak.getButtonY(), 0));
                }
            }
        };
    }

    private static int unwrapOr(Integer integer, int defaultValue) {
        return integer != null ? integer : defaultValue;
    }
}

