/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.gui;

import dev.ftb.mods.ftbchunks.api.client.event.MapIconEvent;
import dev.ftb.mods.ftbchunks.api.client.icon.MapIcon;
import dev.ftb.mods.ftbchunks.api.client.icon.MapType;
import dev.ftb.mods.ftbchunks.client.gui.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.gui.MapIconWidget;
import dev.ftb.mods.ftbchunks.client.gui.MapTileWidget;
import dev.ftb.mods.ftbchunks.client.map.MapChunk;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.mapicon.MapIconComparator;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbteams.api.Team;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;

public class RegionMapPanel
extends Panel {
    final LargeMapScreen largeMap;
    double regionX = 0.0;
    double regionZ = 0.0;
    int regionMinX;
    int regionMinZ;
    int regionMaxX;
    int regionMaxZ;
    int blockX = 0;
    int blockY = -32767;
    int blockZ = 0;
    int blockIndex = 0;
    private final List<MapIcon> mapIcons;

    public RegionMapPanel(LargeMapScreen panel) {
        super((Panel)panel);
        this.largeMap = panel;
        this.mapIcons = new ArrayList<MapIcon>();
    }

    public void updateMinMax() {
        this.regionMinX = Integer.MAX_VALUE;
        this.regionMinZ = Integer.MAX_VALUE;
        this.regionMaxX = Integer.MIN_VALUE;
        this.regionMaxZ = Integer.MIN_VALUE;
        for (Widget w : this.widgets) {
            if (!(w instanceof MapTileWidget)) continue;
            MapTileWidget tileWidget = (MapTileWidget)w;
            int qx = tileWidget.region.pos.x();
            int qy = tileWidget.region.pos.z();
            this.regionMinX = Math.min(this.regionMinX, qx);
            this.regionMinZ = Math.min(this.regionMinZ, qy);
            this.regionMaxX = Math.max(this.regionMaxX, qx);
            this.regionMaxZ = Math.max(this.regionMaxZ, qy);
        }
        if (this.regionMinX == Integer.MAX_VALUE) {
            this.regionMaxZ = 0;
            this.regionMaxX = 0;
            this.regionMinZ = 0;
            this.regionMinX = 0;
        }
        this.regionMinX -= 100;
        this.regionMinZ -= 100;
        this.regionMaxX += 101;
        this.regionMaxZ += 101;
    }

    public class_2338 blockPos() {
        return new class_2338(this.blockX, this.blockY, this.blockZ);
    }

    public void scrollTo(double x, double y) {
        this.updateMinMax();
        double dx = this.regionMaxX - this.regionMinX;
        double dy = this.regionMaxZ - this.regionMinZ;
        this.setScrollX((x - (double)this.regionMinX) / dx * (double)this.largeMap.scrollWidth - (double)this.width / 2.0);
        this.setScrollY((y - (double)this.regionMinZ) / dy * (double)this.largeMap.scrollHeight - (double)this.height / 2.0);
    }

    public void resetScroll() {
        this.alignWidgets();
        this.setScrollX((double)(this.largeMap.scrollWidth - this.width) / 2.0);
        this.setScrollY((double)(this.largeMap.scrollHeight - this.height) / 2.0);
    }

    public void addWidgets() {
        for (MapRegion region : this.largeMap.dimension.getRegions().values()) {
            this.add(new MapTileWidget(this, region));
        }
        class_310 mc = class_310.method_1551();
        this.mapIcons.clear();
        ((Consumer)MapIconEvent.LARGE_MAP.invoker()).accept(new MapIconEvent(this.largeMap.dimension.dimension, this.mapIcons, MapType.LARGE_MAP));
        if (this.mapIcons.size() >= 2) {
            this.mapIcons.sort(new MapIconComparator(mc.field_1724.method_19538(), 1.0f));
        }
        for (MapIcon icon : this.mapIcons) {
            if (!icon.isVisible(MapType.LARGE_MAP, MathUtils.dist((double)mc.field_1724.method_23317(), (double)mc.field_1724.method_23321(), (double)icon.getPos((float)1.0f).field_1352, (double)icon.getPos((float)1.0f).field_1350), false)) continue;
            this.add(new MapIconWidget(this, icon));
        }
        this.alignWidgets();
    }

    public void alignWidgets() {
        this.largeMap.scrollWidth = 0;
        this.largeMap.scrollHeight = 0;
        this.updateMinMax();
        int buttonSize = this.largeMap.getRegionTileSize();
        this.largeMap.scrollWidth = (this.regionMaxX - this.regionMinX) * buttonSize;
        this.largeMap.scrollHeight = (this.regionMaxZ - this.regionMinZ) * buttonSize;
        for (Widget w : this.widgets) {
            if (w instanceof MapTileWidget) {
                MapTileWidget tileWidget = (MapTileWidget)w;
                double qx = tileWidget.region.pos.x();
                double qy = tileWidget.region.pos.z();
                double qw = 1.0;
                double qh = 1.0;
                double x = (qx - (double)this.regionMinX) * (double)buttonSize;
                double y = (qy - (double)this.regionMinZ) * (double)buttonSize;
                w.setPosAndSize((int)x, (int)y, (int)((double)buttonSize * qw), (int)((double)buttonSize * qh));
                continue;
            }
            if (!(w instanceof MapIconWidget)) continue;
            MapIconWidget iconWidget = (MapIconWidget)w;
            MapIcon mapIcon = iconWidget.getMapIcon();
            double s = Math.max(mapIcon.isZoomDependant(MapType.LARGE_MAP) ? 0.0 : 6.0, (double)buttonSize / 128.0 * mapIcon.getIconScale(MapType.LARGE_MAP));
            if (s <= 1.0) {
                w.setSize(0, 0);
                continue;
            }
            w.setSize(class_3532.method_15384((double)s), class_3532.method_15384((double)s));
            iconWidget.updatePosition(1.0f);
        }
        this.setPosAndSize(0, 0, this.parent.width, this.parent.height);
    }

    public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        MapRegionData data;
        super.draw(graphics, theme, x, y, w, h);
        int dx = this.regionMaxX - this.regionMinX;
        int dy = this.regionMaxZ - this.regionMinZ;
        double px = this.getScrollX() - (double)this.getX();
        double py = this.getScrollY() - (double)this.getY();
        this.regionX = ((double)this.parent.getMouseX() + px) / (double)this.largeMap.scrollWidth * (double)dx + (double)this.regionMinX;
        this.regionZ = ((double)this.parent.getMouseY() + py) / (double)this.largeMap.scrollHeight * (double)dy + (double)this.regionMinZ;
        this.blockX = class_3532.method_15357((double)(this.regionX * 512.0));
        this.blockZ = class_3532.method_15357((double)(this.regionZ * 512.0));
        this.blockIndex = (this.blockX & 0x1FF) + (this.blockZ & 0x1FF) * 512;
        this.blockY = -32767;
        MapRegion region = this.largeMap.dimension.getRegions().get(XZ.regionFromBlock((int)this.blockX, (int)this.blockZ));
        if (region != null && (data = region.getData()) != null) {
            this.blockY = data.height[this.blockIndex];
        }
    }

    public void addMouseOverText(TooltipList list) {
        MapRegionData data;
        super.addMouseOverText(list);
        MapRegion mapRegion = this.largeMap.dimension.getRegions().get(XZ.regionFromBlock((int)this.blockX, (int)this.blockZ));
        if (mapRegion != null && (data = mapRegion.getData()) != null) {
            Team team;
            MapChunk mapChunk = mapRegion.getMapChunk(XZ.of((int)(this.blockX >> 4 & 0x1F), (int)(this.blockZ >> 4 & 0x1F)));
            Team team2 = team = mapChunk == null ? null : (Team)mapChunk.getTeam().orElse(null);
            if (team != null) {
                list.add(team.getName());
            }
        }
    }

    public boolean mousePressed(MouseButton button) {
        if (super.mousePressed(button)) {
            return true;
        }
        if (button.isLeft() && this.isMouseOver()) {
            this.largeMap.prevMouseX = this.getMouseX();
            this.largeMap.prevMouseY = this.getMouseY();
            this.largeMap.grabbed = 1;
            return true;
        }
        return false;
    }

    public void mouseReleased(MouseButton button) {
        super.mouseReleased(button);
        this.largeMap.grabbed = 0;
    }

    public boolean scrollPanel(double scroll) {
        if (this.isMouseOver()) {
            this.largeMap.addZoom(scroll);
            return true;
        }
        return false;
    }
}

