/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world.roll;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.basic.TypeSupplierAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import abeshutt.staracademy.data.serializable.ISerializable;
import abeshutt.staracademy.world.random.RandomSource;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public interface IntRoll
extends ISerializable<class_2487, JsonObject> {
    public int get(RandomSource var1);

    public static Constant ofConstant(int count) {
        return new Constant(count);
    }

    public static Uniform ofUniform(int min, int max) {
        return new Uniform(min, max);
    }

    public static int getMin(IntRoll roll) {
        if (roll instanceof Constant) {
            Constant constant = (Constant)roll;
            return constant.getCount();
        }
        if (roll instanceof Uniform) {
            Uniform uniform = (Uniform)roll;
            return uniform.getMin();
        }
        throw new UnsupportedOperationException();
    }

    public static int getMax(IntRoll roll) {
        if (roll instanceof Constant) {
            Constant constant = (Constant)roll;
            return constant.getCount();
        }
        if (roll instanceof Uniform) {
            Uniform uniform = (Uniform)roll;
            return uniform.getMax();
        }
        throw new UnsupportedOperationException();
    }

    public static class Constant
    implements IntRoll {
        private int count;

        protected Constant() {
        }

        protected Constant(int count) {
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public int get(RandomSource random) {
            return this.count;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_7.writeBits(this.count, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_7.readBits(buffer).ifPresent(value -> {
                this.count = value;
            });
        }

        @Override
        public Optional<class_2487> writeNbt() {
            class_2487 nbt = new class_2487();
            Adapters.INT.writeNbt(this.count).ifPresent(tag -> nbt.method_10566("count", tag));
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(class_2487 nbt) {
            Adapters.INT.readNbt(nbt.method_10580("count")).ifPresent(value -> {
                this.count = value;
            });
        }

        @Override
        public Optional<JsonObject> writeJson() {
            JsonObject json = new JsonObject();
            Adapters.INT.writeJson(this.count).ifPresent(tag -> json.add("count", tag));
            return Optional.of(json);
        }

        @Override
        public void readJson(JsonObject json) {
            Adapters.INT.readJson(json.get("count")).ifPresent(value -> {
                this.count = value;
            });
        }
    }

    public static class Uniform
    implements IntRoll {
        private int min;
        private int max;

        protected Uniform() {
        }

        protected Uniform(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        @Override
        public int get(RandomSource random) {
            return random.nextInt(this.max - this.min + 1) + this.min;
        }

        @Override
        public void writeBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_7.writeBits(this.min, buffer);
            Adapters.INT_SEGMENTED_7.writeBits(this.max, buffer);
        }

        @Override
        public void readBits(BitBuffer buffer) {
            Adapters.INT_SEGMENTED_7.readBits(buffer).ifPresent(value -> {
                this.min = value;
            });
            Adapters.INT_SEGMENTED_7.readBits(buffer).ifPresent(value -> {
                this.max = value;
            });
        }

        @Override
        public Optional<class_2487> writeNbt() {
            class_2487 nbt = new class_2487();
            Adapters.INT.writeNbt(this.min).ifPresent(tag -> nbt.method_10566("min", tag));
            Adapters.INT.writeNbt(this.max).ifPresent(tag -> nbt.method_10566("max", tag));
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(class_2487 nbt) {
            Adapters.INT.readNbt(nbt.method_10580("min")).ifPresent(value -> {
                this.min = value;
            });
            Adapters.INT.readNbt(nbt.method_10580("max")).ifPresent(value -> {
                this.max = value;
            });
        }

        @Override
        public Optional<JsonObject> writeJson() {
            JsonObject json = new JsonObject();
            Adapters.INT.writeJson(this.min).ifPresent(tag -> json.add("min", tag));
            Adapters.INT.writeJson(this.max).ifPresent(tag -> json.add("max", tag));
            return Optional.of(json);
        }

        @Override
        public void readJson(JsonObject json) {
            Adapters.INT.readJson(json.get("min")).ifPresent(value -> {
                this.min = value;
            });
            Adapters.INT.readJson(json.get("max")).ifPresent(value -> {
                this.max = value;
            });
        }
    }

    public static class Adapter
    extends TypeSupplierAdapter<IntRoll> {
        public Adapter() {
            super("type", true);
            this.register("constant", Constant.class, Constant::new);
            this.register("uniform", Uniform.class, Uniform::new);
        }

        @Override
        protected IntRoll readSuppliedNbt(class_2520 nbt) {
            Optional result;
            if ((nbt instanceof class_2514 || nbt instanceof class_2519) && (result = Adapters.INT.readNbt(nbt)).isPresent()) {
                return IntRoll.ofConstant((Integer)result.get());
            }
            return (IntRoll)super.readSuppliedNbt(nbt);
        }

        @Override
        protected IntRoll readSuppliedJson(JsonElement json) {
            Optional result;
            JsonPrimitive primitive;
            if (json instanceof JsonPrimitive && ((primitive = (JsonPrimitive)json).isNumber() || primitive.isString()) && (result = Adapters.INT.readJson(json)).isPresent()) {
                return IntRoll.ofConstant((Integer)result.get());
            }
            return (IntRoll)super.readSuppliedJson(json);
        }
    }
}

