/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world.inventory;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.serializable.INbtSerializable;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1657;
import net.minecraft.class_1662;
import net.minecraft.class_1737;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class BaseInventory
implements class_1263,
class_1737,
INbtSerializable<class_2487> {
    private int size;
    private class_2371<class_1799> stacks;
    private List<class_1265> listeners;
    private boolean dirty;

    public BaseInventory(int size) {
        this.size = size;
        this.stacks = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
    }

    public BaseInventory(class_1799 ... items) {
        this.size = items.length;
        this.stacks = class_2371.method_10212((Object)class_1799.field_8037, (Object[])items);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void addListener(class_1265 listener) {
        if (this.listeners == null) {
            this.listeners = Lists.newArrayList();
        }
        this.listeners.add(listener);
    }

    public void removeListener(class_1265 listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public class_1799 method_5438(int slot) {
        return slot >= 0 && slot < this.stacks.size() ? (class_1799)this.stacks.get(slot) : class_1799.field_8037;
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 itemStack = class_1262.method_5430(this.stacks, (int)slot, (int)amount);
        if (!itemStack.method_7960()) {
            this.method_5431();
        }
        return itemStack;
    }

    public class_1799 removeItem(class_1792 item, int count) {
        class_1799 itemStack = new class_1799((class_1935)item, 0);
        for (int i = this.size - 1; i >= 0; --i) {
            class_1799 itemStack2 = this.method_5438(i);
            if (!itemStack2.method_7909().equals(item)) continue;
            int j = count - itemStack.method_7947();
            class_1799 itemStack3 = itemStack2.method_7971(j);
            itemStack.method_7933(itemStack3.method_7947());
            if (itemStack.method_7947() == count) break;
        }
        if (!itemStack.method_7960()) {
            this.method_5431();
        }
        return itemStack;
    }

    public class_1799 addStack(class_1799 stack) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 itemStack = stack.method_7972();
        this.addToExistingSlot(itemStack);
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        this.addToNewSlot(itemStack);
        return itemStack.method_7960() ? class_1799.field_8037 : itemStack;
    }

    public boolean canInsert(class_1799 stack) {
        boolean bl = false;
        for (class_1799 itemStack : this.stacks) {
            if (!itemStack.method_7960() && (!class_1799.method_31577((class_1799)itemStack, (class_1799)stack) || itemStack.method_7947() >= itemStack.method_7914())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public class_1799 method_5441(int slot) {
        class_1799 itemStack = (class_1799)this.stacks.get(slot);
        if (itemStack.method_7960()) {
            return class_1799.field_8037;
        }
        this.stacks.set(slot, (Object)class_1799.field_8037);
        return itemStack;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.stacks.set(slot, (Object)stack);
        if (!stack.method_7960() && stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public int method_5439() {
        return this.size;
    }

    public boolean method_5442() {
        class_1799 itemStack;
        Iterator var1 = this.stacks.iterator();
        do {
            if (var1.hasNext()) continue;
            return true;
        } while ((itemStack = (class_1799)var1.next()).method_7960());
        return false;
    }

    public void method_5431() {
        this.setDirty(true);
        if (this.listeners != null) {
            for (class_1265 listener : this.listeners) {
                listener.method_5453((class_1263)this);
            }
        }
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.stacks.clear();
        this.method_5431();
    }

    public void method_7683(class_1662 finder) {
        for (class_1799 itemStack : this.stacks) {
            finder.method_7400(itemStack);
        }
    }

    public String toString() {
        return this.stacks.stream().filter(stack -> !stack.method_7960()).collect(Collectors.toList()).toString();
    }

    private void addToNewSlot(class_1799 stack) {
        for (int i = 0; i < this.size; ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (!itemStack.method_7960()) continue;
            this.method_5447(i, stack.method_51164());
            return;
        }
    }

    private void addToExistingSlot(class_1799 stack) {
        for (int i = 0; i < this.size; ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (!class_1799.method_31577((class_1799)itemStack, (class_1799)stack)) continue;
            this.transfer(stack, itemStack);
            if (!stack.method_7960()) continue;
            return;
        }
    }

    private void transfer(class_1799 source, class_1799 target) {
        int i = Math.min(this.method_5444(), target.method_7914());
        int j = Math.min(source.method_7947(), i - target.method_7947());
        if (j > 0) {
            target.method_7933(j);
            source.method_7934(j);
            this.method_5431();
        }
    }

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            Adapters.INT.writeNbt(this.method_5439()).ifPresent(tag -> nbt.method_10566("size", tag));
            class_2499 items = new class_2499();
            for (int i = 0; i < this.size; ++i) {
                class_1799 stack = (class_1799)this.stacks.get(i);
                if (stack.method_7960()) continue;
                class_2487 entry = new class_2487();
                Adapters.INT.writeNbt(i).ifPresent(tag -> entry.method_10566("index", tag));
                Adapters.ITEM.writeNbt(stack.method_7909()).ifPresent(tag -> entry.method_10566("item", tag));
                Adapters.INT.writeNbt(stack.method_7947()).ifPresent(tag -> entry.method_10566("count", tag));
                Adapters.COMPOUND_NBT.writeNbt(stack.method_7969()).ifPresent(tag -> entry.method_10566("nbt", tag));
                items.add((Object)entry);
            }
            nbt.method_10566("items", (class_2520)items);
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.size = Adapters.INT.readNbt(nbt.method_10580("size")).orElse(0);
        this.stacks = class_2371.method_10213((int)this.size, (Object)class_1799.field_8037);
        class_2499 items = nbt.method_10554("items", 10);
        for (int i = 0; i < items.size(); ++i) {
            class_2487 entry = items.method_10602(i);
            int index = Adapters.INT.readNbt(entry.method_10580("index")).orElse(-1);
            class_1792 item = Adapters.ITEM.readNbt(entry.method_10580("item")).orElse(class_1802.field_8162);
            int count = Adapters.INT.readNbt(entry.method_10580("count")).orElse(1);
            class_2487 compound = Adapters.COMPOUND_NBT.readNbt(entry.method_10580("nbt")).orElse(null);
            class_1799 stack = new class_1799((class_1935)item, count);
            if (compound != null) {
                stack.method_7980(compound);
            }
            if (index < 0 || index >= this.size) continue;
            this.stacks.set(index, (Object)stack);
        }
        this.method_5431();
    }
}

