/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world.data;

import abeshutt.staracademy.GameStarterHandler;
import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.basic.EnumAdapter;
import abeshutt.staracademy.init.ModConfigs;
import abeshutt.staracademy.init.ModNetwork;
import abeshutt.staracademy.init.ModWorldData;
import abeshutt.staracademy.net.UpdateStarterRaffleS2CPacket;
import abeshutt.staracademy.world.StarterEntry;
import abeshutt.staracademy.world.data.StarterMode;
import abeshutt.staracademy.world.data.WorldData;
import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.advancement.CobblemonCriteria;
import com.cobblemon.mod.common.api.events.Cancelable;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.starter.StarterChosenEvent;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.starter.StarterHandler;
import com.cobblemon.mod.common.api.storage.player.PlayerData;
import com.cobblemon.mod.common.config.starter.StarterCategory;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.starter.CobblemonStarterHandler;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import com.cobblemon.mod.common.util.ResourceLocationExtensionsKt;
import com.cobblemon.mod.common.world.gamerules.CobblemonGameRules;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kotlin.Unit;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class PokemonStarterData
extends WorldData {
    public static final PokemonStarterData CLIENT = new PokemonStarterData(0L, StarterMode.RAFFLE_PAUSED, 0);
    private final Set<class_2960> starters = new LinkedHashSet<class_2960>();
    private final Map<UUID, StarterEntry> entries = new HashMap<UUID, StarterEntry>();
    private long timeInterval;
    private long timeLeft;
    private StarterMode mode;
    private StarterMode lastMode;
    private int selectionCooldown;
    private boolean changed;

    private PokemonStarterData(long timeInterval, StarterMode mode, int selectionCooldown) {
        this.timeLeft = this.timeInterval = timeInterval;
        this.mode = mode;
        this.lastMode = null;
        this.selectionCooldown = selectionCooldown;
    }

    public PokemonStarterData() {
        this(ModConfigs.STARTER_RAFFLE.getTimeInterval(), ModConfigs.STARTER_RAFFLE.getMode(), ModConfigs.STARTER_RAFFLE.getSelectionCooldown());
    }

    public Set<class_2960> getStarters() {
        return this.starters;
    }

    public Map<UUID, StarterEntry> getEntries() {
        return this.entries;
    }

    public class_2960 getPick(UUID uuid) {
        StarterEntry entry = this.entries.get(uuid);
        if (entry == null) {
            return null;
        }
        return entry.getPick();
    }

    public void setPick(UUID uuid, class_2960 pick) {
        StarterEntry entry = this.entries.computeIfAbsent(uuid, key -> new StarterEntry());
        entry.setPick(pick);
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(long timeInterval) {
        this.timeLeft = this.timeInterval = timeInterval;
        this.setChanged(true);
    }

    public long getTimeLeft() {
        return this.timeLeft;
    }

    public void setTimeLeft(long timeLeft) {
        this.timeLeft = timeLeft;
        this.setChanged(true);
    }

    public StarterMode getMode() {
        return this.mode;
    }

    public boolean setMode(StarterMode mode) {
        boolean changed = this.mode != mode;
        this.mode = mode;
        if (changed) {
            this.setChanged(true);
            return true;
        }
        return false;
    }

    public int getSelectionCooldown() {
        return this.selectionCooldown;
    }

    public void setSelectionCooldown(int selectionCooldown) {
        if (this.selectionCooldown != selectionCooldown) {
            this.setChanged(true);
        }
        this.selectionCooldown = selectionCooldown;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
        this.method_80();
    }

    public boolean isGranted(class_2960 speciesId) {
        for (StarterEntry entry : this.entries.values()) {
            if (!speciesId.equals((Object)entry.getGranted())) continue;
            return true;
        }
        return false;
    }

    public void onTick(MinecraftServer server) {
        if (this.mode != this.lastMode) {
            Cobblemon.INSTANCE.setStarterHandler((StarterHandler)(switch (this.mode) {
                default -> throw new IncompatibleClassChangeError();
                case StarterMode.DEFAULT -> new CobblemonStarterHandler();
                case StarterMode.RAFFLE_ENABLED, StarterMode.RAFFLE_PAUSED -> new GameStarterHandler();
            }));
            this.lastMode = this.mode;
        }
        if (this.mode == StarterMode.RAFFLE_ENABLED) {
            if (this.getTimeLeft() <= 0L) {
                this.onRaffle(server);
                this.setTimeLeft(this.getTimeInterval());
            } else {
                this.setTimeLeft(this.getTimeLeft() - 1L);
            }
        }
        HashMap<UUID, StarterEntry> changes = new HashMap<UUID, StarterEntry>();
        this.entries.forEach((uuid, entry) -> {
            if (entry.isChanged()) {
                changes.put((UUID)uuid, (StarterEntry)entry);
                entry.setChanged(false);
                this.method_80();
            }
        });
        this.setSelectionCooldown(ModConfigs.STARTER_RAFFLE.getSelectionCooldown());
        if (!changes.isEmpty() || this.changed) {
            for (class_3222 player : server.method_3760().method_14571()) {
                HashMap<UUID, StarterEntry> message = new HashMap<UUID, StarterEntry>();
                changes.forEach((uuid, entry) -> {
                    if (entry.getGranted() != null || player.method_5667().equals(uuid)) {
                        message.put((UUID)uuid, (StarterEntry)entry);
                    }
                });
                ModNetwork.CHANNEL.sendToPlayer(player, (Object)new UpdateStarterRaffleS2CPacket(null, message, this.timeInterval, this.timeLeft, this.mode, this.selectionCooldown));
            }
        }
    }

    private void onJoin(class_3222 player) {
        Set<class_2960> starters = Cobblemon.INSTANCE.getStarterHandler().getStarterList(player).stream().flatMap(category -> category.getPokemon().stream()).map(PokemonProperties::getSpecies).filter(Objects::nonNull).map(s -> ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace((String)s, (String)"cobblemon")).collect(Collectors.toSet());
        this.entries.putIfAbsent(player.method_5667(), new StarterEntry());
        HashMap<UUID, StarterEntry> message = new HashMap<UUID, StarterEntry>();
        this.entries.forEach((uuid, entry) -> {
            if (entry.getGranted() != null || player.method_5667().equals(uuid)) {
                message.put((UUID)uuid, (StarterEntry)entry);
            }
        });
        ModNetwork.CHANNEL.sendToPlayer(player, (Object)new UpdateStarterRaffleS2CPacket(starters, message, this.timeInterval, this.timeLeft, this.mode, this.selectionCooldown));
    }

    private void onRaffle(MinecraftServer server) {
        HashMap picks = new HashMap();
        this.entries.forEach((uuid, entry) -> {
            if (entry.getPick() == null) {
                return;
            }
            picks.computeIfAbsent(entry.getPick(), k -> new HashSet()).add(uuid);
        });
        picks.entrySet().removeIf(entry -> {
            if (((Set)entry.getValue()).size() != 1) {
                return false;
            }
            UUID uuid = (UUID)((Set)entry.getValue()).iterator().next();
            StarterEntry data = this.getEntries().get(uuid);
            class_3222 player = server.method_3760().method_14602(uuid);
            if (player == null) {
                return false;
            }
            Species species = PokemonSpecies.INSTANCE.getByIdentifier((class_2960)entry.getKey());
            if (species == null) {
                return false;
            }
            if (this.giveStarter(player, (class_2960)entry.getKey())) {
                data.setGranted((class_2960)entry.getKey());
                for (class_3222 other : server.method_3760().method_14571()) {
                    other.method_43496((class_2561)class_2561.method_43473().method_10852(player.method_5477()).method_10852((class_2561)class_2561.method_43470((String)" has claimed ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)species.getName()).method_10862(class_2583.field_24360.method_36139(species.getPrimaryType().getHue()))).method_10852((class_2561)class_2561.method_43470((String)" as their starter!").method_27692(class_124.field_1080)));
                }
            }
            return true;
        });
        for (StarterEntry entry2 : this.entries.values()) {
            entry2.setPick(null);
            entry2.onCompleteRound();
        }
    }

    public boolean giveStarter(class_3222 player, class_2960 speciesId) {
        PlayerData playerData = Cobblemon.playerData.get((class_1657)player);
        if (playerData.getStarterSelected()) {
            player.method_7353((class_2561)LocalizationUtilsKt.lang((String)"ui.starter.alreadyselected", (Object[])new Object[0]).method_27692(class_124.field_1061), true);
            return false;
        }
        if (playerData.getStarterLocked()) {
            player.method_7353((class_2561)LocalizationUtilsKt.lang((String)"ui.starter.cannotchoose", (Object[])new Object[0]).method_27692(class_124.field_1061), true);
            return false;
        }
        PokemonProperties properties = null;
        block0: for (StarterCategory category : Cobblemon.starterConfig.getStarters()) {
            for (PokemonProperties pokemon : category.getPokemon()) {
                class_2960 other;
                if (pokemon.getSpecies() == null || !speciesId.equals((Object)(other = ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace((String)pokemon.getSpecies(), (String)"cobblemon")))) continue;
                properties = pokemon;
                break block0;
            }
        }
        if (properties == null) {
            return false;
        }
        Pokemon pokemon = properties.create();
        CobblemonEvents.STARTER_CHOSEN.postThen((Cancelable)new StarterChosenEvent(player, properties, pokemon), event -> Unit.INSTANCE, event -> {
            playerData.setStarterSelected(true);
            playerData.setStarterUUID(pokemon.getUuid());
            if (player.method_37908().method_8450().method_8355(CobblemonGameRules.SHINY_STARTERS)) {
                pokemon.setShiny(true);
            }
            Cobblemon.INSTANCE.getStorage().getParty(player).add(pokemon);
            CobblemonCriteria.INSTANCE.getPICK_STARTER().trigger(player, (Object)pokemon);
            Cobblemon.playerData.saveSingle(playerData);
            playerData.sendToPlayer(player);
            return Unit.INSTANCE;
        });
        return true;
    }

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            class_2487 entries = new class_2487();
            for (Map.Entry<UUID, StarterEntry> entry : this.entries.entrySet()) {
                entry.getValue().writeNbt().ifPresent(tag -> entries.method_10566(((UUID)entry.getKey()).toString(), (class_2520)tag));
            }
            nbt.method_10566("entries", (class_2520)entries);
            Adapters.LONG.writeNbt(this.timeInterval).ifPresent(tag -> nbt.method_10566("timeInterval", tag));
            Adapters.LONG.writeNbt(this.timeLeft).ifPresent(tag -> nbt.method_10566("timeLeft", tag));
            Adapters.ofEnum(StarterMode.class, EnumAdapter.Mode.NAME).writeNbt(this.mode).ifPresent(tag -> nbt.method_10566("mode", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        class_2487 entries = nbt.method_10562("entries");
        this.entries.clear();
        for (String key : entries.method_10541()) {
            StarterEntry entry = new StarterEntry();
            entry.readNbt(entries.method_10562(key));
            this.entries.put(UUID.fromString(key), entry);
        }
        this.timeInterval = Adapters.LONG.readNbt(nbt.method_10580("timeInterval")).orElseGet(ModConfigs.STARTER_RAFFLE::getTimeInterval);
        this.timeLeft = Math.min(Adapters.LONG.readNbt(nbt.method_10580("timeLeft")).orElse(this.timeInterval), this.timeInterval);
        this.mode = nbt.method_10545("mode") ? Adapters.ofEnum(StarterMode.class, EnumAdapter.Mode.NAME).readNbt(nbt.method_10580("mode")).orElseGet(ModConfigs.STARTER_RAFFLE::getMode) : (Adapters.BOOLEAN.readNbt(nbt.method_10580("paused")).orElse(false) != false ? StarterMode.RAFFLE_PAUSED : StarterMode.RAFFLE_ENABLED);
    }

    public static void init() {
        PlayerEvent.PLAYER_JOIN.register(player -> {
            PokemonStarterData data = ModWorldData.POKEMON_STARTER.getGlobal(player.method_37908());
            data.onJoin(player);
        });
        TickEvent.SERVER_POST.register(server -> {
            PokemonStarterData data = ModWorldData.POKEMON_STARTER.getGlobal((MinecraftServer)server);
            data.onTick((MinecraftServer)server);
        });
    }
}

