/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.world.data;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.init.ModWorldData;
import abeshutt.staracademy.world.data.WorldData;
import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.storage.NoPokemonStoreException;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCPosition;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import dev.architectury.event.events.common.TickEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class PartnerData
extends WorldData {
    private final Map<UUID, class_2960> selections = new HashMap<UUID, class_2960>();

    public Optional<Species> getSelection(UUID uuid) {
        return Optional.ofNullable(this.selections.get(uuid)).map(arg_0 -> ((PokemonSpecies)PokemonSpecies.INSTANCE).getByIdentifier(arg_0));
    }

    public void setSelection(UUID uuid, Species species) {
        this.selections.put(uuid, species.getResourceIdentifier());
        this.method_78(true);
    }

    public void setAndNotifySelection(class_3222 player, Species species) {
        this.setSelection(player.method_5667(), species);
        if (player.method_5682() == null) {
            return;
        }
        int color = species.getPrimaryType().getHue();
        for (class_3222 other : player.method_5682().method_3760().method_14571()) {
            other.method_43496((class_2561)class_2561.method_43473().method_10852(player.method_5477()).method_10852((class_2561)class_2561.method_43470((String)" selected ").method_27692(class_124.field_1080)).method_10852((class_2561)species.getTranslatedName().method_10862(class_2583.field_24360.method_36139(color))).method_10852((class_2561)class_2561.method_43470((String)" as their companion!").method_27692(class_124.field_1080)));
        }
    }

    public void onTick(MinecraftServer server) {
        HashSet<class_2960> picked = new HashSet<class_2960>(this.selections.values());
        for (class_3222 player : server.method_3760().method_14571()) {
            PCStore pc;
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            try {
                pc = Cobblemon.INSTANCE.getStorage().getPC(player.method_5667());
            }
            catch (NoPokemonStoreException e) {
                continue;
            }
            for (int i = 0; i < party.size(); ++i) {
                Pokemon entry = party.get(i);
                if (entry == null || !picked.contains(entry.getSpecies().getResourceIdentifier())) continue;
                PCPosition target = pc.getFirstAvailablePosition();
                if (target != null) {
                    party.remove(entry);
                    pc.set(target, entry);
                    continue;
                }
                if (party.getOverflowPC() == null || (target = party.getOverflowPC().getFirstAvailablePosition()) == null) continue;
                party.remove(entry);
                party.getOverflowPC().set(target, entry);
            }
        }
    }

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            class_2487 selections = new class_2487();
            this.selections.forEach((uuid, species) -> Adapters.IDENTIFIER.writeNbt((class_2960)species).ifPresent(tag -> selections.method_10566(uuid.toString(), tag)));
            nbt.method_10566("selections", (class_2520)selections);
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.selections.clear();
        class_2487 selections = nbt.method_10562("selections");
        for (String key : selections.method_10541()) {
            Adapters.IDENTIFIER.readNbt(selections.method_10580(key)).ifPresent(species -> this.selections.put(UUID.fromString(key), (class_2960)species));
        }
    }

    public static void init() {
        TickEvent.SERVER_POST.register(server -> {
            PartnerData data = ModWorldData.PARTNER.getGlobal((MinecraftServer)server);
            data.onTick((MinecraftServer)server);
        });
    }
}

