/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.mixin;

import abeshutt.staracademy.StarAcademyMod;
import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.init.ModConfigs;
import abeshutt.staracademy.init.ModWorldData;
import abeshutt.staracademy.util.ProxyEntity;
import abeshutt.staracademy.world.data.EntityState;
import abeshutt.staracademy.world.data.SafariData;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_5454;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1297.class})
public abstract class MixinEntity
implements ProxyEntity {
    @Unique
    private boolean inSafariPortal;
    @Unique
    private boolean safariPortalCooldown;

    @Shadow
    public abstract class_1937 method_37908();

    @Shadow
    public abstract UUID method_5667();

    @Shadow
    protected abstract void method_5852();

    @Shadow
    public abstract boolean method_30230();

    @Override
    public boolean isInSafariPortal() {
        return this.inSafariPortal;
    }

    @Override
    public boolean hasSafariPortalCooldown() {
        return this.safariPortalCooldown;
    }

    @Override
    public void setInSafariPortal(boolean inSafariPortal) {
        this.inSafariPortal = inSafariPortal;
    }

    @Override
    public void setSafariPortalCooldown(boolean safariPortalCooldown) {
        this.safariPortalCooldown = safariPortalCooldown;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tickHead(CallbackInfo ci) {
        this.setInSafariPortal(false);
        if (this.hasSafariPortalCooldown() && !this.method_30230()) {
            this.method_5852();
            if (!this.isInSafariPortal()) {
                this.setSafariPortalCooldown(false);
            }
        }
    }

    @Inject(method={"getTeleportTarget"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getTeleportTarget(class_3218 destination, CallbackInfoReturnable<class_5454> ci) {
        if (destination.method_27983() == StarAcademyMod.SAFARI) {
            class_2338 pos = ModConfigs.SAFARI.getPlacementOffset().method_10081((class_2382)ModConfigs.SAFARI.getRelativeSpawnPosition());
            ci.setReturnValue((Object)new class_5454(new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5), class_243.field_1353, ModConfigs.SAFARI.getSpawnYaw(), ModConfigs.SAFARI.getSpawnPitch()));
        } else if (this.method_37908().method_27983() == StarAcademyMod.SAFARI) {
            SafariData.Entry entry = ModWorldData.SAFARI.getGlobal(this.method_37908()).get(this.method_5667()).orElseThrow();
            EntityState state = entry.getLastState();
            ci.setReturnValue((Object)new class_5454(state.getPos(), class_243.field_1353, state.getYaw(), state.getPitch()));
        }
    }

    @Inject(method={"writeNbt"}, at={@At(value="RETURN")})
    public void writeNbt(class_2487 nbt, CallbackInfoReturnable<class_2487> ci) {
        Adapters.BOOLEAN.writeNbt(this.inSafariPortal).ifPresent(tag -> nbt.method_10566("inSafariPortal", tag));
        Adapters.BOOLEAN.writeNbt(this.safariPortalCooldown).ifPresent(tag -> nbt.method_10566("safariPortalCooldown", tag));
    }

    @Inject(method={"readNbt"}, at={@At(value="RETURN")})
    public void readNbt(class_2487 nbt, CallbackInfo ci) {
        this.inSafariPortal = Adapters.BOOLEAN.readNbt(nbt.method_10580("inSafariPortal")).orElse(false);
        this.safariPortalCooldown = Adapters.BOOLEAN.readNbt(nbt.method_10580("safariPortalCooldown")).orElse(false);
    }
}

