/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.item;

import abeshutt.staracademy.entity.StarBadgeEntity;
import abeshutt.staracademy.util.ClientScheduler;
import abeshutt.staracademy.util.ColorBlender;
import abeshutt.staracademy.world.StarOwnership;
import abeshutt.staracademy.world.data.PlayerProfileData;
import com.mojang.authlib.GameProfile;
import dev.architectury.platform.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5250;

public class StarBadgeItem
extends class_1792 {
    public StarBadgeItem() {
        super(new class_1792.class_1793().method_24359().method_7889(1));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14873, class_3419.field_15254, 0.5f, 0.4f / (world.method_8409().method_43057() * 0.4f + 0.8f));
        if (!world.field_9236) {
            StarBadgeEntity entity = new StarBadgeEntity(world, (class_1309)user, stack.method_7972());
            entity.method_24919((class_1297)user, user.method_36455(), user.method_36454(), 0.0f, 1.0f, 0.0f);
            world.method_8649((class_1297)entity);
        }
        user.method_7259(class_3468.field_15372.method_14956((Object)this));
        stack.method_7939(0);
        return class_1271.method_29237((Object)stack, (boolean)world.method_8608());
    }

    public class_2561 method_7864(class_1799 stack) {
        String name = super.method_7864(stack).getString();
        double time = 0.0;
        if (Platform.getEnv() != EnvType.SERVER) {
            time = ClientScheduler.getTick(class_310.method_1551().method_1488());
        }
        return this.styleText(name, time, 10.0f);
    }

    private class_2561 styleText(String string, double time, float offset) {
        class_5250 text = class_2561.method_43473();
        int count = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            text = text.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(c)).method_10862(class_2583.field_24360.method_36139(this.getColor(time + (double)((float)count * offset)).orElseThrow().intValue())));
            if (c == ' ') continue;
            ++count;
        }
        return text;
    }

    public Optional<Integer> getColor(double time) {
        ColorBlender blender = new ColorBlender(1.0f).add(14918453, 60.0f).add(12021042, 60.0f);
        return Optional.of(blender.getColor(time));
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        List<StarOwnership> ownership = StarBadgeItem.getOwnership(stack);
        if (ownership.isEmpty()) {
            return;
        }
        String original = PlayerProfileData.CLIENT.getProfile(ownership.get(0).getUuid()).map(GameProfile::getName).orElse("Unknown");
        tooltip.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Originally bestowed to ").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)original).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)".").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})));
        if (ownership.size() < 2) {
            return;
        }
        String surrendered = PlayerProfileData.CLIENT.getProfile(ownership.get(ownership.size() - 2).getUuid()).map(GameProfile::getName).orElse("Unknown");
        tooltip.add((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Last surrendered by ").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)surrendered).method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)".").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})));
    }

    public static List<StarOwnership> getOwnership(class_1799 stack) {
        ArrayList<StarOwnership> ownership = new ArrayList<StarOwnership>();
        if (stack.method_7969() != null) {
            class_2499 list = stack.method_7969().method_10554("ownership", 10);
            for (int i = 0; i < list.size(); ++i) {
                ownership.add(StarOwnership.parseNbt(list.method_10602(i)));
            }
        }
        return ownership;
    }

    public static void setOwnership(class_1799 stack, List<StarOwnership> ownership) {
        class_2499 list = new class_2499();
        for (StarOwnership entry : ownership) {
            entry.writeNbt().ifPresent(arg_0 -> list.add(arg_0));
        }
        stack.method_7948().method_10566("ownership", (class_2520)list);
    }
}

