/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.event;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Event<D, V, R, L extends Listener<D, V>> {
    protected final Map<Object, List<L>> keyedListeners = new HashMap<Object, List<L>>();
    protected final List<L> orderedListeners = new ArrayList<L>();

    public abstract R invoke(D var1);

    protected void subscribe(L listener) {
        this.subscribe(null, listener);
    }

    protected void subscribe(Object reference, L listener) {
        this.keyedListeners.computeIfAbsent(reference, key -> new ArrayList()).add(listener);
        this.orderedListeners.add(listener);
        this.orderedListeners.sort(Comparator.comparingInt(Listener::getOrder));
    }

    protected void unsubscribe(Object reference) {
        List<L> listeners = this.keyedListeners.remove(reference);
        if (listeners == null) {
            return;
        }
        listeners.forEach(this.orderedListeners::remove);
        this.orderedListeners.sort(Comparator.comparingInt(Listener::getOrder));
    }

    protected static abstract class Listener<K, V> {
        private final int order;

        public Listener() {
            this(0);
        }

        public Listener(int order) {
            this.order = order;
        }

        public int getOrder() {
            return this.order;
        }

        public abstract V invoke(K var1);
    }
}

