/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.event;

import abeshutt.staracademy.event.ConsumerEvent;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.api.reactive.ObservableSubscription;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Unit;

public class CobblemonEvent<T>
extends ConsumerEvent<Payload<T>, Listener<T>> {
    private final Observable<T> source;
    private final List<ObservableSubscription<T>> listeners;

    public CobblemonEvent(Observable<T> source) {
        this.source = source;
        this.listeners = new ArrayList<ObservableSubscription<T>>();
        for (Priority priority : Priority.values()) {
            this.listeners.add(this.source.subscribe(priority, event -> {
                this.invoke(new Payload<Object>(event, priority));
                return Unit.INSTANCE;
            }));
        }
    }

    public void subscribe(Priority priority, Consumer<T> listener) {
        this.subscribe(new Listener<T>(listener, priority));
    }

    public void subscribe(int order, Priority priority, Consumer<T> listener) {
        this.subscribe(new Listener<T>(order, listener, priority));
    }

    public void subscribe(Object reference, Priority priority, Consumer<T> listener) {
        this.subscribe(reference, new Listener<T>(listener, priority));
    }

    public void subscribe(Object reference, int order, Priority priority, Consumer<T> listener) {
        this.subscribe(reference, new Listener<T>(order, listener, priority));
    }

    @Override
    public void unsubscribe(Object reference) {
        super.unsubscribe(reference);
    }

    public void dispose() {
        this.listeners.forEach(arg_0 -> this.source.unsubscribe(arg_0));
    }

    protected static class Listener<T>
    extends ConsumerEvent.Listener<Payload<T>> {
        private final Priority priority;

        public Listener(Consumer<T> function, Priority priority) {
            super(payload -> function.accept(payload.getData()));
            this.priority = priority;
        }

        public Listener(int order, Consumer<T> function, Priority priority) {
            super(order, (D payload) -> function.accept(payload.getData()));
            this.priority = priority;
        }

        @Override
        public Void invoke(Payload<T> data) {
            if (data.getPriority() == this.priority) {
                return super.invoke(data);
            }
            return null;
        }
    }

    protected static class Payload<T> {
        private final T data;
        private final Priority priority;

        public Payload(T data, Priority priority) {
            this.data = data;
            this.priority = priority;
        }

        public T getData() {
            return this.data;
        }

        public Priority getPriority() {
            return this.priority;
        }
    }
}

