/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.entity.renderer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1007;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_898;
import net.minecraft.class_918;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class HumanHeldItemRenderer {
    private static final class_1921 MAP_BACKGROUND = class_1921.method_23028((class_2960)new class_2960("textures/map/map_background.png"));
    private static final class_1921 MAP_BACKGROUND_CHECKERBOARD = class_1921.method_23028((class_2960)new class_2960("textures/map/map_background_checkerboard.png"));
    private final class_310 client;
    private class_1799 mainHand = class_1799.field_8037;
    private class_1799 offHand = class_1799.field_8037;
    private float equipProgressMainHand;
    private float prevEquipProgressMainHand;
    private float equipProgressOffHand;
    private float prevEquipProgressOffHand;
    private final class_898 entityRenderDispatcher;
    private final class_918 itemRenderer;

    public HumanHeldItemRenderer(class_310 client, class_898 entityRenderDispatcher, class_918 itemRenderer) {
        this.client = client;
        this.entityRenderDispatcher = entityRenderDispatcher;
        this.itemRenderer = itemRenderer;
    }

    public void renderItem(class_1309 entity, class_1799 stack, class_811 renderMode, boolean leftHanded, class_4587 matrices, class_4597 vertexConsumers, int light) {
        if (!stack.method_7960()) {
            this.itemRenderer.method_23177(entity, stack, renderMode, leftHanded, matrices, vertexConsumers, entity.method_37908(), light, class_4608.field_21444, entity.method_5628() + renderMode.ordinal());
        }
    }

    private float getMapAngle(float tickDelta) {
        float f = 1.0f - tickDelta / 45.0f + 0.1f;
        f = class_3532.method_15363((float)f, (float)0.0f, (float)1.0f);
        return -class_3532.method_15362((float)(f * (float)Math.PI)) * 0.5f + 0.5f;
    }

    private void renderArm(class_4587 matrices, class_4597 vertexConsumers, int light, class_1306 arm) {
        RenderSystem.setShaderTexture((int)0, (class_2960)this.client.field_1724.method_3117());
        Object playerEntityRenderer = null;
        matrices.method_22903();
        float f = arm == class_1306.field_6183 ? 1.0f : -1.0f;
        matrices.method_22907(class_7833.field_40716.rotationDegrees(92.0f));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(45.0f));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(f * -41.0f));
        matrices.method_46416(f * 0.3f, -1.1f, 0.45f);
        matrices.method_22909();
    }

    private void renderMapInOneHand(class_4587 matrices, class_4597 vertexConsumers, int light, float equipProgress, class_1306 arm, float swingProgress, class_1799 stack) {
        float f = arm == class_1306.field_6183 ? 1.0f : -1.0f;
        matrices.method_46416(f * 0.125f, -0.125f, 0.0f);
        if (!this.client.field_1724.method_5767()) {
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40718.rotationDegrees(f * 10.0f));
            this.renderArmHoldingItem(matrices, vertexConsumers, light, equipProgress, swingProgress, arm);
            matrices.method_22909();
        }
        matrices.method_22903();
        matrices.method_46416(f * 0.51f, -0.08f + equipProgress * -1.2f, -0.75f);
        float g = class_3532.method_15355((float)swingProgress);
        float h = class_3532.method_15374((float)(g * (float)Math.PI));
        float i = -0.5f * h;
        float j = 0.4f * class_3532.method_15374((float)(g * ((float)Math.PI * 2)));
        float k = -0.3f * class_3532.method_15374((float)(swingProgress * (float)Math.PI));
        matrices.method_46416(f * i, j - 0.3f * h, k);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(h * -45.0f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(f * h * -30.0f));
        this.renderFirstPersonMap(matrices, vertexConsumers, light, stack);
        matrices.method_22909();
    }

    private void renderMapInBothHands(class_4587 matrices, class_4597 vertexConsumers, int light, float pitch, float equipProgress, float swingProgress) {
        float f = class_3532.method_15355((float)swingProgress);
        float g = -0.2f * class_3532.method_15374((float)(swingProgress * (float)Math.PI));
        float h = -0.4f * class_3532.method_15374((float)(f * (float)Math.PI));
        matrices.method_46416(0.0f, -g / 2.0f, h);
        float i = this.getMapAngle(pitch);
        matrices.method_46416(0.0f, 0.04f + equipProgress * -1.2f + i * -0.5f, -0.72f);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(i * -85.0f));
        if (!this.client.field_1724.method_5767()) {
            matrices.method_22903();
            matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
            this.renderArm(matrices, vertexConsumers, light, class_1306.field_6183);
            this.renderArm(matrices, vertexConsumers, light, class_1306.field_6182);
            matrices.method_22909();
        }
        float j = class_3532.method_15374((float)(f * (float)Math.PI));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(j * 20.0f));
        matrices.method_22905(2.0f, 2.0f, 2.0f);
        this.renderFirstPersonMap(matrices, vertexConsumers, light, this.mainHand);
    }

    private void renderFirstPersonMap(class_4587 matrices, class_4597 vertexConsumers, int swingProgress, class_1799 stack) {
        matrices.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(180.0f));
        matrices.method_22905(0.38f, 0.38f, 0.38f);
        matrices.method_46416(-0.5f, -0.5f, 0.0f);
        matrices.method_22905(0.0078125f, 0.0078125f, 0.0078125f);
        Integer integer = class_1806.method_8003((class_1799)stack);
        class_22 mapState = class_1806.method_7997((Integer)integer, (class_1937)this.client.field_1687);
        class_4588 vertexConsumer = vertexConsumers.getBuffer(mapState == null ? MAP_BACKGROUND : MAP_BACKGROUND_CHECKERBOARD);
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        vertexConsumer.method_22918(matrix4f, -7.0f, 135.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22916(swingProgress).method_1344();
        vertexConsumer.method_22918(matrix4f, 135.0f, 135.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22916(swingProgress).method_1344();
        vertexConsumer.method_22918(matrix4f, 135.0f, -7.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22916(swingProgress).method_1344();
        vertexConsumer.method_22918(matrix4f, -7.0f, -7.0f, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22916(swingProgress).method_1344();
        if (mapState != null) {
            this.client.field_1773.method_3194().method_1773(matrices, vertexConsumers, integer.intValue(), mapState, false, swingProgress);
        }
    }

    private void renderArmHoldingItem(class_4587 matrices, class_4597 vertexConsumers, int light, float equipProgress, float swingProgress, class_1306 arm) {
        boolean bl = arm != class_1306.field_6182;
        float f = bl ? 1.0f : -1.0f;
        float g = class_3532.method_15355((float)swingProgress);
        float h = -0.3f * class_3532.method_15374((float)(g * (float)Math.PI));
        float i = 0.4f * class_3532.method_15374((float)(g * ((float)Math.PI * 2)));
        float j = -0.4f * class_3532.method_15374((float)(swingProgress * (float)Math.PI));
        matrices.method_46416(f * (h + 0.64000005f), i + -0.6f + equipProgress * -0.6f, j + -0.71999997f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees(f * 45.0f));
        float k = class_3532.method_15374((float)(swingProgress * swingProgress * (float)Math.PI));
        float l = class_3532.method_15374((float)(g * (float)Math.PI));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(f * l * 70.0f));
        matrices.method_22907(class_7833.field_40718.rotationDegrees(f * k * -20.0f));
        class_746 abstractClientPlayerEntity = this.client.field_1724;
        RenderSystem.setShaderTexture((int)0, (class_2960)abstractClientPlayerEntity.method_3117());
        matrices.method_46416(f * -1.0f, 3.6f, 3.5f);
        matrices.method_22907(class_7833.field_40718.rotationDegrees(f * 120.0f));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(200.0f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees(f * -135.0f));
        matrices.method_46416(f * 5.6f, 0.0f, 0.0f);
        class_1007 playerEntityRenderer = (class_1007)this.entityRenderDispatcher.method_3953((class_1297)abstractClientPlayerEntity);
        if (bl) {
            playerEntityRenderer.method_4220(matrices, vertexConsumers, light, (class_742)abstractClientPlayerEntity);
        } else {
            playerEntityRenderer.method_4221(matrices, vertexConsumers, light, (class_742)abstractClientPlayerEntity);
        }
    }

    private void applyEatOrDrinkTransformation(class_4587 matrices, float tickDelta, class_1306 arm, class_1799 stack) {
        float h;
        float f = (float)this.client.field_1724.method_6014() - tickDelta + 1.0f;
        float g = f / (float)stack.method_7935();
        if (g < 0.8f) {
            h = class_3532.method_15379((float)(class_3532.method_15362((float)(f / 4.0f * (float)Math.PI)) * 0.1f));
            matrices.method_46416(0.0f, h, 0.0f);
        }
        h = 1.0f - (float)Math.pow(g, 27.0);
        int i = arm == class_1306.field_6183 ? 1 : -1;
        matrices.method_46416(h * 0.6f * (float)i, h * -0.5f, h * 0.0f);
        matrices.method_22907(class_7833.field_40716.rotationDegrees((float)i * h * 90.0f));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(h * 10.0f));
        matrices.method_22907(class_7833.field_40718.rotationDegrees((float)i * h * 30.0f));
    }

    private void applyBrushTransformation(class_4587 matrices, float tickDelta, class_1306 arm, class_1799 stack, float equipProgress) {
        this.applyEquipOffset(matrices, arm, equipProgress);
        float f = this.client.field_1724.method_6014() % 10;
        float g = f - tickDelta + 1.0f;
        float h = 1.0f - g / 10.0f;
        float i = -90.0f;
        float j = 60.0f;
        float k = 150.0f;
        float l = -15.0f;
        int m = 2;
        float n = -15.0f + 75.0f * class_3532.method_15362((float)(h * 2.0f * (float)Math.PI));
        if (arm != class_1306.field_6183) {
            matrices.method_22904(0.1, 0.83, 0.35);
            matrices.method_22907(class_7833.field_40714.rotationDegrees(-80.0f));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
            matrices.method_22907(class_7833.field_40714.rotationDegrees(n));
            matrices.method_22904(-0.3, 0.22, 0.35);
        } else {
            matrices.method_22904(-0.25, 0.22, 0.35);
            matrices.method_22907(class_7833.field_40714.rotationDegrees(-80.0f));
            matrices.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
            matrices.method_22907(class_7833.field_40718.rotationDegrees(0.0f));
            matrices.method_22907(class_7833.field_40714.rotationDegrees(n));
        }
    }

    private void applySwingOffset(class_4587 matrices, class_1306 arm, float swingProgress) {
        int i = arm == class_1306.field_6183 ? 1 : -1;
        float f = class_3532.method_15374((float)(swingProgress * swingProgress * (float)Math.PI));
        matrices.method_22907(class_7833.field_40716.rotationDegrees((float)i * (45.0f + f * -20.0f)));
        float g = class_3532.method_15374((float)(class_3532.method_15355((float)swingProgress) * (float)Math.PI));
        matrices.method_22907(class_7833.field_40718.rotationDegrees((float)i * g * -20.0f));
        matrices.method_22907(class_7833.field_40714.rotationDegrees(g * -80.0f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees((float)i * -45.0f));
    }

    private void applyEquipOffset(class_4587 matrices, class_1306 arm, float equipProgress) {
        int i = arm == class_1306.field_6183 ? 1 : -1;
        matrices.method_46416((float)i * 0.56f, -0.52f + equipProgress * -0.6f, -0.72f);
    }

    public void renderItem(float tickDelta, class_4587 matrices, class_4597.class_4598 vertexConsumers, class_746 player, int light) {
        float k;
        float j;
        float f = player.method_6055(tickDelta);
        class_1268 hand = (class_1268)MoreObjects.firstNonNull((Object)player.field_6266, (Object)class_1268.field_5808);
        float g = class_3532.method_16439((float)tickDelta, (float)player.field_6004, (float)player.method_36455());
        HandRenderType handRenderType = HumanHeldItemRenderer.getHandRenderType(player);
        float h = class_3532.method_16439((float)tickDelta, (float)player.field_3914, (float)player.field_3916);
        float i = class_3532.method_16439((float)tickDelta, (float)player.field_3931, (float)player.field_3932);
        matrices.method_22907(class_7833.field_40714.rotationDegrees((player.method_5695(tickDelta) - h) * 0.1f));
        matrices.method_22907(class_7833.field_40716.rotationDegrees((player.method_5705(tickDelta) - i) * 0.1f));
        if (handRenderType.renderMainHand) {
            j = hand == class_1268.field_5808 ? f : 0.0f;
            k = 1.0f - class_3532.method_16439((float)tickDelta, (float)this.prevEquipProgressMainHand, (float)this.equipProgressMainHand);
            this.renderFirstPersonItem((class_742)player, tickDelta, g, class_1268.field_5808, j, this.mainHand, k, matrices, (class_4597)vertexConsumers, light);
        }
        if (handRenderType.renderOffHand) {
            j = hand == class_1268.field_5810 ? f : 0.0f;
            k = 1.0f - class_3532.method_16439((float)tickDelta, (float)this.prevEquipProgressOffHand, (float)this.equipProgressOffHand);
            this.renderFirstPersonItem((class_742)player, tickDelta, g, class_1268.field_5810, j, this.offHand, k, matrices, (class_4597)vertexConsumers, light);
        }
        vertexConsumers.method_22993();
    }

    @VisibleForTesting
    static HandRenderType getHandRenderType(class_746 player) {
        boolean bl2;
        class_1799 itemStack = player.method_6047();
        class_1799 itemStack2 = player.method_6079();
        boolean bl = itemStack.method_31574(class_1802.field_8102) || itemStack2.method_31574(class_1802.field_8102);
        boolean bl3 = bl2 = itemStack.method_31574(class_1802.field_8399) || itemStack2.method_31574(class_1802.field_8399);
        if (!bl && !bl2) {
            return HandRenderType.RENDER_BOTH_HANDS;
        }
        if (player.method_6115()) {
            return HumanHeldItemRenderer.getUsingItemHandRenderType(player);
        }
        return HumanHeldItemRenderer.isChargedCrossbow(itemStack) ? HandRenderType.RENDER_MAIN_HAND_ONLY : HandRenderType.RENDER_BOTH_HANDS;
    }

    private static HandRenderType getUsingItemHandRenderType(class_746 player) {
        class_1799 itemStack = player.method_6030();
        class_1268 hand = player.method_6058();
        if (!itemStack.method_31574(class_1802.field_8102) && !itemStack.method_31574(class_1802.field_8399)) {
            return hand == class_1268.field_5808 && HumanHeldItemRenderer.isChargedCrossbow(player.method_6079()) ? HandRenderType.RENDER_MAIN_HAND_ONLY : HandRenderType.RENDER_BOTH_HANDS;
        }
        return HandRenderType.shouldOnlyRender(hand);
    }

    private static boolean isChargedCrossbow(class_1799 stack) {
        return stack.method_31574(class_1802.field_8399) && class_1764.method_7781((class_1799)stack);
    }

    private void renderFirstPersonItem(class_742 player, float tickDelta, float pitch, class_1268 hand, float swingProgress, class_1799 item, float equipProgress, class_4587 matrices, class_4597 vertexConsumers, int light) {
        if (!player.method_31550()) {
            boolean bl = hand == class_1268.field_5808;
            class_1306 arm = bl ? player.method_6068() : player.method_6068().method_5928();
            matrices.method_22903();
            if (item.method_7960()) {
                if (bl && !player.method_5767()) {
                    this.renderArmHoldingItem(matrices, vertexConsumers, light, equipProgress, swingProgress, arm);
                }
            } else if (item.method_31574(class_1802.field_8204)) {
                if (bl && this.offHand.method_7960()) {
                    this.renderMapInBothHands(matrices, vertexConsumers, light, pitch, equipProgress, swingProgress);
                } else {
                    this.renderMapInOneHand(matrices, vertexConsumers, light, equipProgress, arm, swingProgress, item);
                }
            } else if (item.method_31574(class_1802.field_8399)) {
                int i;
                boolean bl2 = class_1764.method_7781((class_1799)item);
                boolean bl3 = arm == class_1306.field_6183;
                int n = i = bl3 ? 1 : -1;
                if (player.method_6115() && player.method_6014() > 0 && player.method_6058() == hand) {
                    this.applyEquipOffset(matrices, arm, equipProgress);
                    matrices.method_46416((float)i * -0.4785682f, -0.094387f, 0.05731531f);
                    matrices.method_22907(class_7833.field_40714.rotationDegrees(-11.935f));
                    matrices.method_22907(class_7833.field_40716.rotationDegrees((float)i * 65.3f));
                    matrices.method_22907(class_7833.field_40718.rotationDegrees((float)i * -9.785f));
                    float f = (float)item.method_7935() - ((float)this.client.field_1724.method_6014() - tickDelta + 1.0f);
                    float g = f / (float)class_1764.method_7775((class_1799)item);
                    if (g > 1.0f) {
                        g = 1.0f;
                    }
                    if (g > 0.1f) {
                        float h = class_3532.method_15374((float)((f - 0.1f) * 1.3f));
                        float j = g - 0.1f;
                        float k = h * j;
                        matrices.method_46416(k * 0.0f, k * 0.004f, k * 0.0f);
                    }
                    matrices.method_46416(g * 0.0f, g * 0.0f, g * 0.04f);
                    matrices.method_22905(1.0f, 1.0f, 1.0f + g * 0.2f);
                    matrices.method_22907(class_7833.field_40715.rotationDegrees((float)i * 45.0f));
                } else {
                    float fx = -0.4f * class_3532.method_15374((float)(class_3532.method_15355((float)swingProgress) * (float)Math.PI));
                    float gx = 0.2f * class_3532.method_15374((float)(class_3532.method_15355((float)swingProgress) * ((float)Math.PI * 2)));
                    float h = -0.2f * class_3532.method_15374((float)(swingProgress * (float)Math.PI));
                    matrices.method_46416((float)i * fx, gx, h);
                    this.applyEquipOffset(matrices, arm, equipProgress);
                    this.applySwingOffset(matrices, arm, swingProgress);
                    if (bl2 && swingProgress < 0.001f && bl) {
                        matrices.method_46416((float)i * -0.641864f, 0.0f, 0.0f);
                        matrices.method_22907(class_7833.field_40716.rotationDegrees((float)i * 10.0f));
                    }
                }
                this.renderItem((class_1309)player, item, bl3 ? class_811.field_4322 : class_811.field_4321, !bl3, matrices, vertexConsumers, light);
            } else {
                boolean bl2;
                boolean bl3 = bl2 = arm == class_1306.field_6183;
                if (player.method_6115() && player.method_6014() > 0 && player.method_6058() == hand) {
                    int l = bl2 ? 1 : -1;
                    switch (item.method_7976()) {
                        case field_8952: {
                            this.applyEquipOffset(matrices, arm, equipProgress);
                            break;
                        }
                        case field_8950: 
                        case field_8946: {
                            this.applyEatOrDrinkTransformation(matrices, tickDelta, arm, item);
                            this.applyEquipOffset(matrices, arm, equipProgress);
                            break;
                        }
                        case field_8949: {
                            this.applyEquipOffset(matrices, arm, equipProgress);
                            break;
                        }
                        case field_8953: {
                            this.applyEquipOffset(matrices, arm, equipProgress);
                            matrices.method_46416((float)l * -0.2785682f, 0.18344387f, 0.15731531f);
                            matrices.method_22907(class_7833.field_40714.rotationDegrees(-13.935f));
                            matrices.method_22907(class_7833.field_40716.rotationDegrees((float)l * 35.3f));
                            matrices.method_22907(class_7833.field_40718.rotationDegrees((float)l * -9.785f));
                            float mx = (float)item.method_7935() - ((float)this.client.field_1724.method_6014() - tickDelta + 1.0f);
                            float fxx = mx / 20.0f;
                            fxx = (fxx * fxx + fxx * 2.0f) / 3.0f;
                            if (fxx > 1.0f) {
                                fxx = 1.0f;
                            }
                            if (fxx > 0.1f) {
                                float gx = class_3532.method_15374((float)((mx - 0.1f) * 1.3f));
                                float h = fxx - 0.1f;
                                float j = gx * h;
                                matrices.method_46416(j * 0.0f, j * 0.004f, j * 0.0f);
                            }
                            matrices.method_46416(fxx * 0.0f, fxx * 0.0f, fxx * 0.04f);
                            matrices.method_22905(1.0f, 1.0f, 1.0f + fxx * 0.2f);
                            matrices.method_22907(class_7833.field_40715.rotationDegrees((float)l * 45.0f));
                            break;
                        }
                        case field_8951: {
                            this.applyEquipOffset(matrices, arm, equipProgress);
                            matrices.method_46416((float)l * -0.5f, 0.7f, 0.1f);
                            matrices.method_22907(class_7833.field_40714.rotationDegrees(-55.0f));
                            matrices.method_22907(class_7833.field_40716.rotationDegrees((float)l * 35.3f));
                            matrices.method_22907(class_7833.field_40718.rotationDegrees((float)l * -9.785f));
                            float m = (float)item.method_7935() - ((float)this.client.field_1724.method_6014() - tickDelta + 1.0f);
                            float fx = m / 10.0f;
                            if (fx > 1.0f) {
                                fx = 1.0f;
                            }
                            if (fx > 0.1f) {
                                float gx = class_3532.method_15374((float)((m - 0.1f) * 1.3f));
                                float h = fx - 0.1f;
                                float j = gx * h;
                                matrices.method_46416(j * 0.0f, j * 0.004f, j * 0.0f);
                            }
                            matrices.method_46416(0.0f, 0.0f, fx * 0.2f);
                            matrices.method_22905(1.0f, 1.0f, 1.0f + fx * 0.2f);
                            matrices.method_22907(class_7833.field_40715.rotationDegrees((float)l * 45.0f));
                            break;
                        }
                        case field_42717: {
                            this.applyBrushTransformation(matrices, tickDelta, arm, item, equipProgress);
                        }
                    }
                } else if (player.method_6123()) {
                    this.applyEquipOffset(matrices, arm, equipProgress);
                    int l = bl2 ? 1 : -1;
                    matrices.method_46416((float)l * -0.4f, 0.8f, 0.3f);
                    matrices.method_22907(class_7833.field_40716.rotationDegrees((float)l * 65.0f));
                    matrices.method_22907(class_7833.field_40718.rotationDegrees((float)l * -85.0f));
                } else {
                    float n = -0.4f * class_3532.method_15374((float)(class_3532.method_15355((float)swingProgress) * (float)Math.PI));
                    float mxx = 0.2f * class_3532.method_15374((float)(class_3532.method_15355((float)swingProgress) * ((float)Math.PI * 2)));
                    float fxxx = -0.2f * class_3532.method_15374((float)(swingProgress * (float)Math.PI));
                    int o = bl2 ? 1 : -1;
                    matrices.method_46416((float)o * n, mxx, fxxx);
                    this.applyEquipOffset(matrices, arm, equipProgress);
                    this.applySwingOffset(matrices, arm, swingProgress);
                }
                this.renderItem((class_1309)player, item, bl2 ? class_811.field_4322 : class_811.field_4321, !bl2, matrices, vertexConsumers, light);
            }
            matrices.method_22909();
        }
    }

    public void updateHeldItems() {
        this.prevEquipProgressMainHand = this.equipProgressMainHand;
        this.prevEquipProgressOffHand = this.equipProgressOffHand;
        class_746 clientPlayerEntity = this.client.field_1724;
        class_1799 itemStack = clientPlayerEntity.method_6047();
        class_1799 itemStack2 = clientPlayerEntity.method_6079();
        if (class_1799.method_7973((class_1799)this.mainHand, (class_1799)itemStack)) {
            this.mainHand = itemStack;
        }
        if (class_1799.method_7973((class_1799)this.offHand, (class_1799)itemStack2)) {
            this.offHand = itemStack2;
        }
        if (clientPlayerEntity.method_3144()) {
            this.equipProgressMainHand = class_3532.method_15363((float)(this.equipProgressMainHand - 0.4f), (float)0.0f, (float)1.0f);
            this.equipProgressOffHand = class_3532.method_15363((float)(this.equipProgressOffHand - 0.4f), (float)0.0f, (float)1.0f);
        } else {
            float f = clientPlayerEntity.method_7261(1.0f);
            this.equipProgressMainHand += class_3532.method_15363((float)((this.mainHand == itemStack ? f * f * f : 0.0f) - this.equipProgressMainHand), (float)-0.4f, (float)0.4f);
            this.equipProgressOffHand += class_3532.method_15363((float)((float)(this.offHand == itemStack2 ? 1 : 0) - this.equipProgressOffHand), (float)-0.4f, (float)0.4f);
        }
        if (this.equipProgressMainHand < 0.1f) {
            this.mainHand = itemStack;
        }
        if (this.equipProgressOffHand < 0.1f) {
            this.offHand = itemStack2;
        }
    }

    public void resetEquipProgress(class_1268 hand) {
        if (hand == class_1268.field_5808) {
            this.equipProgressMainHand = 0.0f;
        } else {
            this.equipProgressOffHand = 0.0f;
        }
    }

    @Environment(value=EnvType.CLIENT)
    @VisibleForTesting
    static enum HandRenderType {
        RENDER_BOTH_HANDS(true, true),
        RENDER_MAIN_HAND_ONLY(true, false),
        RENDER_OFF_HAND_ONLY(false, true);

        final boolean renderMainHand;
        final boolean renderOffHand;

        private HandRenderType(boolean renderMainHand, boolean renderOffHand) {
            this.renderMainHand = renderMainHand;
            this.renderOffHand = renderOffHand;
        }

        public static HandRenderType shouldOnlyRender(class_1268 hand) {
            return hand == class_1268.field_5808 ? RENDER_MAIN_HAND_ONLY : RENDER_OFF_HAND_ONLY;
        }
    }
}

