/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.entity;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.serializable.INbtSerializable;
import abeshutt.staracademy.entity.PartnerNPCEntity;
import abeshutt.staracademy.init.ModWorldData;
import abeshutt.staracademy.util.TextUtils;
import abeshutt.staracademy.world.data.PartnerData;
import abeshutt.staracademy.world.random.JavaRandom;
import abeshutt.staracademy.world.random.RandomSource;
import com.cobblemon.mod.common.api.events.pokemon.PokemonSentPostEvent;
import com.cobblemon.mod.common.pokemon.Species;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class PartnerNPCConversation
implements INbtSerializable<class_2487> {
    public static final Function<RandomSource, String> INITIAL_GREETING = PartnerNPCConversation.create("Ah, a new trainer! Welcome to the academy, ${player}. I\u2019m ${npc}. How wonderful to see a new fresh, eager face!");
    public static final Function<RandomSource, String> SUBSEQUENT_GREETING = PartnerNPCConversation.create("Hello, ${player}!");
    public static final Function<RandomSource, String> PROMPT_ACTIONS = PartnerNPCConversation.create("How can I help you?");
    public static final Function<RandomSource, String> PARTNER_SUMMON = PartnerNPCConversation.create("Please summon the Pokemon you wish to partner with by throwing it on the ground.", "To set your partner, simply call out your chosen Pokemon and place it here.");
    public static final Function<RandomSource, String> PARTNER_SUMMON_EXPLANATION = PartnerNPCConversation.create("Once summoned, I'll ensure it's exclusively yours for battles.", "Once summoned, it becomes your trusted ally, unavailable for others to use in battles.");
    public static final Function<RandomSource, String> PARTNER_SUMMON_CONFIRMATION = PartnerNPCConversation.create("Are you certain you want to select ${pokemon} as your partner?", "You've chosen ${pokemon}! Would you like to confirm it as your partner?", "Do you want to make ${pokemon} your official partner?", "You've selected ${pokemon} as your partner\u2014do you want to proceed with this choice?");
    public static final Function<RandomSource, String> PARTNER_SUMMON_SUCCESS = PartnerNPCConversation.create("Excellent choice! ${pokemon} will be your steadfast companion. Together, you'll make an unstoppable team!", "An intriguing selection. ${pokemon} possesses unique abilities that will aid your research.", "Excellent choice! ${pokemon} does align well with the Academy's standards.", "Your partnership with ${pokemon} is now official. May your bond lead you to remarkable discoveries and victories.");
    public static final Function<RandomSource, String> PARTNER_SUMMON_ALREADY_SET = PartnerNPCConversation.create("It looks like you've already chosen ${pokemon} as your partner.");
    private final UUID uuid;
    private Phase phase;
    private boolean initial;
    private Species selectedSpecies;

    public PartnerNPCConversation(UUID uuid) {
        this.uuid = uuid;
        this.phase = Phase.NONE;
        this.initial = true;
    }

    public void onTick(class_3222 player, PartnerNPCEntity npc) {
        PartnerData data = ModWorldData.PARTNER.getGlobal(player.method_37908());
        if (this.phase == Phase.AWAIT_PARTNER_SUMMON && data.getSelection(this.uuid).isPresent()) {
            this.phase = Phase.GREETING;
        }
        if ((double)player.method_5739((class_1297)npc) > 16.0) {
            this.phase = Phase.NONE;
        }
    }

    public void onPokemonSent(class_3222 player, PartnerNPCEntity npc, PokemonSentPostEvent event) {
        if (this.phase != Phase.AWAIT_PARTNER_SUMMON) {
            return;
        }
        this.selectedSpecies = event.getPokemon().getSpecies();
        JavaRandom random = JavaRandom.ofNanoTime();
        class_5250 text = class_2561.method_43473();
        text = text.method_10852((class_2561)class_2561.method_43470((String)PARTNER_SUMMON_CONFIRMATION.apply(random)).method_27692(class_124.field_1080));
        text = this.format(text, player, null, this.selectedSpecies);
        text = text.method_27693(" ");
        text = text.method_10852((class_2561)class_2561.method_43470((String)"[Yes]").method_27692(class_124.field_1060).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/academy partner " + npc.method_5667() + " confirm_partner_selection"))));
        player.method_7353((class_2561)text, false);
    }

    public void onInteract(class_3222 player, PartnerNPCEntity npc) {
        JavaRandom random = JavaRandom.ofNanoTime();
        if (this.phase == Phase.NONE) {
            class_5250 text = class_2561.method_43473();
            text = text.method_10852((class_2561)class_2561.method_43470((String)(this.initial ? INITIAL_GREETING : SUBSEQUENT_GREETING).apply(random)).method_27692(class_124.field_1080));
            text = text.method_27693(" ");
            text = text.method_10852((class_2561)class_2561.method_43470((String)PROMPT_ACTIONS.apply(random)).method_27692(class_124.field_1080));
            text = this.format(text, player, npc, null);
            text = text.method_27693(" ");
            text = text.method_10852((class_2561)class_2561.method_43470((String)"[Select Partner]").method_27692(class_124.field_1075).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/academy partner " + npc.method_5667() + " select_partner"))));
            player.method_7353((class_2561)text, false);
            this.phase = Phase.GREETING;
            this.initial = false;
        } else if (this.phase == Phase.GREETING) {
            class_5250 text = class_2561.method_43473();
            text = text.method_10852((class_2561)class_2561.method_43470((String)PROMPT_ACTIONS.apply(random)).method_27692(class_124.field_1080));
            text = this.format(text, player, npc, null);
            text = text.method_27693(" ");
            text = text.method_10852((class_2561)class_2561.method_43470((String)"[Select Partner]").method_27692(class_124.field_1075).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/academy partner " + npc.method_5667() + " select_partner"))));
            player.method_7353((class_2561)text, false);
        } else if (this.phase == Phase.AWAIT_PARTNER_SUMMON) {
            class_5250 text = class_2561.method_43473();
            text = text.method_10852((class_2561)class_2561.method_43470((String)PARTNER_SUMMON.apply(random)).method_27692(class_124.field_1080));
            text = this.format(text, player, npc, null);
            player.method_7353((class_2561)text, false);
        }
    }

    public void onSelectPartner(class_3222 player, PartnerNPCEntity npc) {
        JavaRandom random = JavaRandom.ofNanoTime();
        class_5250 text = null;
        PartnerData data = ModWorldData.PARTNER.getGlobal(player.method_37908());
        if (data.getSelection(this.uuid).isPresent()) {
            text = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)PARTNER_SUMMON_ALREADY_SET.apply(random)).method_27692(class_124.field_1080));
        } else if (this.phase == Phase.GREETING) {
            text = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)PARTNER_SUMMON.apply(random)).method_27692(class_124.field_1080)).method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)PARTNER_SUMMON_EXPLANATION.apply(random)).method_27692(class_124.field_1080));
            this.phase = Phase.AWAIT_PARTNER_SUMMON;
        } else if (this.phase == Phase.AWAIT_PARTNER_SUMMON) {
            text = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)PARTNER_SUMMON.apply(random)).method_27692(class_124.field_1080));
        }
        if (text != null) {
            text = this.format(text, player, npc, data.getSelection(this.uuid).orElse(null));
            player.method_7353((class_2561)text, false);
        }
    }

    public void onConfirmPartnerSelection(class_3222 player, PartnerNPCEntity npc) {
        if (this.selectedSpecies == null) {
            return;
        }
        PartnerData data = ModWorldData.PARTNER.getGlobal(player.method_37908());
        if (data.getSelection(player.method_5667()).isPresent()) {
            return;
        }
        JavaRandom random = JavaRandom.ofNanoTime();
        class_5250 text = class_2561.method_43470((String)PARTNER_SUMMON_SUCCESS.apply(random)).method_27692(class_124.field_1080);
        player.method_43496((class_2561)this.format(text, player, npc, this.selectedSpecies));
        data.setAndNotifySelection(player, this.selectedSpecies);
        this.phase = Phase.GREETING;
    }

    public class_5250 format(class_5250 text, class_3222 player, PartnerNPCEntity npc, Species species) {
        class_5250 result = text;
        if (player != null) {
            result = TextUtils.replace((class_2561)result, "${player}", (class_2561)player.method_5477().method_27661().method_27692(class_124.field_1068));
        }
        if (npc != null) {
            result = TextUtils.replace((class_2561)result, "${npc}", (class_2561)npc.method_5477().method_27661().method_27692(class_124.field_1068));
        }
        if (species != null) {
            int color = species.getPrimaryType().getHue();
            result = TextUtils.replace((class_2561)result, "${pokemon}", (class_2561)species.getTranslatedName().method_10862(class_2583.field_24360.method_36139(color)));
        }
        return result;
    }

    public static Function<RandomSource, String> create(String ... lines) {
        return random -> lines[random.nextInt(lines.length)];
    }

    @Override
    public Optional<class_2487> writeNbt() {
        return Optional.of(new class_2487()).map(nbt -> {
            Adapters.BOOLEAN.writeNbt(this.initial).ifPresent(tag -> nbt.method_10566("initial", tag));
            return nbt;
        });
    }

    @Override
    public void readNbt(class_2487 nbt) {
        this.initial = Adapters.BOOLEAN.readNbt(nbt.method_10580("initial")).orElse(true);
    }

    public static enum Phase {
        NONE,
        GREETING,
        AWAIT_PARTNER_SUMMON;

    }
}

