/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.entity;

import abeshutt.staracademy.data.entity.EntityPlacement;
import abeshutt.staracademy.data.nbt.PartialCompoundNbt;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_151;
import net.minecraft.class_1945;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class PartialEntityTag
implements EntityPlacement<PartialEntityTag> {
    private class_2960 id;
    private PartialCompoundNbt nbt;

    public PartialEntityTag(class_2960 id, PartialCompoundNbt nbt) {
        this.id = id;
        this.nbt = nbt;
    }

    public static PartialEntityTag of(class_2960 id, PartialCompoundNbt entity) {
        return new PartialEntityTag(id, entity);
    }

    @Override
    public boolean isSubsetOf(PartialEntityTag other) {
        return (this.id == null || this.id.equals((Object)other.id)) && this.nbt.isSubsetOf(other.nbt);
    }

    @Override
    public boolean isSubsetOf(class_1297 entity) {
        return false;
    }

    @Override
    public void fillInto(PartialEntityTag other) {
        if (this.id != null) {
            other.id = this.id;
        }
        this.nbt.fillInto(other.nbt);
    }

    @Override
    public void place(class_1945 world) {
    }

    @Override
    public boolean test(class_243 pos, class_2338 blockPos, PartialCompoundNbt nbt) {
        if (!this.nbt.isSubsetOf(nbt)) {
            return false;
        }
        class_2960 id = this.nbt.asWhole().filter(tag -> tag.method_10573("id", 8)).map(tag -> class_2960.method_12829((String)tag.method_10558("id"))).orElse(null);
        if (id == null || !class_7923.field_41177.method_10250(id)) {
            return false;
        }
        class_1299 type = (class_1299)class_7923.field_41177.method_10223(id);
        return class_7923.field_41177.method_47983((Object)type).method_40228().anyMatch(tag -> tag.comp_327().equals((Object)this.id));
    }

    @Override
    public PartialEntityTag copy() {
        return new PartialEntityTag(this.id, this.nbt.copy());
    }

    public String toString() {
        return (String)(this.id != null ? "#" + this.id : "") + this.nbt.toString();
    }

    public static Optional<PartialEntityTag> parse(String string, boolean logErrors) {
        try {
            return Optional.of(PartialEntityTag.parse(new StringReader(string)));
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            if (logErrors) {
                e.printStackTrace();
            }
            return Optional.empty();
        }
    }

    public static PartialEntityTag parse(String string) throws CommandSyntaxException {
        return PartialEntityTag.parse(new StringReader(string));
    }

    public static PartialEntityTag parse(StringReader reader) throws CommandSyntaxException {
        if (reader.peek() != '#') {
            throw new IllegalArgumentException("Invalid entity tag '" + reader.getString() + "' does not start with #");
        }
        reader.skip();
        int cursor = reader.getCursor();
        while (reader.canRead() && PartialEntityTag.isCharValid(reader.peek())) {
            reader.skip();
        }
        String string = reader.getString().substring(cursor, reader.getCursor());
        try {
            return PartialEntityTag.of(new class_2960(string), PartialCompoundNbt.parse(reader));
        }
        catch (class_151 e) {
            reader.setCursor(cursor);
            throw new IllegalArgumentException("Invalid tag identifier '" + string + "' in block tag '" + reader.getString() + "'");
        }
    }

    protected static boolean isCharValid(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c == '_' || c == ':' || c == '/' || c == '.' || c == '-';
    }
}

