/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.adapter.number;

import abeshutt.staracademy.data.adapter.ISimpleAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Optional;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public abstract class NumberAdapter<N extends Number>
implements ISimpleAdapter<N, class_2520, JsonElement> {
    private final boolean nullable;

    public NumberAdapter(boolean nullable) {
        this.nullable = nullable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    protected abstract void writeNumberBits(N var1, BitBuffer var2);

    protected abstract N readNumberBits(BitBuffer var1);

    protected abstract void writeNumberBytes(N var1, ByteBuf var2);

    protected abstract N readNumberBytes(ByteBuf var1);

    protected abstract void writeNumberData(N var1, DataOutput var2) throws IOException;

    protected abstract N readNumberData(DataInput var1) throws IOException;

    protected abstract class_2520 writeNumberNbt(N var1);

    protected abstract N readNumberNbt(class_2520 var1);

    protected abstract JsonElement writeNumberJson(N var1);

    protected abstract N readNumberJson(JsonElement var1);

    @Override
    public final void writeBits(N value, BitBuffer buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            this.writeNumberBits(value, buffer);
        }
    }

    @Override
    public final Optional<N> readBits(BitBuffer buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(this.readNumberBits(buffer));
    }

    @Override
    public final void writeBytes(N value, ByteBuf buffer) {
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            this.writeNumberBytes(value, buffer);
        }
    }

    @Override
    public final Optional<N> readBytes(ByteBuf buffer) {
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(this.readNumberBytes(buffer));
    }

    @Override
    public void writeData(N value, DataOutput data) throws IOException {
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            this.writeNumberData(value, data);
        }
    }

    @Override
    public Optional<N> readData(DataInput data) throws IOException {
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        return Optional.of(this.readNumberData(data));
    }

    @Override
    public final Optional<class_2520> writeNbt(N value) {
        return value == null ? Optional.empty() : Optional.ofNullable(this.writeNumberNbt(value));
    }

    @Override
    public final Optional<N> readNbt(class_2520 nbt) {
        return nbt == null ? Optional.empty() : Optional.ofNullable(this.readNumberNbt(nbt));
    }

    @Override
    public final Optional<JsonElement> writeJson(N value) {
        return value == null ? Optional.empty() : Optional.ofNullable(this.writeNumberJson(value));
    }

    @Override
    public final Optional<N> readJson(JsonElement json) {
        return json == null || json instanceof JsonNull ? Optional.empty() : Optional.ofNullable(this.readNumberJson(json));
    }

    public static Optional<Number> parse(String string) {
        try {
            if (string.contains(".") || string.contains("e") || string.contains("E")) {
                return Optional.ofNullable(NumberAdapter.reduce(new BigDecimal(string)));
            }
            return Optional.ofNullable(NumberAdapter.reduce(switch (string.length() < 2 ? "" : string.substring(0, 2)) {
                case "0x" -> new BigInteger(string.substring(2), 16);
                case "0o" -> new BigInteger(string.substring(2), 8);
                case "0b" -> new BigInteger(string.substring(2), 2);
                default -> new BigInteger(string, 10);
            }));
        }
        catch (NumberFormatException exception) {
            return Optional.empty();
        }
    }

    public static Number reduce(Number number) {
        if (number instanceof Byte) {
            return number;
        }
        if (number instanceof Short) {
            if (number.shortValue() == number.byteValue()) {
                return number.byteValue();
            }
            return number;
        }
        if (number instanceof Integer) {
            if (number.intValue() == number.byteValue()) {
                return number.byteValue();
            }
            if (number.intValue() == number.shortValue()) {
                return number.shortValue();
            }
            return number;
        }
        if (number instanceof Float) {
            if (number.floatValue() == (float)number.byteValue()) {
                return number.byteValue();
            }
            if (number.floatValue() == (float)number.shortValue()) {
                return number.shortValue();
            }
            return number;
        }
        if (number instanceof Long) {
            if (number.longValue() == (long)number.byteValue()) {
                return number.byteValue();
            }
            if (number.longValue() == (long)number.shortValue()) {
                return number.shortValue();
            }
            if (number.longValue() == (long)number.intValue()) {
                return number.intValue();
            }
            return number;
        }
        if (number instanceof Double) {
            if (number.doubleValue() == (double)number.byteValue()) {
                return number.byteValue();
            }
            if (number.doubleValue() == (double)number.shortValue()) {
                return number.shortValue();
            }
            if (number.doubleValue() == (double)number.intValue()) {
                return number.intValue();
            }
            if (number.doubleValue() == (double)number.floatValue()) {
                return Float.valueOf(number.floatValue());
            }
            return number;
        }
        if (number instanceof BigInteger) {
            BigInteger integer = (BigInteger)number;
            if (integer.bitLength() <= 63) {
                return NumberAdapter.reduce(integer.longValueExact());
            }
            return number;
        }
        if (number instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)number;
            if (decimal.stripTrailingZeros().scale() <= 0) {
                return NumberAdapter.reduce(decimal.toBigIntegerExact());
            }
            if (BigDecimal.valueOf(decimal.doubleValue()).compareTo(decimal) == 0) {
                return NumberAdapter.reduce(decimal.doubleValue());
            }
            return number;
        }
        return number;
    }

    public static class_2520 wrap(Number number) {
        if (number instanceof Byte) {
            Byte value = (Byte)number;
            return class_2481.method_23233((byte)value);
        }
        if (number instanceof Short) {
            Short value = (Short)number;
            return class_2516.method_23254((short)value);
        }
        if (number instanceof Integer) {
            Integer value = (Integer)number;
            return class_2497.method_23247((int)value);
        }
        if (number instanceof Float) {
            Float value = (Float)number;
            return class_2494.method_23244((float)value.floatValue());
        }
        if (number instanceof Long) {
            Long value = (Long)number;
            return class_2503.method_23251((long)value);
        }
        if (number instanceof Double) {
            Double value = (Double)number;
            return class_2489.method_23241((double)value);
        }
        if (number instanceof BigInteger) {
            BigInteger value = (BigInteger)number;
            return new class_2479(value.toByteArray());
        }
        if (number instanceof BigDecimal) {
            BigDecimal value = (BigDecimal)number;
            return class_2519.method_23256((String)value.toString());
        }
        return null;
    }
}

