/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.adapter.number;

import abeshutt.staracademy.data.adapter.number.IntAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;

public class LegacySegmentedIntAdapter
extends IntAdapter {
    public static final LegacySegmentedIntAdapter _3 = new LegacySegmentedIntAdapter(3, false);
    public static final LegacySegmentedIntAdapter _7 = new LegacySegmentedIntAdapter(7, false);
    private final int bitSegment;
    private final int byteSegment;

    public LegacySegmentedIntAdapter(int segment, boolean nullable) {
        super(nullable);
        this.bitSegment = segment;
        this.byteSegment = segment < 8 ? 1 : (segment < 16 ? 2 : (segment < 24 ? 3 : (segment < 32 ? 4 : 5)));
    }

    public int getBitSegment() {
        return this.bitSegment;
    }

    public int getByteSegment() {
        return this.byteSegment;
    }

    @Override
    public LegacySegmentedIntAdapter asNullable() {
        return new LegacySegmentedIntAdapter(this.bitSegment, true);
    }

    @Override
    protected void writeNumberBits(Integer value, BitBuffer buffer) {
        long bits;
        int segment = this.bitSegment;
        int mask = (1 << segment) - 1;
        while (true) {
            bits = value & mask;
            if ((value = Integer.valueOf(value >>> segment)) == 0) break;
            buffer.writeLongBits(bits, segment + 1);
        }
        buffer.writeLongBits(1L << segment | bits, segment + 1);
    }

    @Override
    protected Integer readNumberBits(BitBuffer buffer) {
        int segment = this.bitSegment;
        int mask = 1 << segment;
        int value = 0;
        int shift = 0;
        while (true) {
            long bits;
            if (((bits = buffer.readLongBits(segment + 1)) & (long)mask) != 0L) {
                value = (int)((long)value | bits - (long)mask << shift);
                return value;
            }
            value = (int)((long)value | bits << shift);
            shift += segment;
        }
    }
}

