/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.data.adapter.array;

import abeshutt.staracademy.data.adapter.Adapters;
import abeshutt.staracademy.data.adapter.IBitAdapter;
import abeshutt.staracademy.data.adapter.IByteAdapter;
import abeshutt.staracademy.data.adapter.IComplexAdapter;
import abeshutt.staracademy.data.adapter.IDataAdapter;
import abeshutt.staracademy.data.adapter.IJsonAdapter;
import abeshutt.staracademy.data.adapter.INbtAdapter;
import abeshutt.staracademy.data.bit.BitBuffer;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class ArrayAdapter<T>
implements IComplexAdapter<T[], class_2520, JsonElement, Object> {
    private final IntFunction<T[]> constructor;
    private final Object elementAdapter;
    private final Supplier<T> defaultValue;
    private final boolean nullable;

    public ArrayAdapter(IntFunction<T[]> constructor, Object elementAdapter, Supplier<T> defaultValue, boolean nullable) {
        this.constructor = constructor;
        this.elementAdapter = elementAdapter;
        this.defaultValue = defaultValue;
        this.nullable = nullable;
    }

    public IntFunction<T[]> getConstructor() {
        return this.constructor;
    }

    public Object getElementAdapter() {
        return this.elementAdapter;
    }

    public Supplier<T> getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public ArrayAdapter<T> asNullable() {
        return new ArrayAdapter<T>(this.constructor, this.elementAdapter, this.defaultValue, true);
    }

    @Override
    public final void writeBits(T[] value, BitBuffer buffer, Object context) {
        T[] TArray = this.elementAdapter;
        if (!(TArray instanceof IBitAdapter)) {
            throw new UnsupportedOperationException();
        }
        IBitAdapter adapter = (IBitAdapter)TArray;
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_3.writeBits(value.length, buffer);
            for (T element : value) {
                adapter.writeBits(element, buffer, context);
            }
        }
    }

    @Override
    public final Optional<T[]> readBits(BitBuffer buffer, Object context) {
        Object object = this.elementAdapter;
        if (!(object instanceof IBitAdapter)) {
            throw new UnsupportedOperationException();
        }
        IBitAdapter adapter = (IBitAdapter)object;
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        T[] value = this.constructor.apply((Integer)Adapters.INT_SEGMENTED_3.readBits(buffer).orElseThrow());
        for (int i = 0; i < value.length; ++i) {
            value[i] = adapter.readBits(buffer, context).orElseGet(this.defaultValue);
        }
        return Optional.of(value);
    }

    @Override
    public final void writeBytes(T[] value, ByteBuf buffer, Object context) {
        T[] TArray = this.elementAdapter;
        if (!(TArray instanceof IByteAdapter)) {
            throw new UnsupportedOperationException();
        }
        IByteAdapter adapter = (IByteAdapter)TArray;
        if (this.nullable) {
            buffer.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_3.writeBytes(value.length, buffer);
            for (T element : value) {
                adapter.writeBytes(element, buffer, context);
            }
        }
    }

    @Override
    public final Optional<T[]> readBytes(ByteBuf buffer, Object context) {
        Object object = this.elementAdapter;
        if (!(object instanceof IByteAdapter)) {
            throw new UnsupportedOperationException();
        }
        IByteAdapter adapter = (IByteAdapter)object;
        if (this.nullable && buffer.readBoolean()) {
            return Optional.empty();
        }
        T[] value = this.constructor.apply((Integer)Adapters.INT_SEGMENTED_3.readBytes(buffer).orElseThrow());
        for (int i = 0; i < value.length; ++i) {
            value[i] = adapter.readBytes(buffer, context).orElseGet(this.defaultValue);
        }
        return Optional.of(value);
    }

    @Override
    public void writeData(T[] value, DataOutput data, Object context) throws IOException {
        T[] TArray = this.elementAdapter;
        if (!(TArray instanceof IDataAdapter)) {
            throw new UnsupportedOperationException();
        }
        IDataAdapter adapter = (IDataAdapter)TArray;
        if (this.nullable) {
            data.writeBoolean(value == null);
        }
        if (value != null) {
            Adapters.INT_SEGMENTED_3.writeData(value.length, data);
            for (T element : value) {
                adapter.writeData(element, data, context);
            }
        }
    }

    @Override
    public Optional<T[]> readData(DataInput data, Object context) throws IOException {
        Object object = this.elementAdapter;
        if (!(object instanceof IDataAdapter)) {
            throw new UnsupportedOperationException();
        }
        IDataAdapter adapter = (IDataAdapter)object;
        if (this.nullable && data.readBoolean()) {
            return Optional.empty();
        }
        T[] value = this.constructor.apply((Integer)Adapters.INT_SEGMENTED_3.readData(data).orElseThrow());
        for (int i = 0; i < value.length; ++i) {
            value[i] = adapter.readData(data, context).orElseGet(this.defaultValue);
        }
        return Optional.of(value);
    }

    @Override
    public final Optional<class_2520> writeNbt(T[] value, Object context) {
        Object object = this.elementAdapter;
        if (!(object instanceof INbtAdapter)) {
            throw new UnsupportedOperationException();
        }
        INbtAdapter adapter = (INbtAdapter)object;
        if (value == null) {
            return Optional.empty();
        }
        class_2499 list = new class_2499();
        for (T element : value) {
            list.add((Object)((class_2520)adapter.writeNbt(element, context).orElseGet(() -> adapter.writeNbt(this.defaultValue.get(), context).orElseThrow())));
        }
        return Optional.of(list);
    }

    @Override
    public final Optional<T[]> readNbt(class_2520 nbt, Object context) {
        Object object = this.elementAdapter;
        if (!(object instanceof INbtAdapter)) {
            throw new UnsupportedOperationException();
        }
        INbtAdapter adapter = (INbtAdapter)object;
        if (!(nbt instanceof class_2499)) {
            return Optional.empty();
        }
        class_2499 list = (class_2499)nbt;
        T[] value = this.constructor.apply(list.size());
        for (int i = 0; i < list.size(); ++i) {
            value[i] = adapter.readNbt(list.method_10534(i), context).orElseGet(this.defaultValue);
        }
        return Optional.of(value);
    }

    @Override
    public final Optional<JsonElement> writeJson(T[] value, Object context) {
        Object object = this.elementAdapter;
        if (!(object instanceof IJsonAdapter)) {
            throw new UnsupportedOperationException();
        }
        IJsonAdapter adapter = (IJsonAdapter)object;
        if (value == null) {
            return Optional.empty();
        }
        JsonArray array = new JsonArray();
        for (T element : value) {
            array.add((JsonElement)adapter.writeJson(element, context).orElseGet(() -> adapter.writeJson(this.defaultValue.get(), context).orElse(null)));
        }
        return Optional.of(array);
    }

    @Override
    public final Optional<T[]> readJson(JsonElement json, Object context) {
        Object object = this.elementAdapter;
        if (!(object instanceof IJsonAdapter)) {
            throw new UnsupportedOperationException();
        }
        IJsonAdapter adapter = (IJsonAdapter)object;
        if (json == null) {
            return Optional.empty();
        }
        if (json instanceof JsonArray) {
            JsonArray array = (JsonArray)json;
            T[] value = this.constructor.apply(array.size());
            for (int i = 0; i < array.size(); ++i) {
                value[i] = adapter.readJson(array.get(i), context).orElseGet(this.defaultValue);
            }
            return Optional.of(value);
        }
        return Optional.empty();
    }
}

