/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.config;

import abeshutt.staracademy.StarAcademyMod;
import abeshutt.staracademy.config.FileConfig;
import abeshutt.staracademy.item.SafariTicketEntry;
import abeshutt.staracademy.world.roll.IntRoll;
import com.google.gson.annotations.Expose;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2960;

public class SafariConfig
extends FileConfig {
    public static final SafariConfig CLIENT = new SafariConfig();
    @Expose
    private long seed;
    @Expose
    private class_2960 structure;
    @Expose
    private class_2338 placementOffset;
    @Expose
    private class_2338 spawnPositionRelative;
    @Expose
    private float spawnYaw;
    @Expose
    private float spawnPitch;
    @Expose
    private long playerDuration;
    @Expose
    private int providedSafariBalls;
    @Expose
    private long startEpoch;
    @Expose
    private long restartDelay;
    @Expose
    private boolean paused;
    @Expose
    private Map<String, SafariTicketEntry> tickets = new HashMap<String, SafariTicketEntry>();

    @Override
    public String getPath() {
        return "safari";
    }

    public long getSeed() {
        return this.seed;
    }

    public class_2960 getStructure() {
        return this.structure;
    }

    public class_2338 getPlacementOffset() {
        return this.placementOffset;
    }

    public class_2338 getRelativeSpawnPosition() {
        return this.spawnPositionRelative;
    }

    public float getSpawnYaw() {
        return this.spawnYaw;
    }

    public float getSpawnPitch() {
        return this.spawnPitch;
    }

    public long getPlayerDuration() {
        return this.playerDuration;
    }

    public int getProvidedSafariBalls() {
        return this.providedSafariBalls;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public long getTimeLeft(long lastUpdated) {
        long refreshes = (lastUpdated - this.startEpoch) / this.restartDelay;
        long nextRefresh = this.startEpoch + (refreshes + 1L) * this.restartDelay;
        return nextRefresh - System.currentTimeMillis();
    }

    public Map<String, SafariTicketEntry> getTickets() {
        return this.tickets;
    }

    public Optional<SafariTicketEntry> getTicket(String id) {
        return Optional.ofNullable(this.tickets.get(id));
    }

    @Override
    protected void reset() {
        this.seed = -4534904328483650727L;
        this.structure = StarAcademyMod.id("safari_spawn");
        this.placementOffset = new class_2338(-431, 87, -303);
        this.spawnPositionRelative = new class_2338(53, 13, 76);
        this.spawnYaw = -90.0f;
        this.spawnPitch = 0.0f;
        this.playerDuration = 36000L;
        this.providedSafariBalls = 16;
        this.startEpoch = 0L;
        this.restartDelay = 86400000L;
        this.paused = false;
        this.tickets = new LinkedHashMap<String, SafariTicketEntry>();
        this.tickets.put("base", new SafariTicketEntry("Safari Ticket", 0xFFFFFF, IntRoll.ofConstant(1200), "academy:safari_ticket/base#inventory"));
        this.tickets.put("great", new SafariTicketEntry("Great Safari Ticket", 11287604, IntRoll.ofConstant(6000), "academy:safari_ticket/great#inventory"));
        this.tickets.put("golden", new SafariTicketEntry("Golden Safari Ticket", 13927452, IntRoll.ofUniform(12000, 24000), "academy:safari_ticket/base#inventory"));
    }
}

