/*
 * Decompiled with CFR 0.152.
 */
package abeshutt.staracademy.command;

import abeshutt.staracademy.StarAcademyMod;
import abeshutt.staracademy.command.Command;
import abeshutt.staracademy.init.ModOutfits;
import abeshutt.staracademy.init.ModWorldData;
import abeshutt.staracademy.outfit.core.OutfitPiece;
import abeshutt.staracademy.world.data.WardrobeData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Set;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class WardrobeCommand
extends Command {
    public static SimpleCommandExceptionType INVALID_OUTFIT_ID = new SimpleCommandExceptionType((Message)StarAcademyMod.translatableText("command.wardrobe.unlock.fail", new Object[0]));
    private static final SuggestionProvider<class_2168> OUTFIT_ID_SUGGESTIONS = (context, builder) -> class_2172.method_9264(ModOutfits.REGISTRY.keySet().stream(), (SuggestionsBuilder)builder);

    @Override
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 access, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"academy").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"wardrobe").requires(source -> source.method_9259(4))).then(class_2170.method_9247((String)"list").executes(this::onListUnlockedOutfits))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"unlock").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.word()).suggests(OUTFIT_ID_SUGGESTIONS).executes(this::onUnlockOutfit))).then(class_2170.method_9247((String)"all").executes(this::onUnlockOutfitAll)))));
    }

    private int onListUnlockedOutfits(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 sender = source.method_9207();
        WardrobeData data = ModWorldData.WARDROBE.getGlobal(sender.method_37908());
        data.get(sender.method_5667()).ifPresentOrElse(wardrobe -> {
            source.method_9226(() -> class_2561.method_43470((String)"== UNLOCKED OUTFITS =="), false);
            Set<String> equipped = wardrobe.getEquipped();
            for (String outfitId : wardrobe.getUnlocked()) {
                source.method_9226(() -> class_2561.method_43470((String)("- " + outfitId + (equipped.contains(outfitId) ? " (equipped)" : ""))), false);
            }
        }, () -> source.method_9226(() -> class_2561.method_43470((String)"No outfit is unlocked"), false));
        return 0;
    }

    private int onUnlockOutfit(CommandContext<class_2168> context) throws CommandSyntaxException {
        String outfitId = StringArgumentType.getString(context, (String)"id");
        class_3222 sender = ((class_2168)context.getSource()).method_9207();
        OutfitPiece outfit = ModOutfits.REGISTRY.get(outfitId);
        if (outfit == null) {
            throw INVALID_OUTFIT_ID.create();
        }
        WardrobeData data = ModWorldData.WARDROBE.getGlobal(sender.method_37908());
        data.setUnlocked(sender, outfitId, true);
        return 0;
    }

    private int onUnlockOutfitAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 sender = ((class_2168)context.getSource()).method_9207();
        for (OutfitPiece outfit : ModOutfits.REGISTRY.values()) {
            if (outfit == null) {
                throw INVALID_OUTFIT_ID.create();
            }
            WardrobeData data = ModWorldData.WARDROBE.getGlobal(sender.method_37908());
            data.setUnlocked(sender, outfit.getId(), true);
        }
        return 0;
    }
}

