/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.upgrades.compression;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.UpgradeSlotChangeResult;
import net.p3pp3rf1y.sophisticatedcore.inventory.IInventoryPartHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryPartRegistry;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryPartitioner;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeCountLimitConfig;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeItemBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeType;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.compacting.CompactingUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RecipeHelper;
import net.p3pp3rf1y.sophisticatedcore.util.SlotRange;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.compression.CompressionInventoryPart;

public class CompressionUpgradeItem
extends UpgradeItemBase<Wrapper> {
    public static final UpgradeType<Wrapper> TYPE = new UpgradeType(Wrapper::new);
    private static final String FIRST_INVENTORY_SLOT_TAG = "firstInventorySlot";
    public static final List<IUpgradeItem.UpgradeConflictDefinition> UPGRADE_CONFLICT_DEFINITIONS = List.of(new IUpgradeItem.UpgradeConflictDefinition(CompactingUpgradeItem.class::isInstance, 0, StorageTranslationHelper.INSTANCE.translError("add.compacting_exists", new Object[0])));

    public CompressionUpgradeItem() {
        super((IUpgradeCountLimitConfig)Config.SERVER.maxUpgradesPerStorage);
        InventoryPartRegistry.registerFactory((String)"compression", CompressionInventoryPart::new);
    }

    public UpgradeType<Wrapper> getType() {
        return TYPE;
    }

    private UpgradeSlotChangeResult checkCompressionSpace(IStorageWrapper storageWrapper) {
        Optional slotRange = storageWrapper.getInventoryHandler().getInventoryPartitioner().getFirstSpace(((Integer)Config.SERVER.compressionUpgrade.maxNumberOfSlots.get()).intValue());
        return slotRange.map(range -> this.canUseForCompression(storageWrapper, (SlotRange)range)).orElseGet(() -> new UpgradeSlotChangeResult.Fail(StorageTranslationHelper.INSTANCE.translError("add.compression_no_space", new Object[0]), Collections.emptySet(), Collections.emptySet(), Collections.emptySet()));
    }

    public UpgradeSlotChangeResult checkExtraInsertConditions(class_1799 upgradeStack, IStorageWrapper storageWrapper, boolean isClientSide, @Nullable IUpgradeItem<?> upgradeInSlot) {
        if (isClientSide) {
            return new UpgradeSlotChangeResult.Success();
        }
        return this.checkCompressionSpace(storageWrapper);
    }

    public List<IUpgradeItem.UpgradeConflictDefinition> getUpgradeConflicts() {
        return UPGRADE_CONFLICT_DEFINITIONS;
    }

    private UpgradeSlotChangeResult canUseForCompression(IStorageWrapper storageWrapper, SlotRange slotRange) {
        boolean allRemainingSlotsMustBeEmpty = false;
        class_1792 nextItemToMatch = class_1802.field_8162;
        LinkedHashSet<Integer> errorSlots = new LinkedHashSet<Integer>();
        InventoryHandler inventoryHandler = storageWrapper.getInventoryHandler();
        MemorySettingsCategory memorySettingsCategory = (MemorySettingsCategory)storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class);
        for (int slot = slotRange.firstSlot() + slotRange.numberOfSlots() - 1; slot >= slotRange.firstSlot(); --slot) {
            boolean hasSlotBeforeThisOne;
            class_1799 slotStack = inventoryHandler.getSlotStack(slot);
            class_1792 item = !slotStack.method_7960() ? slotStack.method_7909() : memorySettingsCategory.getSlotFilterStack(slot, false).map(class_1799::method_7909).orElse(class_1802.field_8162);
            if (item == class_1802.field_8162) continue;
            if (allRemainingSlotsMustBeEmpty) {
                errorSlots.add(slot);
                continue;
            }
            if (nextItemToMatch != class_1802.field_8162 && nextItemToMatch != item) {
                errorSlots.add(slot);
                break;
            }
            boolean bl = hasSlotBeforeThisOne = slot - 1 >= slotRange.firstSlot();
            if (!hasSlotBeforeThisOne) continue;
            RecipeHelper.CompactingShape compactingShape = RecipeHelper.getItemCompactingShapes((class_1792)item).stream().filter(RecipeHelper.CompactingShape::isUncraftable).findFirst().orElse(RecipeHelper.CompactingShape.NONE);
            if (compactingShape == RecipeHelper.CompactingShape.TWO_BY_TWO_UNCRAFTABLE || compactingShape == RecipeHelper.CompactingShape.THREE_BY_THREE_UNCRAFTABLE) {
                nextItemToMatch = RecipeHelper.getCompactingResult((class_1792)item, (RecipeHelper.CompactingShape)compactingShape).getResult().method_7909();
                continue;
            }
            allRemainingSlotsMustBeEmpty = true;
        }
        return !errorSlots.isEmpty() ? new UpgradeSlotChangeResult.Fail(StorageTranslationHelper.INSTANCE.translError("add.compression_incompatible_items", new Object[0]), Set.of(), errorSlots, Set.of()) : new UpgradeSlotChangeResult.Success();
    }

    public class_1799 getCleanedUpgradeStack(class_1799 upgradeStack) {
        upgradeStack.method_7983(FIRST_INVENTORY_SLOT_TAG);
        return upgradeStack;
    }

    public static class Wrapper
    extends UpgradeWrapperBase<Wrapper, CompressionUpgradeItem> {
        public void onAdded() {
            this.upgrade.method_7983(CompressionUpgradeItem.FIRST_INVENTORY_SLOT_TAG);
            InventoryPartitioner inventoryPartitioner = this.storageWrapper.getInventoryHandler().getInventoryPartitioner();
            inventoryPartitioner.getFirstSpace(((Integer)Config.SERVER.compressionUpgrade.maxNumberOfSlots.get()).intValue()).ifPresent(slotRange -> {
                this.setFirstInventorySlot(slotRange.firstSlot());
                inventoryPartitioner.addInventoryPart(slotRange.firstSlot(), slotRange.numberOfSlots(), (IInventoryPartHandler)new CompressionInventoryPart(this.storageWrapper.getInventoryHandler(), (SlotRange)slotRange, () -> (MemorySettingsCategory)this.storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)));
            });
            ((ItemDisplaySettingsCategory)this.storageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)).itemsChanged();
        }

        private void setFirstInventorySlot(int firstInventorySlot) {
            this.upgrade.method_7948().method_10569(CompressionUpgradeItem.FIRST_INVENTORY_SLOT_TAG, firstInventorySlot);
            this.save();
        }

        public boolean canBeDisabled() {
            return false;
        }

        public boolean hideSettingsTab() {
            return true;
        }

        public void onBeforeRemoved() {
            super.onBeforeRemoved();
            this.storageWrapper.getInventoryHandler().getInventoryPartitioner().removeInventoryPart(this.getFirstInventorySlot());
            this.save();
        }

        private int getFirstInventorySlot() {
            return NBTHelper.getInt((class_1799)this.upgrade, (String)CompressionUpgradeItem.FIRST_INVENTORY_SLOT_TAG).orElse(-1);
        }

        protected Wrapper(IStorageWrapper storageWrapper, class_1799 upgrade, Consumer<class_1799> upgradeSaveHandler) {
            super(storageWrapper, upgrade, upgradeSaveHandler);
        }
    }
}

