/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.init;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import net.p3pp3rf1y.sophisticatedcore.compat.ICompat;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.compat.chipped.ChippedCompat;
import net.p3pp3rf1y.sophisticatedstorage.compat.litematica.LitematicaCompat;
import net.p3pp3rf1y.sophisticatedstorage.compat.mkb.ModernKeyBindingCompat;
import net.p3pp3rf1y.sophisticatedstorage.compat.sodium.SodiumCompat;

public class ModCompat {
    public static final String SODIUM = "sodium";
    public static final String MKB = "mkb";
    private static final Map<CompatInfo, Supplier<Callable<ICompat>>> compatFactories = new HashMap<CompatInfo, Supplier<Callable<ICompat>>>();
    private static final Map<CompatInfo, ICompat> loadedCompats = new HashMap<CompatInfo, ICompat>();

    private ModCompat() {
    }

    public static void compatsSetup() {
        loadedCompats.values().forEach(ICompat::setup);
    }

    @Nullable
    private static VersionPredicate fromSpec(String spec) {
        try {
            return VersionPredicate.parse((String)spec);
        }
        catch (VersionParsingException e) {
            return null;
        }
    }

    public static void initCompats() {
        for (Map.Entry<CompatInfo, Supplier<Callable<ICompat>>> entry : compatFactories.entrySet()) {
            if (!entry.getKey().isLoaded()) continue;
            try {
                loadedCompats.put(entry.getKey(), entry.getValue().get().call());
            }
            catch (Exception e) {
                SophisticatedStorage.LOGGER.error("Error instantiating compatibility ", (Throwable)e);
            }
        }
        loadedCompats.values().forEach(ICompat::init);
    }

    static {
        compatFactories.put(new CompatInfo("chipped", null), () -> ChippedCompat::new);
        compatFactories.put(new CompatInfo("litematica", null), () -> LitematicaCompat::new);
        compatFactories.put(new CompatInfo(SODIUM, ModCompat.fromSpec(">=0.4.9 <0.5")), () -> SodiumCompat::new);
        compatFactories.put(new CompatInfo(MKB, null), () -> ModernKeyBindingCompat::new);
    }

    record CompatInfo(String modId, @Nullable VersionPredicate supportedVersionRange) {
        public boolean isLoaded() {
            return FabricLoader.getInstance().getModContainer(this.modId()).map(container -> this.supportedVersionRange() == null || this.supportedVersionRange().test((Object)container.getMetadata().getVersion())).orElse(false);
        }
    }
}

