/*
 * Decompiled with CFR 0.152.
 */
package dev.zanckor.cobblemonridingfabric.event;

import com.google.gson.Gson;
import dev.zanckor.cobblemonridingfabric.CobblemonRidingFabric;
import dev.zanckor.cobblemonridingfabric.config.PokemonJsonObject;
import dev.zanckor.cobblemonridingfabric.network.SendPacket;
import dev.zanckor.cobblemonridingfabric.network.packet.ConfigS2CPacket;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;

public class ServerPlayerEvent {
    public static void playerJoin() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            PokemonJsonObject config = ServerPlayerEvent.loadConfig();
            CobblemonRidingFabric.LOGGER.info("[RIDE] Sending config to player " + handler.field_14140.method_5477().getString());
            CobblemonRidingFabric.LOGGER.info("[RIDE] Config: " + String.valueOf(config));
            if (config != null) {
                String json = new Gson().toJson((Object)config);
                int max = 32000;
                int total = (int)Math.ceil((double)json.length() / (double)max);
                for (int i = 0; i < total; ++i) {
                    int start = i * max;
                    int end = Math.min(start + max, json.length());
                    String chunk = json.substring(start, end);
                    SendPacket.TO_CLIENT((class_1657)handler.field_14140, new ConfigS2CPacket(chunk, i, total));
                }
            }
        });
    }

    public static PokemonJsonObject loadConfig() {
        File pokemonRideConfigFile = CobblemonRidingFabric.PokemonRideConfigFile;
        String pokemonRideConfig = null;
        CobblemonRidingFabric.LOGGER.info("[RIDE] Loading cobblemon pokemon ride config file" + String.valueOf(pokemonRideConfigFile));
        try {
            if (pokemonRideConfigFile != null) {
                CobblemonRidingFabric.LOGGER.info("[RIDE] Pokemon ride config file exists" + String.valueOf(pokemonRideConfigFile));
                pokemonRideConfig = new String(Files.readAllBytes(pokemonRideConfigFile.toPath()));
                CobblemonRidingFabric.LOGGER.info("[RIDE] Pokemon ride config loaded" + pokemonRideConfig);
            }
        }
        catch (IOException e) {
            CobblemonRidingFabric.LOGGER.info("Error reading cobblemon pokemon ride config file" + String.valueOf(pokemonRideConfigFile));
            return null;
        }
        CobblemonRidingFabric.LOGGER.info("[RIDE] Pokemon ride config: " + pokemonRideConfig);
        return pokemonRideConfig != null ? (PokemonJsonObject)new Gson().fromJson(pokemonRideConfig, PokemonJsonObject.class) : null;
    }
}

