/*
 * Decompiled with CFR 0.152.
 */
package dev.zanckor.cobblemonridingfabric.config;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PokemonJsonObject {
    Boolean mustAllowEntityRiding = false;
    Map<String, PokemonConfigData> pokemonTypes = new HashMap<String, PokemonConfigData>();

    public void add(String pokemonType, PokemonConfigData pokemonConfigData) {
        this.pokemonTypes.put(pokemonType, pokemonConfigData);
    }

    public boolean mustAllowEntityRiding() {
        return this.mustAllowEntityRiding != null && this.mustAllowEntityRiding != false;
    }

    public Set<String> getPokemonIDs() {
        return this.pokemonTypes.keySet();
    }

    public PokemonConfigData getPokemonData(String pokemonType) {
        return this.pokemonTypes.get(pokemonType);
    }

    public static class PokemonConfigData {
        String formName;
        int stamina;
        ArrayList<MountType> mountType;
        OffsetData ridingOffset = new OffsetData();
        PassengerOffsetData passengersOffset = new PassengerOffsetData();
        float speedModifier = 1.0f;

        public PokemonConfigData(ArrayList<MountType> mountType, OffsetData ridingOffset, PassengerOffsetData passengersOffset) {
            this.mountType = mountType;
            this.ridingOffset = ridingOffset;
            this.passengersOffset = passengersOffset;
        }

        public PokemonConfigData(ArrayList<MountType> mountType, OffsetData ridingOffset) {
            this(mountType, ridingOffset, new PassengerOffsetData());
        }

        public PokemonConfigData(ArrayList<MountType> mountType) {
            this(mountType, new OffsetData(), new PassengerOffsetData());
        }

        public PokemonConfigData() {
            this(new ArrayList<MountType>(List.of(MountType.WALK)));
        }

        public int getMaxStamina() {
            return this.stamina != 0 ? this.stamina : 200;
        }

        public String getFormName() {
            return this.formName == null ? "none" : this.formName;
        }

        public ArrayList<MountType> getMountTypes() {
            return this.mountType;
        }

        public OffsetData getRidingOffset() {
            return this.ridingOffset;
        }

        public PassengerOffsetData getPassengersOffset() {
            return this.passengersOffset;
        }

        public float getSpeedModifier() {
            return this.speedModifier;
        }
    }

    public static enum MountType {
        WALK,
        SWIM,
        LAVA_SWIM,
        FLY;

    }

    public static class PassengerOffsetData {
        @SerializedName(value="default")
        ArrayList<ArrayList<Float>> base = new ArrayList();
        @SerializedName(value="moving")
        ArrayList<ArrayList<Float>> moving;
        @SerializedName(value="flying")
        ArrayList<ArrayList<Float>> flying;
        @SerializedName(value="flying:moving")
        ArrayList<ArrayList<Float>> flyingMoving;
        @SerializedName(value="flying:idle")
        ArrayList<ArrayList<Float>> flyingIdle;
        @SerializedName(value="swimming")
        ArrayList<ArrayList<Float>> swimming;
        @SerializedName(value="swimming:moving")
        ArrayList<ArrayList<Float>> swimmingMoving;
        @SerializedName(value="swimming:idle")
        ArrayList<ArrayList<Float>> swimmingIdle;
        @SerializedName(value="swimming:lava")
        ArrayList<ArrayList<Float>> swimmingLava;
        @SerializedName(value="swimming:lava:moving")
        ArrayList<ArrayList<Float>> swimmingLavaMoving;
        @SerializedName(value="swimming:lava:idle")
        ArrayList<ArrayList<Float>> swimmingLavaIdle;

        public PassengerOffsetData() {
        }

        public PassengerOffsetData(ArrayList<ArrayList<Float>> base) {
            this.base = base;
        }

        public ArrayList<ArrayList<Float>> getDefault() {
            return this.base;
        }

        public ArrayList<ArrayList<Float>> getMoving() {
            return this.moving != null ? this.moving : this.base;
        }

        public ArrayList<ArrayList<Float>> getFlying() {
            return this.flying != null ? this.flying : this.base;
        }

        public ArrayList<ArrayList<Float>> getFlyingMoving() {
            return this.flyingMoving != null ? this.flyingMoving : this.getFlying();
        }

        public ArrayList<ArrayList<Float>> getFlyingIdle() {
            return this.flyingIdle != null ? this.flyingIdle : this.getFlying();
        }

        public ArrayList<ArrayList<Float>> getSwimming() {
            return this.swimming != null ? this.swimming : this.base;
        }

        public ArrayList<ArrayList<Float>> getSwimmingMoving() {
            return this.swimmingMoving != null ? this.swimmingMoving : this.getSwimming();
        }

        public ArrayList<ArrayList<Float>> getSwimmingIdle() {
            return this.swimmingIdle != null ? this.swimmingIdle : this.getSwimming();
        }

        public ArrayList<ArrayList<Float>> getSwimmingLava() {
            return this.swimmingLava != null ? this.swimmingLava : this.base;
        }

        public ArrayList<ArrayList<Float>> getSwimmingLavaMoving() {
            return this.swimmingLavaMoving != null ? this.swimmingLavaMoving : this.getSwimmingLava();
        }

        public ArrayList<ArrayList<Float>> getSwimmingLavaIdle() {
            return this.swimmingLavaIdle != null ? this.swimmingLavaIdle : this.getSwimmingLava();
        }
    }

    public static class OffsetData {
        @SerializedName(value="default")
        ArrayList<Float> base = new ArrayList<Float>(List.of(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)));
        @SerializedName(value="moving")
        ArrayList<Float> moving;
        @SerializedName(value="flying")
        ArrayList<Float> flying;
        @SerializedName(value="flying:moving")
        ArrayList<Float> flyingMoving;
        @SerializedName(value="flying:idle")
        ArrayList<Float> flyingIdle;
        @SerializedName(value="swimming")
        ArrayList<Float> swimming;
        @SerializedName(value="swimming:moving")
        ArrayList<Float> swimmingMoving;
        @SerializedName(value="swimming:idle")
        ArrayList<Float> swimmingIdle;
        @SerializedName(value="swimming:lava")
        ArrayList<Float> swimmingLava;
        @SerializedName(value="swimming:lava:moving")
        ArrayList<Float> swimmingLavaMoving;
        @SerializedName(value="swimming:lava:idle")
        ArrayList<Float> swimmingLavaIdle;

        public OffsetData() {
        }

        public OffsetData(ArrayList<Float> base) {
            this.base = base;
        }

        public ArrayList<Float> getDefault() {
            return this.base;
        }

        public ArrayList<Float> getMoving() {
            return this.moving != null ? this.moving : this.base;
        }

        public ArrayList<Float> getFlying() {
            return this.flying != null ? this.flying : this.base;
        }

        public ArrayList<Float> getFlyingMoving() {
            return this.flyingMoving != null ? this.flyingMoving : this.getFlying();
        }

        public ArrayList<Float> getFlyingIdle() {
            return this.flyingIdle != null ? this.flyingIdle : this.getFlying();
        }

        public ArrayList<Float> getSwimming() {
            return this.swimming != null ? this.swimming : this.base;
        }

        public ArrayList<Float> getSwimmingMoving() {
            return this.swimmingMoving != null ? this.swimmingMoving : this.getSwimming();
        }

        public ArrayList<Float> getSwimmingIdle() {
            return this.swimmingIdle != null ? this.swimmingIdle : this.getSwimming();
        }

        public ArrayList<Float> getSwimmingLava() {
            return this.swimmingLava != null ? this.swimmingLava : this.base;
        }

        public ArrayList<Float> getSwimmingLavaMoving() {
            return this.swimmingLavaMoving != null ? this.swimmingLavaMoving : this.getSwimmingLava();
        }

        public ArrayList<Float> getSwimmingLavaIdle() {
            return this.swimmingLavaIdle != null ? this.swimmingLavaIdle : this.getSwimmingLava();
        }
    }
}

