/*
 * Decompiled with CFR 0.152.
 */
package dev.zanckor.cobblemonridingfabric;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.logging.LogUtils;
import dev.zanckor.cobblemonridingfabric.config.PokemonJsonObject;
import dev.zanckor.cobblemonridingfabric.event.ServerPlayerEvent;
import dev.zanckor.cobblemonridingfabric.network.NetworkHandler;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class CobblemonRidingFabric
implements ModInitializer {
    public static final String MODID = "cobblemonridingfabric";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static File PokemonRideConfigFile;
    private static final Map<Integer, String> chunks;
    private static int totalChunks;
    public static PokemonJsonObject pokemonJsonObject;

    public static void addConfigChunk(int index, String chunk, int total) {
        chunks.put(index, chunk);
        totalChunks = total;
        if (chunks.size() == totalChunks) {
            StringBuilder fullConfig = new StringBuilder();
            for (int i = 0; i < totalChunks; ++i) {
                fullConfig.append(chunks.get(i));
            }
            LOGGER.info("[RIDE] Rebuilt JSON from chunks: " + String.valueOf(fullConfig));
            pokemonJsonObject = (PokemonJsonObject)new Gson().fromJson(fullConfig.toString(), PokemonJsonObject.class);
            LOGGER.info(pokemonJsonObject.getPokemonData("entei").getRidingOffset().toString());
            LOGGER.info("[RIDE] Parsed object: " + String.valueOf(pokemonJsonObject));
            LOGGER.info("[RIDE] Checking Entei: " + String.valueOf(pokemonJsonObject.getPokemonData("entei")));
            LOGGER.info("[RIDE] Offsets: " + String.valueOf(pokemonJsonObject.getPokemonData("entei").getRidingOffset()));
            LOGGER.info("[RIDE] Base offset: " + String.valueOf(pokemonJsonObject.getPokemonData("entei").getRidingOffset().getDefault()));
            chunks.clear();
            totalChunks = 0;
        }
    }

    public void onInitialize() {
        this.registerEvents();
        NetworkHandler.registerServerReceiverPacket();
    }

    private void registerEvents() {
        ServerPlayerEvent.playerJoin();
        PokemonJsonObject config = ServerPlayerEvent.loadConfig();
        LOGGER.info("[RIDE] Loaded ride config", (Object)config);
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            PokemonRideConfigFile = new File(server.method_3831(), "pokemonRideConfig.json");
            CobblemonRidingFabric.serverFolderManager(server);
        });
    }

    public static void serverFolderManager(MinecraftServer server) {
        File pokemonRideConfig;
        Path serverDirectory = server.method_27050(class_5218.field_24188).toAbsolutePath();
        PokemonRideConfigFile = pokemonRideConfig = Paths.get(serverDirectory.toString(), "pokemonRideConfig.json").toFile();
        PokemonJsonObject pokemonJsonObject = new PokemonJsonObject();
        pokemonJsonObject.add("Charizard", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK, PokemonJsonObject.MountType.FLY)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Blastoise", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK, PokemonJsonObject.MountType.SWIM)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Pidgeot", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK, PokemonJsonObject.MountType.FLY)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.7f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Fearow", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK, PokemonJsonObject.MountType.FLY)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Nidoking", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Ninetales", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Arcanine", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Tentacruel", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK, PokemonJsonObject.MountType.SWIM)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.5f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Rapidash", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.8f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Magnezone", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Dodrio", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.2f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Dewgong", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK, PokemonJsonObject.MountType.SWIM)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Exeggutor", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(3.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Tauros", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(2.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Gyarados", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.SWIM)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Lapras", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.SWIM)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Aerodactyl", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK, PokemonJsonObject.MountType.FLY)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Dragonite", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK, PokemonJsonObject.MountType.FLY)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(2.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Meganium", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(2.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Feraligatr", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK, PokemonJsonObject.MountType.SWIM)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(2.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Steelix", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(6.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Stantler", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Swampert", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK, PokemonJsonObject.MountType.SWIM)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Mightyena", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Sharpedo", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.SWIM)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Wailmer", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.SWIM)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(2.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Camerupt", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(2.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Relicanth", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.SWIM)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Metagross", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(2.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Staraptor", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK, PokemonJsonObject.MountType.FLY)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Luxray", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Garchomp", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(2.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Yanmega", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.FLY)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Mamoswine", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(5.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Samurott", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK, PokemonJsonObject.MountType.SWIM)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(2.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Stoutland", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Scolipede", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Sawsbuck", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Golurk", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(5.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Bouffalant", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(2.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Avalugg", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK, PokemonJsonObject.MountType.SWIM)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(3.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Mudsdale", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(2.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Corviknight", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK, PokemonJsonObject.MountType.FLY)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(3.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Wyrdeer", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Ursaluna", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Skeledirge", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))))));
        pokemonJsonObject.add("Espahtla", new PokemonJsonObject.PokemonConfigData(new ArrayList<PokemonJsonObject.MountType>(List.of(PokemonJsonObject.MountType.WALK)), new PokemonJsonObject.OffsetData(new ArrayList<Float>(Arrays.asList(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.0f))))));
        if (pokemonRideConfig.exists()) {
            LOGGER.info("Cobblemon pokemon ride config file already exists at " + String.valueOf(pokemonRideConfig));
        } else {
            try (FileWriter file = new FileWriter(pokemonRideConfig);){
                file.write(new GsonBuilder().setPrettyPrinting().create().toJson((Object)pokemonJsonObject));
                LOGGER.info("File created: " + pokemonRideConfig.getName());
                LOGGER.info("Cobblemon pokemon ride config file created at " + String.valueOf(pokemonRideConfig));
            }
            catch (IOException ex) {
                ex.printStackTrace();
                LOGGER.info("Error creating cobblemon pokemon ride config file" + String.valueOf(pokemonRideConfig));
            }
        }
        try {
            String pokemonRideConfigObject = new String(Files.readAllBytes(pokemonRideConfig.toPath()));
            CobblemonRidingFabric.pokemonJsonObject = (PokemonJsonObject)new Gson().fromJson(pokemonRideConfigObject, PokemonJsonObject.class);
        }
        catch (IOException ex) {
            LOGGER.info("Error reading cobblemon pokemon ride config file" + String.valueOf(pokemonRideConfig));
        }
    }

    static {
        chunks = new TreeMap<Integer, String>();
        totalChunks = 0;
    }
}

