/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.loot.conditions;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_181;
import net.minecraft.class_3518;
import net.minecraft.class_47;
import net.minecraft.class_5335;
import net.minecraft.class_5341;
import net.minecraft.class_5342;

public class DefeatCountCondition
implements class_5341 {
    private static Supplier<class_5342> TYPE;
    final Comparator comparator;
    final int count;

    public static void init(Supplier<class_5342> type) {
        TYPE = type;
    }

    DefeatCountCondition(int count) {
        this(count, Comparator.EQUAL);
    }

    DefeatCountCondition(int count, Comparator comparator) {
        this.count = count;
        this.comparator = comparator;
    }

    public class_5342 method_29325() {
        return TYPE.get();
    }

    public boolean test(class_47 lootContext) {
        Object object;
        class_1657 player = (class_1657)lootContext.method_296(class_181.field_1233);
        if (player != null && (object = lootContext.method_296(class_181.field_1226)) instanceof TrainerMob) {
            TrainerMob mob = (TrainerMob)((Object)object);
            return this.comparator.test(RCTMod.get().getTrainerManager().getBattleMemory(mob).getDefeatByCount(player), this.count);
        }
        return false;
    }

    public static enum Comparator {
        EQUAL((a, b) -> a.equals(b)),
        SMALLER((a, b) -> a < b),
        GREATER((a, b) -> a > b),
        MODULO((a, b) -> a % b == 0);

        private BiFunction<Integer, Integer, Boolean> testFunc;

        private Comparator(BiFunction<Integer, Integer, Boolean> testFunc) {
            this.testFunc = testFunc;
        }

        public boolean test(int a, int b) {
            return this.testFunc.apply(a, b);
        }
    }

    public static class Serializer
    implements class_5335<DefeatCountCondition> {
        public void serialize(JsonObject jsonObject, DefeatCountCondition defeatCountCondition, JsonSerializationContext jsonSerializationContext) {
            jsonObject.add("count", jsonSerializationContext.serialize((Object)defeatCountCondition.count));
            jsonObject.add("comparator", jsonSerializationContext.serialize((Object)defeatCountCondition.comparator.name()));
        }

        public DefeatCountCondition deserialize(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            int count = class_3518.method_15260((JsonObject)jsonObject, (String)"count");
            Comparator comparator = Comparator.valueOf(class_3518.method_15253((JsonObject)jsonObject, (String)"comparator", (String)"EQUAL"));
            return new DefeatCountCondition(count, comparator);
        }
    }
}

