/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.entities.goals;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_1379;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_5568;
import net.minecraft.class_5819;

public class RandomStrollThroughVillageGoal
extends class_1379 {
    private static final int SECTION_SCAN_RADIUS = 6;
    private static final int MAX_IDLE_TIME = 400;
    private static final int MIN_IDLE_TIME = 20;
    private static final int MAX_STROLL_TIME = 800;
    private static final int MIN_STROLL_TIME = 100;
    private class_1314 mob;
    private class_2338 target;
    private int idleTime;
    private int idleTimer;
    private int strollTime;
    private int strollTimer;
    private int prevMobTickCount;
    private class_4076 prevSection;
    private Supplier<Float> probability;

    public RandomStrollThroughVillageGoal(class_1314 pathfinderMob, float d, Supplier<Float> p) {
        super(pathfinderMob, (double)d, 1, false);
        this.mob = pathfinderMob;
        this.probability = p;
    }

    public void method_6269() {
        class_243 targetV = this.target.method_46558();
        this.idleTime = this.mob.method_6051().method_43051(20, 400);
        this.strollTime = this.mob.method_6051().method_43051(100, 800);
        this.idleTimer = 0;
        this.strollTimer = 0;
        this.prevMobTickCount = this.mob.field_6012;
        this.mob.method_5942().method_6337(targetV.field_1352, targetV.field_1351, targetV.field_1350, this.field_6567);
    }

    public boolean method_6264() {
        this.method_6304();
        return this.mob.method_6051().method_43057() < this.probability.get().floatValue() && this.tryTargetInRandomSection() && super.method_6264();
    }

    public boolean method_6266() {
        if (!this.mob.method_5799() && !this.mob.method_5771() && this.mob.method_6051().method_43048(600) == 0) {
            return false;
        }
        if (super.method_6266()) {
            if (!this.mob.method_5799() && !this.mob.method_5771()) {
                if (this.strollTimer < this.strollTime) {
                    this.strollTimer += this.mob.field_6012 - this.prevMobTickCount;
                } else {
                    this.mob.method_5942().method_6340();
                }
            }
        } else {
            if (!this.mob.method_5799() && !this.mob.method_5771() && this.idleTimer < this.idleTime) {
                this.idleTimer += this.mob.field_6012 - this.prevMobTickCount;
                this.prevMobTickCount = this.mob.field_6012;
                return true;
            }
            if (this.tryTargetInRandomSection()) {
                this.method_6269();
                return true;
            }
            return false;
        }
        this.prevMobTickCount = this.mob.field_6012;
        return true;
    }

    protected class_243 method_6302() {
        return this.target != null ? this.target.method_46558() : null;
    }

    private boolean tryTargetInRandomSection() {
        this.target = this.getRandomPosInVillage();
        return this.target != null;
    }

    private class_2338 getRandomPosInVillage() {
        class_2338 targetPoi;
        class_4076 sectionPos = this.getRandomVillageSection();
        if (sectionPos == null) {
            return null;
        }
        class_5819 rng = this.mob.method_6051();
        if ((double)rng.method_43057() < 0.15 && (targetPoi = this.getRandomPoiWithinSection(sectionPos)) != null) {
            return this.toGroundPos(targetPoi.method_10088(rng.method_43051(-8, 8)).method_10089(rng.method_43051(-8, 8)));
        }
        return this.toGroundPos(this.getRandomPosWithinSection(sectionPos));
    }

    private class_4076 getRandomVillageSection() {
        if (this.prevSection == null || (double)this.mob.method_6051().method_43057() < 0.15) {
            class_3218 serverLevel = (class_3218)this.mob.method_37908();
            List list = class_4076.method_20439((class_4076)class_4076.method_42614((class_5568)this.mob), (int)6).filter(arg_0 -> ((class_3218)serverLevel).method_20588(arg_0)).collect(Collectors.toList());
            this.prevSection = list.isEmpty() ? null : (class_4076)list.get(this.mob.method_6051().method_43048(list.size()));
        }
        return this.prevSection;
    }

    private class_2338 getRandomPoiWithinSection(class_4076 sectionPos) {
        class_3218 serverLevel = (class_3218)this.mob.method_37908();
        class_4153 poiManager = serverLevel.method_19494();
        List list = poiManager.method_19125(holder -> true, sectionPos.method_19768(), 8, class_4153.class_4155.field_18489).map(class_4156::method_19141).collect(Collectors.toList());
        return list.isEmpty() ? null : (class_2338)list.get(this.mob.method_6051().method_43048(list.size()));
    }

    private class_2338 getRandomPosWithinSection(class_4076 sectionPos) {
        class_5819 rng = this.mob.method_6051();
        return sectionPos.method_19768().method_10089(rng.method_43051(-8, 8)).method_10088(rng.method_43051(-8, 8)).method_33096(this.mob.method_31478());
    }

    private class_2338 toGroundPos(class_2338 pos) {
        class_1937 level = this.mob.method_37908();
        class_2338 pUp = pos;
        class_2338 pDn = pos.method_10074();
        while (pUp.method_10264() - pos.method_10264() < 24 && pos.method_10264() - pDn.method_10264() < 24 && pUp.method_10264() <= level.method_31600() && pDn.method_10264() >= level.method_31607()) {
            class_2680 bs = level.method_8320(pUp);
            if (bs.method_26168((class_1922)level, pUp, (class_1297)this.mob)) {
                return pUp;
            }
            bs = level.method_8320(pDn);
            if (bs.method_26168((class_1922)level, pDn, (class_1297)this.mob)) {
                return pDn;
            }
            pUp = pUp.method_10084();
            pDn = pDn.method_10074();
        }
        return pos;
    }

    public void method_6268() {
        this.mob.method_5942().method_6344(this.mob.method_5799() || this.mob.method_5771() ? 1.0 : this.field_6567);
        super.method_6268();
    }
}

