/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.entities;

import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.config.IClientConfig;
import com.gitlab.srcmc.rctmod.api.config.IServerConfig;
import com.gitlab.srcmc.rctmod.api.data.TrainerBattle;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.api.utils.ChatUtils;
import com.gitlab.srcmc.rctmod.client.ModClient;
import com.gitlab.srcmc.rctmod.world.entities.goals.LookAtPlayerAndWaitGoal;
import com.gitlab.srcmc.rctmod.world.entities.goals.MoveCloseToTargetGoal;
import com.gitlab.srcmc.rctmod.world.entities.goals.PokemonBattleGoal;
import com.gitlab.srcmc.rctmod.world.entities.goals.RandomStrollAwayGoal;
import com.gitlab.srcmc.rctmod.world.entities.goals.RandomStrollThroughVillageGoal;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1314;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1394;
import net.minecraft.class_1564;
import net.minecraft.class_1581;
import net.minecraft.class_1604;
import net.minecraft.class_1632;
import net.minecraft.class_1634;
import net.minecraft.class_1642;
import net.minecraft.class_1655;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5136;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_8567;

public class TrainerMob
extends class_1314
implements class_1655 {
    private static final class_2940<String> DATA_TRAINER_ID = class_2945.method_12791(TrainerMob.class, (class_2941)class_2943.field_13326);
    private static final class_1299<TrainerMob> TYPE = class_1299.class_1300.method_5903(TrainerMob::new, (class_1311)class_1311.field_17715).method_20815().method_17687(0.6f, 1.95f).method_5905("trainer");
    private final int TICKS_TO_DESPAWN = 600;
    private final int DESPAWN_TICK_SCALE = 20;
    private final int DESPAWN_DISTANCE = 128;
    private final int MAX_PLAYER_TRACKING_RANGE = 128;
    private int cooldown;
    private int wins;
    private int defeats;
    private class_1657 opponent;
    private UUID originPlayer;
    private boolean persistent;
    private int despawnTicks;

    protected TrainerMob(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
        this.udpateCustomName();
    }

    public static class_1299<TrainerMob> getEntityType() {
        return TYPE;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, 0.5).method_26868(class_5134.field_23717, 48.0).method_26868(class_5134.field_23716, 30.0);
    }

    public boolean canBattleAgainst(class_1297 e) {
        if (e instanceof class_1657) {
            class_1657 player = (class_1657)e;
            if (RCTMod.get().isInBattle(player)) {
                return false;
            }
            TrainerManager tm = RCTMod.get().getTrainerManager();
            if (tm.getActivePokemon(player) == 0) {
                return false;
            }
            IServerConfig cfg = RCTMod.get().getServerConfig();
            PlayerState playerState = PlayerState.get(player);
            if (tm.getPlayerLevel(player) > playerState.getLevelCap() + cfg.maxOverLevelCap()) {
                return false;
            }
            TrainerMobData trMob = tm.getData(this);
            if (playerState.getLevelCap() < trMob.getRequiredLevelCap()) {
                return false;
            }
            for (TrainerMobData.Type type : TrainerMobData.Type.values()) {
                if (playerState.getTypeDefeatCount(type) >= (long)trMob.getRequiredDefeats(type)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void startBattleWith(class_1657 player) {
        if (this.canBattleAgainst((class_1297)player)) {
            if (RCTMod.get().makeBattle(this, player)) {
                RCTMod.get().getTrainerManager().addBattle(player, this);
                ChatUtils.reply(this, player, "battle_start");
                this.setOpponent(player);
            }
        } else {
            this.replyTo(player);
        }
    }

    protected void replyTo(class_1657 player) {
        TrainerManager tm = RCTMod.get().getTrainerManager();
        IServerConfig cfg = RCTMod.get().getServerConfig();
        PlayerState playerState = PlayerState.get(player);
        TrainerMobData trMob = tm.getData(this);
        if (RCTMod.get().isInBattle(player)) {
            ChatUtils.reply(this, player, "player_busy");
        } else if (playerState.getTypeDefeatCount(TrainerMobData.Type.LEADER) < (long)trMob.getRequiredDefeats(TrainerMobData.Type.LEADER)) {
            ChatUtils.reply(this, player, "missing_badges");
        } else if (playerState.getTypeDefeatCount(TrainerMobData.Type.E4) < (long)trMob.getRequiredDefeats(TrainerMobData.Type.E4)) {
            ChatUtils.reply(this, player, "missing_beaten_e4");
        } else if (playerState.getTypeDefeatCount(TrainerMobData.Type.CHAMP) < (long)trMob.getRequiredDefeats(TrainerMobData.Type.CHAMP)) {
            ChatUtils.reply(this, player, "missing_beaten_champs");
        } else if (playerState.getLevelCap() < trMob.getRequiredLevelCap()) {
            ChatUtils.reply(this, player, "low_level_cap");
        } else if (tm.getPlayerLevel(player) > playerState.getLevelCap() + cfg.maxOverLevelCap()) {
            ChatUtils.reply(this, player, "over_level_cap");
        } else if (tm.getActivePokemon(player) == 0) {
            ChatUtils.reply(this, player, "missing_pokemon");
        } else {
            ChatUtils.reply(this, player, "done_generic");
        }
    }

    protected void setOpponent(class_1657 player) {
        this.opponent = player;
    }

    public class_1657 getOpponent() {
        return this.opponent;
    }

    public boolean isInBattle() {
        return this.opponent != null;
    }

    public int getDefeats() {
        return this.defeats;
    }

    public int getWins() {
        return this.wins;
    }

    public boolean canBattle() {
        TrainerMobData mobTr = RCTMod.get().getTrainerManager().getData(this);
        return !this.isInBattle() && this.getCooldown() == 0 && (this.method_5947() || mobTr.getMaxTrainerDefeats() > 0 && this.getDefeats() < mobTr.getMaxTrainerDefeats() && mobTr.getMaxTrainerWins() > 0 && this.getWins() < mobTr.getMaxTrainerWins());
    }

    private void udpateCustomName() {
        TrainerMobData tmd = RCTMod.get().getTrainerManager().getData(this);
        this.method_5665((class_2561)class_2561.method_43470((String)tmd.getTeam().getDisplayName()));
    }

    public class_2561 method_5476() {
        TrainerMobData tmd = RCTMod.get().getTrainerManager().getData(this);
        StringBuilder suffix = new StringBuilder();
        class_5250 cmp = this.method_5797().method_27661();
        Optional<class_1657> localPlayer = ModClient.get().getLocalPlayer();
        if (localPlayer.isPresent()) {
            String sym;
            IClientConfig cfg = RCTMod.get().getClientConfig();
            class_1657 player = localPlayer.get();
            if (cfg.showTrainerTypeSymbols() && (sym = tmd.getType().toString()).length() > 0) {
                suffix.append(' ').append(sym);
            }
            if (cfg.showTrainerTypeColors()) {
                cmp.method_10862(cmp.method_10866().method_36139(tmd.getType().toColor()));
            }
            if (PlayerState.get(player).getTrainerDefeatCount(this.getTrainerId()) == 0) {
                cmp.method_10862(cmp.method_10866().method_10978(Boolean.valueOf(true)));
            }
        }
        return cmp.method_27693(suffix.toString());
    }

    public void setTrainerId(String trainerId) {
        String currentId;
        class_1937 level = this.method_37908();
        if (!level.field_9236 && ((currentId = this.getTrainerId()) == null && trainerId != null || currentId != null && !currentId.equals(trainerId))) {
            RCTMod.get().getTrainerSpawner().notifyChangeTrainerId(this, trainerId);
            this.field_6011.method_12778(DATA_TRAINER_ID, (Object)trainerId);
            this.udpateCustomName();
            if (!RCTMod.get().getTrainerManager().isValidId(trainerId)) {
                ModCommon.LOG.error(String.format("Invalid trainer id '%s' (%s)", trainerId, this.method_5845()));
            }
        }
    }

    public String getTrainerId() {
        return (String)this.field_6011.method_12789(DATA_TRAINER_ID);
    }

    public void finishBattle(TrainerBattle battle, boolean defeated) {
        class_1937 level = this.method_37908();
        if (!level.field_9236 && this.isInBattle()) {
            TrainerMobData mobTr = RCTMod.get().getTrainerManager().getData(this);
            this.cooldown = mobTr.getBattleCooldownTicks();
            this.setOpponent(null);
            this.method_5980(null);
            if (defeated) {
                if (battle.getInitiatorSideMobs().contains((Object)this)) {
                    battle.getTrainerSidePlayers().forEach(player -> ChatUtils.reply(this, player, "battle_lost"));
                } else {
                    TrainerManager tm = RCTMod.get().getTrainerManager();
                    List<class_1657> initiatorSidePlayer = battle.getInitiatorSidePlayers();
                    class_1657 minWinsPlayer = null;
                    for (class_1657 player2 : initiatorSidePlayer) {
                        ChatUtils.reply(this, player2, "battle_lost");
                        minWinsPlayer = minWinsPlayer == null || tm.getBattleMemory(this).getDefeatByCount(player2) < tm.getBattleMemory(this).getDefeatByCount(player2) ? player2 : minWinsPlayer;
                    }
                    if (minWinsPlayer != null) {
                        this.dropBattleLoot(mobTr.getLootTableResource(), minWinsPlayer);
                    }
                }
                ++this.defeats;
            } else {
                if (battle.getInitiatorSideMobs().contains((Object)this)) {
                    battle.getTrainerSidePlayers().forEach(player -> ChatUtils.reply(this, player, "battle_won"));
                } else {
                    battle.getInitiatorSidePlayers().forEach(player -> ChatUtils.reply(this, player, "battle_won"));
                }
                ++this.wins;
            }
            if (this.getDefeats() >= mobTr.getMaxTrainerDefeats() || this.getWins() >= mobTr.getMaxTrainerWins()) {
                this.setOriginPlayer(null);
            }
        }
    }

    public void cancelBattle() {
        if (this.opponent != null) {
            RCTMod.get().getTrainerManager().removeBattle(this.opponent.method_5667());
            RCTMod.get().stopBattle(this);
            this.setOpponent(null);
        }
    }

    protected void dropBattleLoot(class_2960 lootTableResource, class_1657 player) {
        class_1937 level = this.method_37908();
        class_52 lootTable = level.method_8503().method_3857().getLootTable(lootTableResource);
        class_8567.class_8568 builder = new class_8567.class_8568((class_3218)level).method_51874(class_181.field_1226, (Object)this).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1231, (Object)level.method_48963().method_48830()).method_51874(class_181.field_1233, (Object)player);
        lootTable.method_51880(builder.method_51875(class_173.field_1173), this.method_51851(), arg_0 -> ((TrainerMob)this).method_5775(arg_0));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_TRAINER_ID, (Object)"invalid");
    }

    public void method_5773() {
        super.method_5773();
        class_1937 level = this.method_37908();
        if (!level.field_9236) {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.isInBattle()) {
                if (!this.getOpponent().method_5805()) {
                    this.setOpponent(null);
                    ++this.wins;
                }
            } else {
                this.updateTarget();
            }
            if (this.method_5947() && !RCTMod.get().getTrainerSpawner().isRegistered(this)) {
                this.setPersistent(false);
                ModCommon.LOG.error(String.format("Disabled persistence for unregistered trainer '%s' (%s)", this.getTrainerId(), this.method_5845()));
            }
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 interactionHand) {
        class_1937 level = this.method_37908();
        if (!level.field_9236) {
            if (this.canBattle()) {
                this.startBattleWith(player);
            } else {
                TrainerMobData mobTr = RCTMod.get().getTrainerManager().getData(this);
                if (this.isInBattle()) {
                    ChatUtils.reply(this, player, "is_busy");
                } else if (!this.method_5947() && this.getDefeats() >= mobTr.getMaxTrainerDefeats()) {
                    ChatUtils.reply(this, player, "done_looser");
                } else if (!this.method_5947() && this.getWins() >= mobTr.getMaxTrainerWins()) {
                    ChatUtils.reply(this, player, "done_winner");
                } else if (this.getCooldown() > 0) {
                    ChatUtils.reply(this, player, "on_cooldown");
                } else {
                    ChatUtils.reply(this, player, "done_generic");
                }
            }
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    public void method_5650(class_1297.class_5529 reason) {
        if (RCTMod.get().getServerConfig().logSpawning()) {
            ModCommon.LOG.info(String.format("Removed trainer '%s' (%s): %s", this.getTrainerId(), this.method_5845(), reason.toString()));
        }
        if (reason == class_1297.class_5529.field_26999 || reason == class_1297.class_5529.field_26998) {
            RCTMod.get().getTrainerSpawner().unregister(this);
            this.cancelBattle();
        }
        super.method_5650(reason);
    }

    private void updateTarget() {
        if (this.field_6012 % 60 == 0) {
            if (this.canBattle()) {
                TrainerManager tm = RCTMod.get().getTrainerManager();
                int reqLevelCap = tm.getData(this).getRequiredLevelCap();
                this.method_5980(this.method_37908().method_18464(class_4051.method_36626().method_36627().method_18420(p -> PlayerState.get((class_1657)p).getLevelCap() >= reqLevelCap), (class_1309)this, this.method_5829().method_1011(128.0)).stream().sorted((p1, p2) -> Integer.compare(Math.abs(tm.getPlayerLevel((class_1657)p1) - reqLevelCap), Math.abs(tm.getPlayerLevel((class_1657)p2) - reqLevelCap))).findFirst().orElse(null));
            } else {
                this.method_5980(null);
            }
        }
    }

    public void setPersistent(boolean persistent) {
        if (this.persistent != persistent) {
            RCTMod.get().getTrainerSpawner().notifyChangePersistence(this, persistent);
            this.persistent = persistent;
        }
    }

    public boolean method_5947() {
        return this.persistent;
    }

    public boolean method_31746() {
        return this.method_5947();
    }

    public boolean method_31747() {
        return true;
    }

    public boolean method_5974(double d) {
        return false;
    }

    public boolean method_5822() {
        return false;
    }

    public boolean shouldDespawn() {
        if (++this.despawnTicks % 20 == 0) {
            if (!this.isInBattle() && this.method_37908().method_18460((class_1297)this, (double)Math.max(128, RCTMod.get().getServerConfig().maxHorizontalDistanceToPlayers())) == null) {
                return this.despawnTicks >= 600;
            }
            this.despawnTicks = 0;
        }
        return false;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return class_3417.field_17749;
    }

    protected class_3414 method_6002() {
        return class_3417.field_17748;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setOriginPlayer(UUID originPlayer) {
        if (this.originPlayer == null && originPlayer != null || this.originPlayer != null && !this.originPlayer.equals(originPlayer)) {
            RCTMod.get().getTrainerSpawner().notifyChangeOriginPlayer(this, originPlayer);
            this.originPlayer = originPlayer;
        }
    }

    public UUID getOriginPlayer() {
        return this.originPlayer;
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10569("Defeats", this.getDefeats());
        compoundTag.method_10569("Wins", this.getWins());
        compoundTag.method_10569("Cooldown", this.getCooldown());
        compoundTag.method_10582("TrainerId", this.getTrainerId());
        compoundTag.method_10556("Persistent", this.method_5947());
        if (this.originPlayer != null) {
            compoundTag.method_25927("OriginPlayer", this.originPlayer);
        }
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        if (compoundTag.method_10545("Defeats")) {
            this.defeats = compoundTag.method_10550("Defeats");
        }
        if (compoundTag.method_10545("Wins")) {
            this.wins = compoundTag.method_10550("Wins");
        }
        if (compoundTag.method_10545("Cooldown")) {
            this.cooldown = compoundTag.method_10550("Cooldown");
        }
        if (compoundTag.method_10545("TrainerId")) {
            this.setTrainerId(compoundTag.method_10558("TrainerId"));
        }
        if (compoundTag.method_10545("OriginPlayer")) {
            this.setOriginPlayer(compoundTag.method_25926("OriginPlayer"));
        }
        if (compoundTag.method_10545("Persistent")) {
            this.setPersistent(compoundTag.method_10577("Persistent"));
        }
    }

    public void method_6007() {
        super.method_6007();
        class_1937 level = this.method_37908();
        if (!level.field_9236 && this.method_5805() && this.field_5974.method_43048(400) == 0 && this.field_6213 == 0) {
            this.method_6025(1.0f);
        }
    }

    protected void method_5959() {
        this.method_5942().method_6354(true);
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(0, (class_1352)new PokemonBattleGoal(this));
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, class_1642.class, 8.0f, 0.5, 0.5));
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, class_1564.class, 12.0f, 0.5, 0.5));
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, class_1632.class, 8.0f, 0.5, 0.5));
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, class_1634.class, 8.0f, 0.5, 0.5));
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, class_1604.class, 15.0f, 0.5, 0.5));
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, class_1581.class, 12.0f, 0.5, 0.5));
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, class_5136.class, 10.0f, 0.5, 0.5));
        this.field_6201.method_6277(2, (class_1352)new class_1374((class_1314)this, 0.5));
        this.field_6201.method_6277(4, (class_1352)new LookAtPlayerAndWaitGoal((class_1308)this, class_1309.class, 2.0f, 0.04f, 160, 320));
        this.field_6201.method_6277(4, (class_1352)new LookAtPlayerAndWaitGoal((class_1308)this, class_1309.class, 4.0f, 0.004f, 80, 160));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1309.class, 8.0f));
        this.field_6201.method_6277(6, (class_1352)new RandomStrollAwayGoal(this, 0.35, () -> Float.valueOf(0.0025f), m -> {
            TrainerMob tr = (TrainerMob)((Object)m);
            return !tr.canBattle() && tr.getCooldown() == 0;
        }));
        this.field_6201.method_6277(8, (class_1352)new MoveCloseToTargetGoal(this, 0.35, () -> Float.valueOf(this.requiredBy(this.method_5968()) ? 0.25f : 0.0025f), 2 * RCTMod.get().getServerConfig().maxHorizontalDistanceToPlayers()));
        this.field_6201.method_6277(10, (class_1352)new RandomStrollThroughVillageGoal(this, 0.35f, () -> Float.valueOf(0.0025f)));
        this.field_6201.method_6277(12, (class_1352)new class_1394((class_1314)this, 0.35));
    }

    public boolean requiredBy(class_1309 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            PlayerState plState = PlayerState.get(player);
            TrainerMobData trMob = RCTMod.get().getTrainerManager().getData(this);
            TrainerMobData.Type type = trMob.getType();
            return (type == TrainerMobData.Type.BOSS || type == TrainerMobData.Type.LEADER || type == TrainerMobData.Type.E4 || type == TrainerMobData.Type.CHAMP || trMob.getRewardLevelCap() > plState.getLevelCap()) && plState.getTrainerDefeatCount(this.getTrainerId()) == 0;
        }
        return false;
    }
}

