/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.fabric.server;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.fabric.CobblemonTrainersRegistry;
import com.gitlab.srcmc.rctmod.fabric.network.Packets;
import dev.architectury.registry.ReloadListenerRegistry;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ModServer {
    public static void init() {
        ServerLifecycleEvents.SERVER_STARTED.register(ModServer::onServerStarted);
        ServerTickEvents.START_WORLD_TICK.register(ModServer::onServerWorldTick);
        ServerTickEvents.START_SERVER_TICK.register(ModServer::onServerTick);
        ForgeConfigRegistry.INSTANCE.register("rctmod", ModConfig.Type.SERVER, (IConfigSpec)RCTMod.get().getServerConfig().getSpec());
        ReloadListenerRegistry.register((class_3264)class_3264.field_14190, (class_3302)RCTMod.get().getTrainerManager());
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Packets.PLAYER_PING, ModServer::handleReceivedPlayerPing);
    }

    static void onServerStarted(MinecraftServer server) {
        CobblemonTrainersRegistry.registerTrainers();
        RCTMod.get().getTrainerSpawner().init(server.method_30002());
    }

    static void onServerTick(MinecraftServer server) {
        RCTMod.get().getTrainerSpawner().checkDespawns();
    }

    static void onServerWorldTick(class_3218 level) {
        level.method_18456().forEach(player -> {
            byte[] bytes;
            if (player.field_6012 % 60 == 0 && (bytes = PlayerState.get((class_1657)player).serializeUpdate()).length > 0) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)Packets.PLAYER_STATE, (class_2540)PacketByteBufs.create().method_10813(bytes));
            }
        });
    }

    static void handleReceivedPlayerPing(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        server.execute(() -> RCTMod.get().getTrainerSpawner().attemptSpawnFor((class_1657)player));
    }
}

