/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.fabric.client;

import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.client.TrainerRenderer;
import com.gitlab.srcmc.rctmod.client.renderer.TargetArrowRenderer;
import com.gitlab.srcmc.rctmod.client.screens.ScreenManager;
import com.gitlab.srcmc.rctmod.fabric.ModFabric;
import com.gitlab.srcmc.rctmod.fabric.network.Packets;
import dev.architectury.registry.ReloadListenerRegistry;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_634;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

@Environment(value=EnvType.CLIENT)
public class ModClient
extends com.gitlab.srcmc.rctmod.client.ModClient
implements ClientModInitializer {
    private static Queue<byte[]> playerStateUpdates = new ConcurrentLinkedDeque<byte[]>();

    public void onInitializeClient() {
        EntityRendererRegistry.register(ModFabric.TRAINER, context -> new TrainerRenderer(context));
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)RCTMod.get().getClientDataManager());
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)RCTMod.get().getTrainerManager());
        ClientTickEvents.START_WORLD_TICK.register(ModClient::onClientWorldTick);
        ForgeConfigRegistry.INSTANCE.register("rctmod", ModConfig.Type.CLIENT, (IConfigSpec)RCTMod.get().getClientConfig().getSpec());
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Packets.PLAYER_STATE, ModClient::handleReceivedPlayerState);
        com.gitlab.srcmc.rctmod.client.ModClient.init(this);
        ModCommon.SCREENS = new ScreenManager();
        TargetArrowRenderer.init(() -> ModFabric.TRAINER_CARD);
    }

    @Override
    public Optional<class_1657> getLocalPlayer() {
        class_310 mc = class_310.method_1551();
        return Optional.of(mc.field_1724);
    }

    static void onClientWorldTick(class_1937 level) {
        class_310 mc = class_310.method_1551();
        byte[] psu = playerStateUpdates.poll();
        if (psu != null) {
            PlayerState.get((class_1657)mc.field_1724).deserializeUpdate(psu);
        }
        if (mc.field_1724.field_6012 % RCTMod.get().getServerConfig().spawnIntervalTicks() == 0) {
            ClientPlayNetworking.send((class_2960)Packets.PLAYER_PING, (class_2540)PacketByteBufs.empty());
        }
        TargetArrowRenderer.getInstance().tick();
    }

    static void handleReceivedPlayerState(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        if (!playerStateUpdates.offer(buf.method_10795())) {
            throw new IllegalStateException("Failed to store player state updates");
        }
    }
}

