/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.fabric.api.services;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.service.IPlayerController;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import com.selfdot.cobblemontrainers.CobblemonTrainers;
import com.selfdot.cobblemontrainers.trainer.Trainer;
import com.selfdot.cobblemontrainers.util.PokemonUtility;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public class PlayerController
implements IPlayerController {
    @Override
    public int getPlayerLevel(class_1657 player) {
        int maxLevel = 0;
        for (Pokemon pk : Cobblemon.INSTANCE.getStorage().getParty((class_3222)player)) {
            maxLevel = Math.max(maxLevel, pk.getLevel());
        }
        return maxLevel;
    }

    @Override
    public int getActivePokemonCount(class_1657 player) {
        int count = 0;
        for (Pokemon pk : Cobblemon.INSTANCE.getStorage().getParty((class_3222)player)) {
            if (pk.isFainted()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isInBattle(class_1657 player) {
        return Cobblemon.INSTANCE.getBattleRegistry().getBattleByParticipatingPlayerId(player.method_5667()) != null;
    }

    @Override
    public void startBattle(TrainerMob trainer, class_1657 player) {
        PokemonUtility.startTrainerBattle((class_3222)((class_3222)player), (Trainer)CobblemonTrainers.INSTANCE.getTrainerRegistry().getTrainer(trainer.getTrainerId()), (class_1309)trainer);
    }

    @Override
    public void stopBattle(TrainerMob trainer) {
        class_3222 opp = (class_3222)trainer.getOpponent();
        if (opp != null) {
            PokemonBattle battle = Cobblemon.INSTANCE.getBattleRegistry().getBattleByParticipatingPlayer(opp);
            if (battle == null) {
                ModCommon.LOG.error(String.format("Player '%s' is not in a battle", opp.method_5476().getString()));
            } else {
                battle.stop();
            }
        }
    }
}

