/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.config;

import com.gitlab.srcmc.rctmod.api.config.IClientConfig;
import com.gitlab.srcmc.rctmod.config.ForgeConfig;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ClientConfig
extends ForgeConfig
implements IClientConfig {
    private ForgeConfigSpec.ConfigValue<Boolean> showTrainerTypeSymbolsValue;
    private ForgeConfigSpec.ConfigValue<Boolean> showTrainerTypeColorsValue;
    private ForgeConfigSpec.ConfigValue<Integer> trainerCardPaddingValue;
    private ForgeConfigSpec.ConfigValue<Double> trainerCardAlignmentXValue;
    private ForgeConfigSpec.ConfigValue<Double> trainerCardAlignmentYValue;
    private ForgeConfigSpec spec;

    public ClientConfig() {
        super(ModConfig.Type.CLIENT);
        ForgeConfigSpec.Builder builder = ClientConfig.createBuilder();
        builder.push("Trainers");
        this.showTrainerTypeSymbolsValue = builder.comment("Determines if symbols for trainer types are shown next to trainer names.").define("showTrainerTypeSymbols", IClientConfig.super.showTrainerTypeSymbols());
        this.showTrainerTypeColorsValue = builder.comment("Determines if trainer names are colored based of their type.").define("showTrainerTypeColors", IClientConfig.super.showTrainerTypeColors());
        builder.pop();
        builder.push("Trainer Card");
        this.trainerCardPaddingValue = builder.comment("Padding of the trainer card gui.").defineInRange("trainerCardPadding", IClientConfig.super.trainerCardPadding(), 0, 0x7FFFFFFE);
        this.trainerCardAlignmentXValue = builder.comment("Horizontal alignment of the trainer card gui, i.e. 0=left, 0.5=center, 1=right.").defineInRange("trainerCardAlignmentX", (double)IClientConfig.super.trainerCardAlignmentX(), 0.0, 1.0);
        this.trainerCardAlignmentYValue = builder.comment("Vertical alignment of the trainer card gui, i.e. 0=top, 0.5=center, 1=bottom.").defineInRange("trainerCardAlignmentY", (double)IClientConfig.super.trainerCardAlignmentY(), 0.0, 1.0);
        this.spec = builder.build();
    }

    @Override
    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    @Override
    public boolean showTrainerTypeSymbols() {
        return (Boolean)this.showTrainerTypeSymbolsValue.get();
    }

    @Override
    public boolean showTrainerTypeColors() {
        return (Boolean)this.showTrainerTypeColorsValue.get();
    }

    @Override
    public int trainerCardPadding() {
        return (Integer)this.trainerCardPaddingValue.get();
    }

    @Override
    public float trainerCardAlignmentX() {
        return ((Double)this.trainerCardAlignmentXValue.get()).floatValue();
    }

    @Override
    public float trainerCardAlignmentY() {
        return ((Double)this.trainerCardAlignmentYValue.get()).floatValue();
    }
}

