/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.commands;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public final class PlayerCommands {
    private PlayerCommands() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rctmod").requires(css -> css.method_9259(1))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"player").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"get").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"level_cap").executes(PlayerCommands::player_get_level_cap)).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(PlayerCommands::player_get_level_cap_target)))).then(class_2170.method_9247((String)"defeats").then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"trainerId", (ArgumentType)StringArgumentType.string()).suggests(PlayerCommands::get_trainer_suggestions).executes(PlayerCommands::player_get_defeats)).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(PlayerCommands::player_get_defeats_target))))).then(class_2170.method_9247((String)"type_defeats").then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"type", (ArgumentType)StringArgumentType.string()).suggests(PlayerCommands::get_type_suggestions).executes(PlayerCommands::player_get_type_defeats)).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(PlayerCommands::player_get_type_defeats_target)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"set").requires(css -> css.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"level_cap").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(PlayerCommands::player_set_level_cap_value))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(PlayerCommands::player_set_level_cap_targets_value))))).then(class_2170.method_9247((String)"defeats").then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"trainerId", (ArgumentType)StringArgumentType.string()).suggests(PlayerCommands::get_trainer_suggestions).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(PlayerCommands::player_set_defeats_value))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(PlayerCommands::player_set_defeats_targets_value))))))));
    }

    private static CompletableFuture<Suggestions> get_trainer_suggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        RCTMod.get().getTrainerManager().getAllData().map(e -> (String)e.getKey()).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static CompletableFuture<Suggestions> get_type_suggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        Stream.of(TrainerMobData.Type.values()).map(Enum::name).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static int player_get_level_cap(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            int level_cap = RCTMod.get().getTrainerManager().getData(player).getLevelCap();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(level_cap)), false);
            return level_cap;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"caller is not a player"));
        return -1;
    }

    private static int player_get_level_cap_target(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = class_2186.method_9315(context, (String)"target");
        int level_cap = RCTMod.get().getTrainerManager().getData((class_1657)player).getLevelCap();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(level_cap)), false);
        return level_cap;
    }

    private static int player_get_defeats(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            try {
                String trainerId = (String)context.getArgument("trainerId", String.class);
                int count = PlayerState.get(player).getTrainerDefeatCount(trainerId);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(count)), false);
                return count;
            }
            catch (IllegalArgumentException e) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)e.getMessage()));
            }
        } else {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"caller is not a player"));
        }
        return -1;
    }

    private static int player_get_defeats_target(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            String trainerId = (String)context.getArgument("trainerId", String.class);
            class_3222 player = class_2186.method_9315(context, (String)"target");
            int count = PlayerState.get((class_1657)player).getTrainerDefeatCount(trainerId);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(count)), false);
            return count;
        }
        catch (IllegalArgumentException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)e.getMessage()));
            return -1;
        }
    }

    private static int player_get_type_defeats(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            try {
                TrainerMobData.Type type = TrainerMobData.Type.valueOf((String)context.getArgument("type", String.class));
                long count = PlayerState.get(player).getTypeDefeatCount(type);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(count)), false);
                return (int)count;
            }
            catch (IllegalArgumentException e) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)e.getMessage()));
            }
        } else {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"caller is not a player"));
        }
        return -1;
    }

    private static int player_get_type_defeats_target(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            TrainerMobData.Type type = TrainerMobData.Type.valueOf((String)context.getArgument("type", String.class));
            class_3222 player = class_2186.method_9315(context, (String)"target");
            long count = PlayerState.get((class_1657)player).getTypeDefeatCount(type);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.valueOf(count)), false);
            return (int)count;
        }
        catch (IllegalArgumentException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)e.getMessage()));
            return -1;
        }
    }

    private static int player_set_level_cap_value(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            int level_cap = IntegerArgumentType.getInteger(context, (String)"value");
            RCTMod.get().getTrainerManager().getData(player).setLevelCap(player, level_cap);
            return level_cap;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"caller is not a player"));
        return -1;
    }

    private static int player_set_level_cap_targets_value(CommandContext<class_2168> context) throws CommandSyntaxException {
        Collection targets = class_2186.method_9312(context, (String)"targets");
        int level_cap = IntegerArgumentType.getInteger(context, (String)"value");
        TrainerManager tm = RCTMod.get().getTrainerManager();
        for (class_3222 player : targets) {
            tm.getData((class_1657)player).setLevelCap((class_1657)player, level_cap);
        }
        return level_cap;
    }

    private static int player_set_defeats_value(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_1297 class_12972 = ((class_2168)context.getSource()).method_9228();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            try {
                String trainerId = (String)context.getArgument("trainerId", String.class);
                int count = IntegerArgumentType.getInteger(context, (String)"value");
                RCTMod.get().getTrainerManager().getBattleMemory((class_3218)player.method_37908(), trainerId).setDefeatedBy(trainerId, player, count);
                return count;
            }
            catch (IllegalArgumentException e) {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)e.getMessage()));
            }
        } else {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"caller is not a player"));
        }
        return -1;
    }

    private static int player_set_defeats_targets_value(CommandContext<class_2168> context) throws CommandSyntaxException {
        try {
            String trainerId = (String)context.getArgument("trainerId", String.class);
            Collection targets = class_2186.method_9312(context, (String)"targets");
            int count = IntegerArgumentType.getInteger(context, (String)"value");
            TrainerManager tm = RCTMod.get().getTrainerManager();
            for (class_3222 player : targets) {
                tm.getBattleMemory((class_3218)player.method_37908(), trainerId).setDefeatedBy(trainerId, (class_1657)player, count);
            }
            return count;
        }
        catch (IllegalArgumentException e) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)e.getMessage()));
            return -1;
        }
    }
}

