/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.client.screens.widgets;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.config.IServerConfig;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.client.screens.widgets.TrainerDataWidget;
import com.gitlab.srcmc.rctmod.client.screens.widgets.TrainerListWidget;
import com.gitlab.srcmc.rctmod.client.screens.widgets.text.MultiStyleStringWidget;
import com.gitlab.srcmc.rctmod.client.screens.widgets.text.TextUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_7842;
import net.minecraft.class_7924;

public class TrainerInfoWidget
extends TrainerDataWidget {
    private static final int MAX_NAME_LENGTH = 20;
    private static final int MAX_SPECIES_LENGTH = 28;
    private static final int MAX_BIOME_LENGTH = 28;
    private Consumer<Integer> backClickedHandler;
    private String trainerId;
    private int page;
    private TrainerMobData trainer;
    private int innerHeight;
    private int w;
    private int h;
    private int y;
    private List<PageContent> contents = new ArrayList<PageContent>();
    private TrainerDataWidget.HoverElement<MultiStyleStringWidget> back;
    private class_7842 number;
    private class_7842 name;
    private class_7842 aka;
    private class_7842 identity;

    public TrainerInfoWidget(int x, int y, int w, int h, class_327 font) {
        super(x, y, w, h, font);
    }

    public void initTrainerInfo(int trainerNr, String trainerId, TrainerListWidget.EntryState entryState) {
        this.trainer = RCTMod.get().getTrainerManager().getData(trainerId);
        this.trainerId = trainerId;
        this.w = (int)((float)(this.method_25368() - this.method_44385()) / 0.65f);
        this.h = this.method_25364() / 6;
        this.y = 0;
        String displayName = TextUtils.trim(entryState == TrainerListWidget.EntryState.UNKNOWN ? "???" : this.trainer.getTeam().getDisplayName(), 20);
        String identity = TextUtils.trim(entryState == TrainerListWidget.EntryState.UNKNOWN ? "???" : this.trainer.getTeam().getIdentity(), 20);
        int backX = (int)((double)this.w * 0.92);
        this.back = new TrainerDataWidget.HoverElement((TrainerDataWidget)this, (class_4068)new MultiStyleStringWidget(backX, this.y, this.w - backX, this.h, (class_2561)TrainerInfoWidget.toComponent("[X]"), this.font).addStyle(class_2583.field_24360.method_10977(class_124.field_1061)).alignRight(), msw -> msw.setStyle(1), msw -> msw.setStyle(0));
        this.number = new class_7842(0, this.y, this.w, this.h, (class_2561)TrainerInfoWidget.toComponent(String.format("%04d: ", trainerNr)), this.font).method_48596();
        this.name = new class_7842((int)((double)this.w * 0.18), this.y, (int)((double)this.w * 0.72), this.h, (class_2561)(entryState == TrainerListWidget.EntryState.HIDDEN ? TrainerInfoWidget.toComponent(displayName).method_27692(class_124.field_1051) : TrainerInfoWidget.toComponent(displayName)), this.font).method_48596();
        if (entryState != TrainerListWidget.EntryState.DISCOVERED || identity.equals(displayName)) {
            this.identity = null;
            this.aka = null;
        } else {
            this.aka = new class_7842(0, this.y += this.h, this.w, this.h, (class_2561)TrainerInfoWidget.toComponent("aka"), this.font).method_48596();
            this.identity = new class_7842((int)((double)this.w * 0.18), this.y, this.w, this.h, (class_2561)(entryState == TrainerListWidget.EntryState.HIDDEN ? TrainerInfoWidget.toComponent(identity).method_27692(class_124.field_1051) : TrainerInfoWidget.toComponent(identity)), this.font).method_48596();
        }
        ((MultiStyleStringWidget)((Object)this.back.element)).field_22763 = true;
        this.contents.clear();
        this.contents.add(this.initOverviewPage());
        if (entryState != TrainerListWidget.EntryState.UNKNOWN) {
            this.contents.add(this.initSpawningPage());
        }
        if (entryState == TrainerListWidget.EntryState.DISCOVERED) {
            this.contents.add(this.initTeamPage());
        }
        this.setPage(0);
        this.updateInnerHeight();
    }

    private PageContent initPage(String title) {
        PageContent pc = new PageContent(title, new class_4068[]{this.number, this.name, this.back});
        if (this.identity != null) {
            pc.renderables.add((class_4068)this.aka);
            pc.renderables.add((class_4068)this.identity);
        }
        return pc;
    }

    private PageContent initOverviewPage() {
        PageContent pc = this.initPage("Overview");
        this.y = this.identity == null ? 0 : this.h;
        pc.renderables.add((class_4068)new class_7842(8, this.y += this.h, this.w, this.h, (class_2561)TrainerInfoWidget.toComponent("Type: "), this.font).method_48596());
        pc.renderables.add((class_4068)new class_7842(8, this.y, (int)((double)this.w * 0.9), this.h, (class_2561)TrainerInfoWidget.toComponent(this.trainer.getType().name()), this.font).method_48599());
        pc.renderables.add((class_4068)new class_7842(8, this.y += this.h, this.w, this.h, (class_2561)TrainerInfoWidget.toComponent("Rew. Level Cap: "), this.font).method_48596());
        pc.renderables.add((class_4068)new class_7842(8, this.y, (int)((double)this.w * 0.9), this.h, (class_2561)TrainerInfoWidget.toComponent(this.trainer.getRewardLevelCap()), this.font).method_48599());
        pc.renderables.add((class_4068)new class_7842(8, this.y += this.h, this.w, this.h, (class_2561)TrainerInfoWidget.toComponent("Req. Level Cap: "), this.font).method_48596());
        pc.renderables.add((class_4068)new class_7842(8, this.y, (int)((double)this.w * 0.9), this.h, (class_2561)TrainerInfoWidget.toComponent(this.trainer.getRequiredLevelCap()), this.font).method_48599());
        for (TrainerMobData.Type type : TrainerMobData.Type.values()) {
            int c = this.trainer.getRequiredDefeats(type);
            if (c <= 0) continue;
            pc.renderables.add((class_4068)new class_7842(8, this.y += this.h, this.w, this.h, (class_2561)TrainerInfoWidget.toComponent(String.format("Req. %s: ", type.name())), this.font).method_48596());
            pc.renderables.add((class_4068)new class_7842(8, this.y, (int)((double)this.w * 0.9), this.h, (class_2561)TrainerInfoWidget.toComponent(c), this.font).method_48599());
        }
        pc.height = this.y + this.h;
        return pc;
    }

    private PageContent initSpawningPage() {
        PageContent pc = this.initPage("Spawning");
        class_310 mc = class_310.method_1551();
        class_2378 reg = mc.field_1687.method_30349().method_30530(class_7924.field_41236);
        IServerConfig config = RCTMod.get().getServerConfig();
        PriorityQueue biomes = new PriorityQueue((r1, r2) -> {
            int i = r1.method_12836().compareTo(r2.method_12836());
            return i == 0 ? r1.method_12832().compareTo(r2.method_12832()) : i;
        });
        this.y = this.identity == null ? 0 : this.h;
        reg.method_40270().forEach(holder -> {
            block2: {
                block4: {
                    Set tags;
                    block3: {
                        tags = holder.method_40228().map(t -> t.comp_327().method_12836() + ":" + t.comp_327().method_12832()).collect(Collectors.toSet());
                        holder.method_40228().map(t -> t.comp_327().method_12832()).forEach(t -> tags.add(t));
                        if (!config.biomeTagBlacklist().stream().noneMatch(tags::contains)) break block2;
                        if (!this.trainer.getBiomeTagBlacklist().stream().noneMatch(tags::contains)) break block2;
                        if (config.biomeTagWhitelist().isEmpty()) break block3;
                        if (!config.biomeTagWhitelist().stream().anyMatch(tags::contains)) break block2;
                    }
                    if (this.trainer.getBiomeTagWhitelist().isEmpty()) break block4;
                    if (!this.trainer.getBiomeTagWhitelist().stream().anyMatch(tags::contains)) break block2;
                }
                biomes.offer((class_2960)holder.method_40229().map(r -> r.method_29177(), b -> new class_2960("[unregistered]", b.toString())));
            }
        });
        String namespace = "";
        while (!biomes.isEmpty()) {
            class_2960 rs = (class_2960)biomes.poll();
            if (!namespace.equals(rs.method_12836())) {
                pc.renderables.add((class_4068)new class_7842(8, this.y += this.h, this.w, this.h, (class_2561)TrainerInfoWidget.toComponent(TextUtils.trim(rs.method_12836(), 28)), this.font).method_48596());
                namespace = rs.method_12836();
            }
            pc.renderables.add((class_4068)new class_7842(16, this.y += this.h, this.w, this.h, (class_2561)TrainerInfoWidget.toComponent(TextUtils.trim(rs.method_12832(), 28)), this.font).method_48596());
        }
        pc.height = this.y + this.h;
        return pc;
    }

    private PageContent initTeamPage() {
        PageContent pc = this.initPage("Team");
        this.y = this.identity == null ? 0 : this.h;
        pc.height = this.y + this.h;
        this.trainer.getTeam().getMembers().forEach(poke -> {
            pc.renderables.add((class_4068)new class_7842(8, this.y += this.h, this.w, this.h, (class_2561)TrainerInfoWidget.toComponent(TextUtils.trim(poke.getSpecies().split(":")[1], 28)), this.font).method_48596());
            pc.renderables.add((class_4068)new class_7842(8, this.y, (int)((double)this.w * 0.9), this.h, (class_2561)TrainerInfoWidget.toComponent(poke.getLevel()), this.font).method_48599());
        });
        return pc;
    }

    public String getTrainerId() {
        return this.trainerId;
    }

    public PageContent getPageContent(int page) {
        return this.contents.get(page);
    }

    @Override
    protected void renderPage(class_332 guiGraphics, int x, int y, float f) {
        for (class_4068 r : this.getPageContent((int)this.getPage()).renderables) {
            r.method_25394(guiGraphics, x, y, f);
        }
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public int getMaxPage() {
        return this.contents.size() - 1;
    }

    @Override
    public void setPage(int page) {
        if (page != this.page) {
            this.page = Math.max(0, Math.min(this.contents.size() - 1, page));
            this.updateInnerHeight();
            this.method_44382(0.0);
        }
    }

    public void setOnBackClicked(Consumer<Integer> backClickedHandler) {
        this.backClickedHandler = backClickedHandler;
    }

    @Override
    protected int method_44391() {
        return (int)((float)this.innerHeight * 0.65f);
    }

    private void updateInnerHeight() {
        this.innerHeight = Math.max(this.method_25364() - this.method_44385(), this.getPageContent((int)this.getPage()).height);
    }

    public boolean method_25402(double x, double y, int i) {
        if (super.method_25402(x, y, i)) {
            if (this.backClickedHandler != null && ((MultiStyleStringWidget)((Object)this.back.element)).method_25402(x = this.localX(x), y = this.localY(y), i)) {
                this.backClickedHandler.accept(i);
            }
            return true;
        }
        return false;
    }

    public class PageContent {
        public final class_2561 title;
        public final List<class_4068> renderables = new ArrayList<class_4068>();
        protected int height;

        private PageContent(String title, class_4068 ... renderables) {
            this.title = class_2561.method_43470((String)title);
            for (class_4068 r : renderables) {
                this.renderables.add(r);
            }
        }
    }
}

